/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.filter;

import com.primeton.pmq.command.PMQDestination;
import com.primeton.pmq.filter.DestinationFilter;

public class CompositeDestinationFilter
extends DestinationFilter {
    private DestinationFilter[] filters;

    public CompositeDestinationFilter(PMQDestination destination) {
        PMQDestination[] destinations = destination.getCompositeDestinations();
        this.filters = new DestinationFilter[destinations.length];
        for (int i = 0; i < destinations.length; ++i) {
            PMQDestination childDestination = destinations[i];
            this.filters[i] = DestinationFilter.parseFilter(childDestination);
        }
    }

    @Override
    public boolean matches(PMQDestination destination) {
        for (int i = 0; i < this.filters.length; ++i) {
            if (!this.filters[i].matches(destination)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isWildcard() {
        for (DestinationFilter filter : this.filters) {
            if (!filter.isWildcard()) continue;
            return true;
        }
        return false;
    }
}

