/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.leveldb.record;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.fusesource.hawtbuf.proto.CodedInputStream;
import org.fusesource.hawtbuf.proto.CodedOutputStream;
import org.fusesource.hawtbuf.proto.InvalidProtocolBufferException;
import org.fusesource.hawtbuf.proto.MessageBuffer;
import org.fusesource.hawtbuf.proto.MessageBufferSupport;
import org.fusesource.hawtbuf.proto.PBMessage;
import org.fusesource.hawtbuf.proto.PBMessageFactory;
import org.fusesource.hawtbuf.proto.PBMessageFramedCodec;
import org.fusesource.hawtbuf.proto.PBMessageUnframedCodec;

public class EntryKey
implements PBMessageFactory<Bean, Buffer> {
    public static final EntryKey FACTORY = new EntryKey();
    public static final PBMessageFramedCodec<Buffer> FRAMED_CODEC = new PBMessageFramedCodec((PBMessageFactory)FACTORY);
    public static final PBMessageUnframedCodec<Buffer> UNFRAMED_CODEC = new PBMessageUnframedCodec((PBMessageFactory)FACTORY);

    public Bean create() {
        return new Bean();
    }

    public Bean parseUnframed(CodedInputStream data) throws InvalidProtocolBufferException, IOException {
        return new Bean().mergeUnframed(data);
    }

    public Bean parseUnframed(InputStream data) throws InvalidProtocolBufferException, IOException {
        return this.parseUnframed(new CodedInputStream(data));
    }

    public Buffer parseUnframed(org.fusesource.hawtbuf.Buffer data) throws InvalidProtocolBufferException {
        return new Buffer(data);
    }

    public Buffer parseUnframed(byte[] data) throws InvalidProtocolBufferException {
        return this.parseUnframed(new org.fusesource.hawtbuf.Buffer(data));
    }

    public Buffer parseFramed(CodedInputStream data) throws InvalidProtocolBufferException, IOException {
        int length = data.readRawVarint32();
        int oldLimit = data.pushLimit(length);
        Buffer rc = this.parseUnframed(data.readRawBytes(length));
        data.popLimit(oldLimit);
        return rc;
    }

    public Buffer parseFramed(org.fusesource.hawtbuf.Buffer data) throws InvalidProtocolBufferException {
        try {
            CodedInputStream input = new CodedInputStream(data);
            Buffer rc = this.parseFramed(input);
            input.checkLastTagWas(0);
            return rc;
        }
        catch (InvalidProtocolBufferException e) {
            throw e;
        }
        catch (IOException e) {
            throw new RuntimeException("An IOException was thrown (should never happen in this method).", e);
        }
    }

    public Buffer parseFramed(byte[] data) throws InvalidProtocolBufferException {
        return this.parseFramed(new org.fusesource.hawtbuf.Buffer(data));
    }

    public Buffer parseFramed(InputStream data) throws InvalidProtocolBufferException, IOException {
        return this.parseUnframed(MessageBufferSupport.readFrame((InputStream)data));
    }

    public static final class Buffer
    implements MessageBuffer<Bean, Buffer>,
    Getter {
        private Bean bean;
        private org.fusesource.hawtbuf.Buffer buffer;
        private int size = -1;
        private int hashCode;

        private Buffer(org.fusesource.hawtbuf.Buffer buffer) {
            this.buffer = buffer;
        }

        private Buffer(Bean bean) {
            this.bean = bean;
        }

        @Override
        public Bean copy() {
            return this.bean().copy();
        }

        @Override
        public Buffer freeze() {
            return this;
        }

        private Bean bean() {
            if (this.bean == null) {
                try {
                    this.bean = new Bean().mergeUnframed(new CodedInputStream(this.buffer));
                    this.bean.frozen = this;
                }
                catch (InvalidProtocolBufferException e) {
                    throw new RuntimeException(e);
                }
                catch (IOException e) {
                    throw new RuntimeException("An IOException was thrown (should never happen in this method).", e);
                }
            }
            return this.bean;
        }

        public String toString() {
            return this.bean().toString();
        }

        @Override
        public StringBuilder toString(StringBuilder sb, String prefix) {
            return this.bean().toString(sb, prefix);
        }

        @Override
        public boolean hasCollectionKey() {
            return this.bean().hasCollectionKey();
        }

        @Override
        public long getCollectionKey() {
            return this.bean().getCollectionKey();
        }

        @Override
        public boolean hasEntryKey() {
            return this.bean().hasEntryKey();
        }

        @Override
        public org.fusesource.hawtbuf.Buffer getEntryKey() {
            return this.bean().getEntryKey();
        }

        public org.fusesource.hawtbuf.Buffer toUnframedBuffer() {
            if (this.buffer != null) {
                return this.buffer;
            }
            return MessageBufferSupport.toUnframedBuffer((MessageBuffer)this);
        }

        public org.fusesource.hawtbuf.Buffer toFramedBuffer() {
            return MessageBufferSupport.toFramedBuffer((MessageBuffer)this);
        }

        public byte[] toUnframedByteArray() {
            return this.toUnframedBuffer().toByteArray();
        }

        public byte[] toFramedByteArray() {
            return this.toFramedBuffer().toByteArray();
        }

        public void writeFramed(CodedOutputStream output) throws IOException {
            output.writeRawVarint32(this.serializedSizeUnframed());
            this.writeUnframed(output);
        }

        public void writeFramed(OutputStream output) throws IOException {
            CodedOutputStream codedOutput = new CodedOutputStream(output);
            this.writeFramed(codedOutput);
            codedOutput.flush();
        }

        public void writeUnframed(OutputStream output) throws IOException {
            CodedOutputStream codedOutput = new CodedOutputStream(output);
            this.writeUnframed(codedOutput);
            codedOutput.flush();
        }

        public void writeUnframed(CodedOutputStream output) throws IOException {
            if (this.buffer == null) {
                int size2 = this.serializedSizeUnframed();
                this.buffer = output.getNextBuffer(size2);
                CodedOutputStream original = null;
                if (this.buffer == null) {
                    this.buffer = new org.fusesource.hawtbuf.Buffer(new byte[size2]);
                    original = output;
                    output = new CodedOutputStream(this.buffer);
                }
                output.writeInt64(1, this.bean.getCollectionKey());
                output.writeBytes(2, this.bean.getEntryKey());
                if (original != null) {
                    output.checkNoSpaceLeft();
                    output = original;
                    output.writeRawBytes(this.buffer);
                }
            } else {
                output.writeRawBytes(this.buffer);
            }
        }

        public int serializedSizeFramed() {
            int t = this.serializedSizeUnframed();
            return CodedOutputStream.computeRawVarint32Size((int)t) + t;
        }

        public int serializedSizeUnframed() {
            if (this.buffer != null) {
                return this.buffer.length;
            }
            if (this.size != -1) {
                return this.size;
            }
            this.size = 0;
            this.size += CodedOutputStream.computeInt64Size((int)1, (long)this.getCollectionKey());
            this.size += CodedOutputStream.computeBytesSize((int)2, (org.fusesource.hawtbuf.Buffer)this.getEntryKey());
            return this.size;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != Buffer.class) {
                return false;
            }
            return this.equals((Buffer)obj);
        }

        public boolean equals(Buffer obj) {
            return this.toUnframedBuffer().equals(obj.toUnframedBuffer());
        }

        public int hashCode() {
            if (this.hashCode == 0) {
                this.hashCode = 0x77408060 ^ this.toUnframedBuffer().hashCode();
            }
            return this.hashCode;
        }

        public boolean frozen() {
            return true;
        }
    }

    public static final class Bean
    implements Getter {
        Buffer frozen;
        Bean bean;
        private long f_collectionKey = 0L;
        private boolean b_collectionKey;
        private org.fusesource.hawtbuf.Buffer f_entryKey = null;

        public Bean() {
            this.bean = this;
        }

        public Bean(Bean copy) {
            this.bean = copy;
        }

        @Override
        public Bean copy() {
            return new Bean(this.bean);
        }

        public boolean frozen() {
            return this.frozen != null;
        }

        @Override
        public Buffer freeze() {
            if (this.frozen == null) {
                this.frozen = new Buffer(this.bean);
                assert (this.deepFreeze());
            }
            return this.frozen;
        }

        private boolean deepFreeze() {
            this.frozen.serializedSizeUnframed();
            return true;
        }

        private void copyCheck() {
            assert (this.frozen == null) : "Modification not allowed after object has been fozen.  Try modifying a copy of this object.";
            if (this.bean != this) {
                this.copy(this.bean);
            }
        }

        private void copy(Bean other) {
            this.bean = this;
            this.f_collectionKey = other.f_collectionKey;
            this.b_collectionKey = other.b_collectionKey;
            this.f_entryKey = other.f_entryKey;
        }

        @Override
        public boolean hasCollectionKey() {
            return this.bean.b_collectionKey;
        }

        @Override
        public long getCollectionKey() {
            return this.bean.f_collectionKey;
        }

        public Bean setCollectionKey(long collectionKey) {
            this.copyCheck();
            this.b_collectionKey = true;
            this.f_collectionKey = collectionKey;
            return this;
        }

        public void clearCollectionKey() {
            this.copyCheck();
            this.b_collectionKey = false;
            this.f_collectionKey = 0L;
        }

        @Override
        public boolean hasEntryKey() {
            return this.bean.f_entryKey != null;
        }

        @Override
        public org.fusesource.hawtbuf.Buffer getEntryKey() {
            return this.bean.f_entryKey;
        }

        public Bean setEntryKey(org.fusesource.hawtbuf.Buffer entryKey) {
            this.copyCheck();
            this.f_entryKey = entryKey;
            return this;
        }

        public void clearEntryKey() {
            this.copyCheck();
            this.f_entryKey = null;
        }

        public String toString() {
            return this.toString(new StringBuilder(), "").toString();
        }

        @Override
        public StringBuilder toString(StringBuilder sb, String prefix) {
            if (this.hasCollectionKey()) {
                sb.append(prefix + "collection_key: ");
                sb.append(this.getCollectionKey());
                sb.append("\n");
            }
            if (this.hasEntryKey()) {
                sb.append(prefix + "entry_key: ");
                sb.append(this.getEntryKey());
                sb.append("\n");
            }
            return sb;
        }

        public Bean mergeUnframed(InputStream input) throws IOException {
            return this.mergeUnframed(new CodedInputStream(input));
        }

        public Bean mergeUnframed(CodedInputStream input) throws IOException {
            this.copyCheck();
            int tag;
            block5: while (((tag = input.readTag()) & 7) != 4) {
                switch (tag) {
                    case 0: {
                        return this;
                    }
                    default: {
                        input.skipField(tag);
                        continue block5;
                    }
                    case 8: {
                        this.setCollectionKey(input.readInt64());
                        continue block5;
                    }
                    case 18: 
                }
                this.setEntryKey(input.readBytes());
            }
            return this;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != Bean.class) {
                return false;
            }
            return this.equals((Bean)obj);
        }

        public boolean equals(Bean obj) {
            if (this.hasCollectionKey() ^ obj.hasCollectionKey()) {
                return false;
            }
            if (this.hasCollectionKey() && this.getCollectionKey() != obj.getCollectionKey()) {
                return false;
            }
            if (this.hasEntryKey() ^ obj.hasEntryKey()) {
                return false;
            }
            return !this.hasEntryKey() || this.getEntryKey().equals(obj.getEntryKey());
        }

        public int hashCode() {
            int rc = 2066384;
            if (this.hasCollectionKey()) {
                rc ^= 0xFEABBAC1 ^ new Long(this.getCollectionKey()).hashCode();
            }
            if (this.hasEntryKey()) {
                rc ^= 0x870F54AD ^ this.getEntryKey().hashCode();
            }
            return rc;
        }

        public Bean mergeFrom(Getter other) {
            this.copyCheck();
            if (other.hasCollectionKey()) {
                this.setCollectionKey(other.getCollectionKey());
            }
            if (other.hasEntryKey()) {
                this.setEntryKey(other.getEntryKey());
            }
            return this;
        }

        public void clear() {
            this.clearCollectionKey();
            this.clearEntryKey();
        }

        public void readExternal(DataInput in) throws IOException {
            assert (this.frozen == null) : "Modification not allowed after object has been fozen.  Try modifying a copy of this object.";
            this.bean = this;
            this.frozen = null;
            this.f_collectionKey = in.readLong();
            this.b_collectionKey = true;
            int size2 = in.readInt();
            if (size2 >= 0) {
                byte[] b = new byte[size2];
                in.readFully(b);
                this.f_entryKey = new org.fusesource.hawtbuf.Buffer(b);
            } else {
                this.f_entryKey = null;
            }
        }

        public void writeExternal(DataOutput out) throws IOException {
            out.writeLong(this.bean.f_collectionKey);
            if (this.bean.f_entryKey != null) {
                out.writeInt(this.bean.f_entryKey.getLength());
                out.write(this.bean.f_entryKey.getData(), this.bean.f_entryKey.getOffset(), this.bean.f_entryKey.getLength());
            } else {
                out.writeInt(-1);
            }
        }
    }

    public static interface Getter
    extends PBMessage<Bean, Buffer> {
        public boolean hasCollectionKey();

        public long getCollectionKey();

        public boolean hasEntryKey();

        public org.fusesource.hawtbuf.Buffer getEntryKey();

        public Bean copy();

        public Buffer freeze();

        public StringBuilder toString(StringBuilder var1, String var2);
    }
}

