/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.memory.list;

import com.primeton.pmq.broker.region.MessageReference;
import com.primeton.pmq.broker.region.Subscription;
import com.primeton.pmq.command.Message;
import com.primeton.pmq.command.PMQDestination;
import com.primeton.pmq.command.PMQMessage;
import com.primeton.pmq.filter.DestinationMap;
import com.primeton.pmq.memory.buffer.MessageBuffer;
import com.primeton.pmq.memory.buffer.MessageQueue;
import com.primeton.pmq.memory.buffer.OrderBasedMessageBuffer;
import com.primeton.pmq.memory.list.MessageList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DestinationBasedMessageList
implements MessageList {
    private MessageBuffer messageBuffer;
    private Map<PMQDestination, MessageQueue> queueIndex = new HashMap<PMQDestination, MessageQueue>();
    private DestinationMap subscriptionIndex = new DestinationMap();
    private Object lock = new Object();

    public DestinationBasedMessageList(int maximumSize) {
        this(new OrderBasedMessageBuffer(maximumSize));
    }

    public DestinationBasedMessageList(MessageBuffer buffer) {
        this.messageBuffer = buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(MessageReference node) {
        PMQMessage message = (PMQMessage)node.getMessageHardRef();
        PMQDestination destination = message.getDestination();
        MessageQueue queue2 = null;
        Object object = this.lock;
        synchronized (object) {
            queue2 = this.queueIndex.get(destination);
            if (queue2 == null) {
                queue2 = this.messageBuffer.createMessageQueue();
                this.queueIndex.put(destination, queue2);
                this.subscriptionIndex.put(destination, queue2);
            }
        }
        queue2.add(node);
    }

    public List<MessageReference> getMessages(Subscription sub) {
        return this.getMessages(sub.getConsumerInfo().getDestination());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<MessageReference> getMessages(PMQDestination destination) {
        Set set = null;
        Object object = this.lock;
        synchronized (object) {
            set = this.subscriptionIndex.get(destination);
        }
        ArrayList<MessageReference> answer = new ArrayList<MessageReference>();
        for (MessageQueue queue2 : set) {
            queue2.appendMessages(answer);
        }
        return answer;
    }

    @Override
    public Message[] browse(PMQDestination destination) {
        List<MessageReference> result = this.getMessages(destination);
        return result.toArray(new Message[result.size()]);
    }

    @Override
    public void clear() {
        this.messageBuffer.clear();
    }
}

