/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.openwire.v11;

import com.primeton.pmq.openwire.DataStreamMarshaller;
import com.primeton.pmq.openwire.OpenWireFormat;
import com.primeton.pmq.openwire.v11.BrokerIdMarshaller;
import com.primeton.pmq.openwire.v11.BrokerInfoMarshaller;
import com.primeton.pmq.openwire.v11.ConnectionControlMarshaller;
import com.primeton.pmq.openwire.v11.ConnectionErrorMarshaller;
import com.primeton.pmq.openwire.v11.ConnectionIdMarshaller;
import com.primeton.pmq.openwire.v11.ConnectionInfoMarshaller;
import com.primeton.pmq.openwire.v11.ConsumerControlMarshaller;
import com.primeton.pmq.openwire.v11.ConsumerIdMarshaller;
import com.primeton.pmq.openwire.v11.ConsumerInfoMarshaller;
import com.primeton.pmq.openwire.v11.ControlCommandMarshaller;
import com.primeton.pmq.openwire.v11.DataArrayResponseMarshaller;
import com.primeton.pmq.openwire.v11.DataResponseMarshaller;
import com.primeton.pmq.openwire.v11.DestinationInfoMarshaller;
import com.primeton.pmq.openwire.v11.DiscoveryEventMarshaller;
import com.primeton.pmq.openwire.v11.ExceptionResponseMarshaller;
import com.primeton.pmq.openwire.v11.FlushCommandMarshaller;
import com.primeton.pmq.openwire.v11.IntegerResponseMarshaller;
import com.primeton.pmq.openwire.v11.JournalQueueAckMarshaller;
import com.primeton.pmq.openwire.v11.JournalTopicAckMarshaller;
import com.primeton.pmq.openwire.v11.JournalTraceMarshaller;
import com.primeton.pmq.openwire.v11.JournalTransactionMarshaller;
import com.primeton.pmq.openwire.v11.KeepAliveInfoMarshaller;
import com.primeton.pmq.openwire.v11.LastPartialCommandMarshaller;
import com.primeton.pmq.openwire.v11.LocalTransactionIdMarshaller;
import com.primeton.pmq.openwire.v11.MessageAckMarshaller;
import com.primeton.pmq.openwire.v11.MessageDispatchMarshaller;
import com.primeton.pmq.openwire.v11.MessageDispatchNotificationMarshaller;
import com.primeton.pmq.openwire.v11.MessageIdMarshaller;
import com.primeton.pmq.openwire.v11.MessagePullMarshaller;
import com.primeton.pmq.openwire.v11.NetworkBridgeFilterMarshaller;
import com.primeton.pmq.openwire.v11.PMQBlobMessageMarshaller;
import com.primeton.pmq.openwire.v11.PMQBytesMessageMarshaller;
import com.primeton.pmq.openwire.v11.PMQMapMessageMarshaller;
import com.primeton.pmq.openwire.v11.PMQMessageMarshaller;
import com.primeton.pmq.openwire.v11.PMQObjectMessageMarshaller;
import com.primeton.pmq.openwire.v11.PMQQueueMarshaller;
import com.primeton.pmq.openwire.v11.PMQStreamMessageMarshaller;
import com.primeton.pmq.openwire.v11.PMQTempQueueMarshaller;
import com.primeton.pmq.openwire.v11.PMQTempTopicMarshaller;
import com.primeton.pmq.openwire.v11.PMQTextMessageMarshaller;
import com.primeton.pmq.openwire.v11.PMQTopicMarshaller;
import com.primeton.pmq.openwire.v11.PartialCommandMarshaller;
import com.primeton.pmq.openwire.v11.ProducerAckMarshaller;
import com.primeton.pmq.openwire.v11.ProducerIdMarshaller;
import com.primeton.pmq.openwire.v11.ProducerInfoMarshaller;
import com.primeton.pmq.openwire.v11.RemoveInfoMarshaller;
import com.primeton.pmq.openwire.v11.RemoveSubscriptionInfoMarshaller;
import com.primeton.pmq.openwire.v11.ReplayCommandMarshaller;
import com.primeton.pmq.openwire.v11.ResponseMarshaller;
import com.primeton.pmq.openwire.v11.SessionIdMarshaller;
import com.primeton.pmq.openwire.v11.SessionInfoMarshaller;
import com.primeton.pmq.openwire.v11.ShutdownInfoMarshaller;
import com.primeton.pmq.openwire.v11.SubscriptionInfoMarshaller;
import com.primeton.pmq.openwire.v11.TransactionInfoMarshaller;
import com.primeton.pmq.openwire.v11.WireFormatInfoMarshaller;
import com.primeton.pmq.openwire.v11.XATransactionIdMarshaller;

public class MarshallerFactory {
    private static final DataStreamMarshaller[] marshaller = new DataStreamMarshaller[256];

    private static void add(DataStreamMarshaller dsm) {
        MarshallerFactory.marshaller[dsm.getDataStructureType()] = dsm;
    }

    public static DataStreamMarshaller[] createMarshallerMap(OpenWireFormat wireFormat) {
        return marshaller;
    }

    static {
        MarshallerFactory.add(new PMQBlobMessageMarshaller());
        MarshallerFactory.add(new PMQBytesMessageMarshaller());
        MarshallerFactory.add(new PMQMapMessageMarshaller());
        MarshallerFactory.add(new PMQMessageMarshaller());
        MarshallerFactory.add(new PMQObjectMessageMarshaller());
        MarshallerFactory.add(new PMQQueueMarshaller());
        MarshallerFactory.add(new PMQStreamMessageMarshaller());
        MarshallerFactory.add(new PMQTempQueueMarshaller());
        MarshallerFactory.add(new PMQTempTopicMarshaller());
        MarshallerFactory.add(new PMQTextMessageMarshaller());
        MarshallerFactory.add(new PMQTopicMarshaller());
        MarshallerFactory.add(new BrokerIdMarshaller());
        MarshallerFactory.add(new BrokerInfoMarshaller());
        MarshallerFactory.add(new ConnectionControlMarshaller());
        MarshallerFactory.add(new ConnectionErrorMarshaller());
        MarshallerFactory.add(new ConnectionIdMarshaller());
        MarshallerFactory.add(new ConnectionInfoMarshaller());
        MarshallerFactory.add(new ConsumerControlMarshaller());
        MarshallerFactory.add(new ConsumerIdMarshaller());
        MarshallerFactory.add(new ConsumerInfoMarshaller());
        MarshallerFactory.add(new ControlCommandMarshaller());
        MarshallerFactory.add(new DataArrayResponseMarshaller());
        MarshallerFactory.add(new DataResponseMarshaller());
        MarshallerFactory.add(new DestinationInfoMarshaller());
        MarshallerFactory.add(new DiscoveryEventMarshaller());
        MarshallerFactory.add(new ExceptionResponseMarshaller());
        MarshallerFactory.add(new FlushCommandMarshaller());
        MarshallerFactory.add(new IntegerResponseMarshaller());
        MarshallerFactory.add(new JournalQueueAckMarshaller());
        MarshallerFactory.add(new JournalTopicAckMarshaller());
        MarshallerFactory.add(new JournalTraceMarshaller());
        MarshallerFactory.add(new JournalTransactionMarshaller());
        MarshallerFactory.add(new KeepAliveInfoMarshaller());
        MarshallerFactory.add(new LastPartialCommandMarshaller());
        MarshallerFactory.add(new LocalTransactionIdMarshaller());
        MarshallerFactory.add(new MessageAckMarshaller());
        MarshallerFactory.add(new MessageDispatchMarshaller());
        MarshallerFactory.add(new MessageDispatchNotificationMarshaller());
        MarshallerFactory.add(new MessageIdMarshaller());
        MarshallerFactory.add(new MessagePullMarshaller());
        MarshallerFactory.add(new NetworkBridgeFilterMarshaller());
        MarshallerFactory.add(new PartialCommandMarshaller());
        MarshallerFactory.add(new ProducerAckMarshaller());
        MarshallerFactory.add(new ProducerIdMarshaller());
        MarshallerFactory.add(new ProducerInfoMarshaller());
        MarshallerFactory.add(new RemoveInfoMarshaller());
        MarshallerFactory.add(new RemoveSubscriptionInfoMarshaller());
        MarshallerFactory.add(new ReplayCommandMarshaller());
        MarshallerFactory.add(new ResponseMarshaller());
        MarshallerFactory.add(new SessionIdMarshaller());
        MarshallerFactory.add(new SessionInfoMarshaller());
        MarshallerFactory.add(new ShutdownInfoMarshaller());
        MarshallerFactory.add(new SubscriptionInfoMarshaller());
        MarshallerFactory.add(new TransactionInfoMarshaller());
        MarshallerFactory.add(new WireFormatInfoMarshaller());
        MarshallerFactory.add(new XATransactionIdMarshaller());
    }
}

