/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.openwire.v3;

import com.primeton.pmq.command.DataStructure;
import com.primeton.pmq.command.XATransactionId;
import com.primeton.pmq.openwire.BooleanStream;
import com.primeton.pmq.openwire.OpenWireFormat;
import com.primeton.pmq.openwire.v3.TransactionIdMarshaller;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class XATransactionIdMarshaller
extends TransactionIdMarshaller {
    @Override
    public byte getDataStructureType() {
        return 112;
    }

    @Override
    public DataStructure createObject() {
        return new XATransactionId();
    }

    @Override
    public void tightUnmarshal(OpenWireFormat wireFormat, Object o, DataInput dataIn, BooleanStream bs) throws IOException {
        super.tightUnmarshal(wireFormat, o, dataIn, bs);
        XATransactionId info = (XATransactionId)o;
        info.setFormatId(dataIn.readInt());
        info.setGlobalTransactionId(this.tightUnmarshalByteArray(dataIn, bs));
        info.setBranchQualifier(this.tightUnmarshalByteArray(dataIn, bs));
    }

    @Override
    public int tightMarshal1(OpenWireFormat wireFormat, Object o, BooleanStream bs) throws IOException {
        XATransactionId info = (XATransactionId)o;
        int rc = super.tightMarshal1(wireFormat, o, bs);
        rc += this.tightMarshalByteArray1(info.getGlobalTransactionId(), bs);
        return (rc += this.tightMarshalByteArray1(info.getBranchQualifier(), bs)) + 4;
    }

    @Override
    public void tightMarshal2(OpenWireFormat wireFormat, Object o, DataOutput dataOut, BooleanStream bs) throws IOException {
        super.tightMarshal2(wireFormat, o, dataOut, bs);
        XATransactionId info = (XATransactionId)o;
        dataOut.writeInt(info.getFormatId());
        this.tightMarshalByteArray2(info.getGlobalTransactionId(), dataOut, bs);
        this.tightMarshalByteArray2(info.getBranchQualifier(), dataOut, bs);
    }

    @Override
    public void looseUnmarshal(OpenWireFormat wireFormat, Object o, DataInput dataIn) throws IOException {
        super.looseUnmarshal(wireFormat, o, dataIn);
        XATransactionId info = (XATransactionId)o;
        info.setFormatId(dataIn.readInt());
        info.setGlobalTransactionId(this.looseUnmarshalByteArray(dataIn));
        info.setBranchQualifier(this.looseUnmarshalByteArray(dataIn));
    }

    @Override
    public void looseMarshal(OpenWireFormat wireFormat, Object o, DataOutput dataOut) throws IOException {
        XATransactionId info = (XATransactionId)o;
        super.looseMarshal(wireFormat, o, dataOut);
        dataOut.writeInt(info.getFormatId());
        this.looseMarshalByteArray(wireFormat, info.getGlobalTransactionId(), dataOut);
        this.looseMarshalByteArray(wireFormat, info.getBranchQualifier(), dataOut);
    }
}

