/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.openwire.v6;

import com.primeton.pmq.command.BaseCommand;
import com.primeton.pmq.openwire.BooleanStream;
import com.primeton.pmq.openwire.OpenWireFormat;
import com.primeton.pmq.openwire.v6.BaseDataStreamMarshaller;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public abstract class BaseCommandMarshaller
extends BaseDataStreamMarshaller {
    @Override
    public void tightUnmarshal(OpenWireFormat wireFormat, Object o, DataInput dataIn, BooleanStream bs) throws IOException {
        super.tightUnmarshal(wireFormat, o, dataIn, bs);
        BaseCommand info = (BaseCommand)o;
        info.setCommandId(dataIn.readInt());
        info.setResponseRequired(bs.readBoolean());
    }

    @Override
    public int tightMarshal1(OpenWireFormat wireFormat, Object o, BooleanStream bs) throws IOException {
        BaseCommand info = (BaseCommand)o;
        int rc = super.tightMarshal1(wireFormat, o, bs);
        bs.writeBoolean(info.isResponseRequired());
        return rc + 4;
    }

    @Override
    public void tightMarshal2(OpenWireFormat wireFormat, Object o, DataOutput dataOut, BooleanStream bs) throws IOException {
        super.tightMarshal2(wireFormat, o, dataOut, bs);
        BaseCommand info = (BaseCommand)o;
        dataOut.writeInt(info.getCommandId());
        bs.readBoolean();
    }

    @Override
    public void looseUnmarshal(OpenWireFormat wireFormat, Object o, DataInput dataIn) throws IOException {
        super.looseUnmarshal(wireFormat, o, dataIn);
        BaseCommand info = (BaseCommand)o;
        info.setCommandId(dataIn.readInt());
        info.setResponseRequired(dataIn.readBoolean());
    }

    @Override
    public void looseMarshal(OpenWireFormat wireFormat, Object o, DataOutput dataOut) throws IOException {
        BaseCommand info = (BaseCommand)o;
        super.looseMarshal(wireFormat, o, dataOut);
        dataOut.writeInt(info.getCommandId());
        dataOut.writeBoolean(info.isResponseRequired());
    }
}

