/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.protobuf.compiler;

import com.primeton.pmq.protobuf.compiler.EnumDescriptor;
import com.primeton.pmq.protobuf.compiler.MessageDescriptor;
import com.primeton.pmq.protobuf.compiler.OptionDescriptor;
import com.primeton.pmq.protobuf.compiler.ServiceDescriptor;
import com.primeton.pmq.protobuf.compiler.TypeDescriptor;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProtoDescriptor {
    private String packageName;
    private Map<String, OptionDescriptor> options = new LinkedHashMap<String, OptionDescriptor>();
    private Map<String, MessageDescriptor> messages = new LinkedHashMap<String, MessageDescriptor>();
    private Map<String, EnumDescriptor> enums = new LinkedHashMap<String, EnumDescriptor>();
    private List<MessageDescriptor> extendsList = new ArrayList<MessageDescriptor>();
    private Map<String, ServiceDescriptor> services = new LinkedHashMap<String, ServiceDescriptor>();
    List<String> imports = new ArrayList<String>();
    Map<String, ProtoDescriptor> importProtoDescriptors = new LinkedHashMap<String, ProtoDescriptor>();
    private String name;

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public void setOptions(Map<String, OptionDescriptor> options) {
        this.options = options;
    }

    public void setMessages(Map<String, MessageDescriptor> messages) {
        this.messages = messages;
    }

    public void setEnums(Map<String, EnumDescriptor> enums) {
        this.enums = enums;
    }

    public void setExtends(List<MessageDescriptor> extendsList) {
        this.extendsList = extendsList;
    }

    public List<MessageDescriptor> getExtends() {
        return this.extendsList;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public Map<String, OptionDescriptor> getOptions() {
        return this.options;
    }

    public Map<String, MessageDescriptor> getMessages() {
        return this.messages;
    }

    public Map<String, EnumDescriptor> getEnums() {
        return this.enums;
    }

    public void setServices(Map<String, ServiceDescriptor> services) {
        this.services = services;
    }

    public Map<String, ServiceDescriptor> getServices() {
        return this.services;
    }

    public void validate(List<String> errors) {
        for (ProtoDescriptor protoDescriptor : this.importProtoDescriptors.values()) {
            protoDescriptor.validate(errors);
        }
        for (OptionDescriptor optionDescriptor : this.options.values()) {
            optionDescriptor.validate(errors);
        }
        for (MessageDescriptor messageDescriptor : this.messages.values()) {
            messageDescriptor.validate(errors);
        }
        for (EnumDescriptor enumDescriptor : this.enums.values()) {
            enumDescriptor.validate(errors);
        }
        for (MessageDescriptor messageDescriptor : this.extendsList) {
            messageDescriptor.validate(errors);
        }
        for (ServiceDescriptor serviceDescriptor : this.services.values()) {
            serviceDescriptor.validate(errors);
        }
    }

    public List<String> getImports() {
        return this.imports;
    }

    public void setImports(List<String> imports) {
        this.imports = imports;
    }

    public Map<String, ProtoDescriptor> getImportProtoDescriptors() {
        return this.importProtoDescriptors;
    }

    public void setImportProtoDescriptors(Map<String, ProtoDescriptor> importProtoDescriptors) {
        this.importProtoDescriptors = importProtoDescriptors;
    }

    public TypeDescriptor getType(String type) {
        for (MessageDescriptor messageDescriptor : this.messages.values()) {
            if (type.equals(messageDescriptor.getName())) {
                return messageDescriptor;
            }
            if (!type.startsWith(messageDescriptor.getName() + ".")) continue;
            return messageDescriptor.getType(type.substring(messageDescriptor.getName().length() + 1));
        }
        for (EnumDescriptor enumDescriptor : this.enums.values()) {
            if (!type.equals(enumDescriptor.getName())) continue;
            return enumDescriptor;
        }
        for (ProtoDescriptor protoDescriptor : this.importProtoDescriptors.values()) {
            if (protoDescriptor.getPackageName() == null || !type.startsWith(protoDescriptor.getPackageName() + ".")) continue;
            return protoDescriptor.getType(type.substring(protoDescriptor.getPackageName().length() + 1));
        }
        for (ProtoDescriptor protoDescriptor : this.importProtoDescriptors.values()) {
            TypeDescriptor rc = protoDescriptor.getType(type);
            if (rc == null) continue;
            return rc;
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

