/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.security;

import com.primeton.pmq.broker.Broker;
import com.primeton.pmq.broker.BrokerFilter;
import com.primeton.pmq.broker.ConnectionContext;
import com.primeton.pmq.command.ConnectionInfo;
import com.primeton.pmq.command.PMQDestination;
import com.primeton.pmq.security.AuthenticationBroker;
import com.primeton.pmq.security.SecurityContext;
import java.util.concurrent.CopyOnWriteArrayList;

public abstract class AbstractAuthenticationBroker
extends BrokerFilter
implements AuthenticationBroker {
    protected final CopyOnWriteArrayList<SecurityContext> securityContexts = new CopyOnWriteArrayList();

    public AbstractAuthenticationBroker(Broker next) {
        super(next);
    }

    @Override
    public void removeDestination(ConnectionContext context, PMQDestination destination, long timeout) throws Exception {
        this.next.removeDestination(context, destination, timeout);
        for (SecurityContext sc : this.securityContexts) {
            sc.getAuthorizedWriteDests().remove(destination);
        }
    }

    @Override
    public void removeConnection(ConnectionContext context, ConnectionInfo info, Throwable error) throws Exception {
        super.removeConnection(context, info, error);
        if (this.securityContexts.remove(context.getSecurityContext())) {
            context.setSecurityContext(null);
        }
    }

    public void refresh() {
        for (SecurityContext sc : this.securityContexts) {
            sc.getAuthorizedWriteDests().clear();
        }
    }
}

