/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.security.pmq;

import com.primeton.pmq.security.pmq.dto.AuthenticationAuthorizationEntry;
import com.primeton.pmq.security.pmq.dto.PMQAnonymousUser;
import com.primeton.pmq.security.pmq.dto.PMQAuthenticationUser;
import com.sun.xml.internal.bind.marshaller.CharacterEscapeHandler;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticationAuthorizationEntryFactory {
    private static Logger logger = LoggerFactory.getLogger(AuthenticationAuthorizationEntryFactory.class);
    private String storePath = "auth.xml";
    private AuthenticationAuthorizationEntry authcAuthzEntry = new AuthenticationAuthorizationEntry();

    public synchronized AuthenticationAuthorizationEntry load() {
        File file = new File(this.storePath);
        if (!file.exists()) {
            this.store();
        }
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{AuthenticationAuthorizationEntry.class});
            Unmarshaller unmarshaller = context.createUnmarshaller();
            this.authcAuthzEntry = (AuthenticationAuthorizationEntry)unmarshaller.unmarshal(file);
        }
        catch (JAXBException e) {
            logger.warn(e.getMessage(), (Throwable)e);
        }
        return this.authcAuthzEntry;
    }

    public synchronized void store() {
        JAXBContext context = null;
        try {
            context = JAXBContext.newInstance((Class[])new Class[]{AuthenticationAuthorizationEntry.class});
            Marshaller marshaller = context.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            CharacterEscapeHandler escapeHandler = (ch, start2, length, isAttVal, out) -> out.write(ch, start2, length);
            marshaller.setProperty("com.sun.xml.internal.bind.characterEscapeHandler", (Object)escapeHandler);
            marshaller.setProperty("jaxb.encoding", (Object)"utf-8");
            FileOutputStream out2 = new FileOutputStream(this.storePath);
            marshaller.marshal((Object)this.authcAuthzEntry, (OutputStream)out2);
        }
        catch (FileNotFoundException | JAXBException e) {
            logger.warn(e.getMessage(), e);
        }
    }

    public String getStorePath() {
        return this.storePath;
    }

    public void setStorePath(String storePath) {
        this.storePath = storePath;
    }

    public AuthenticationAuthorizationEntry getAuthcAuthzEntry() {
        if (this.authcAuthzEntry == null) {
            this.authcAuthzEntry = new AuthenticationAuthorizationEntry();
        }
        return this.authcAuthzEntry;
    }

    public PMQAnonymousUser getAnonymousUser() {
        return this.authcAuthzEntry.getAnonymousUser();
    }

    public PMQAuthenticationUser getAuthenticationUser(String username) {
        return this.authcAuthzEntry.getUser(username);
    }

    public void setAnonymousUser(PMQAnonymousUser anonymousUser) {
        this.authcAuthzEntry.setAnonymousUser(anonymousUser);
        this.store();
    }

    public synchronized void applyUser(PMQAuthenticationUser user) {
        if (user != null) {
            this.authcAuthzEntry.addUser(user);
            this.store();
        }
    }

    public synchronized void deleteUser(String username) {
        if (username != null) {
            this.authcAuthzEntry.deleteUser(username);
            this.store();
        }
    }

    public synchronized void deleteAuthorization(String name) {
        if (name != null) {
            this.authcAuthzEntry.deleteAuthorization(name);
            this.store();
        }
    }

    public List<PMQAuthenticationUser> listUsers() {
        return new ArrayList<PMQAuthenticationUser>(this.authcAuthzEntry.getUsers().values());
    }
}

