/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.security.pmq;

import com.primeton.pmq.broker.Broker;
import com.primeton.pmq.broker.ConnectionContext;
import com.primeton.pmq.broker.jmx.ManagementContext;
import com.primeton.pmq.command.ConnectionInfo;
import com.primeton.pmq.security.AbstractAuthenticationBroker;
import com.primeton.pmq.security.SecurityContext;
import com.primeton.pmq.security.pmq.AuthenticationUserManager;
import java.security.cert.X509Certificate;
import javax.management.JMException;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PMQAuthenticationBroker
extends AbstractAuthenticationBroker {
    private static final Logger logger = LoggerFactory.getLogger(PMQAuthenticationBroker.class);
    private ObjectName objectName;
    private String objectNamePropsAppendage = ",service=AuthenticationUserManager";
    private final AuthenticationUserManager authenticationUserManager;

    public PMQAuthenticationBroker(Broker next, AuthenticationUserManager authenticationUserManager) {
        super(next);
        this.authenticationUserManager = authenticationUserManager;
    }

    @Override
    public void addConnection(ConnectionContext context, ConnectionInfo info) throws Exception {
        SecurityContext securityContext = context.getSecurityContext();
        if (securityContext == null) {
            securityContext = this.authenticate(info.getUserName(), info.getPassword(), null);
            context.setSecurityContext(securityContext);
            this.securityContexts.add(securityContext);
        }
        try {
            super.addConnection(context, info);
        }
        catch (Exception e) {
            this.securityContexts.remove(securityContext);
            context.setSecurityContext(null);
            throw e;
        }
    }

    @Override
    public SecurityContext authenticate(String username, String password, X509Certificate[] certificates) throws SecurityException {
        return this.authenticationUserManager.authenticate(username, password, certificates);
    }

    @Override
    public void start() throws Exception {
        super.start();
        this.registerMbean();
    }

    protected void registerMbean() {
        if (this.getBrokerService().isUseJmx()) {
            ManagementContext managementContext = this.getBrokerService().getManagementContext();
            try {
                this.objectName = new ObjectName(this.getBrokerService().getBrokerObjectName().toString() + this.objectNamePropsAppendage);
                managementContext.registerMBean(this.authenticationUserManager, this.objectName);
            }
            catch (Exception ignored) {
                logger.debug("failed to register authenticationUserManager", (Throwable)ignored);
            }
        }
    }

    protected void unregisterMbean() {
        if (this.objectName != null) {
            try {
                this.getBrokerService().getManagementContext().unregisterMBean(this.objectName);
            }
            catch (JMException jMException) {
                // empty catch block
            }
        }
    }
}

