/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.security.pmq.dto;

import com.primeton.pmq.security.pmq.dto.PMQAuthorizationEntry;
import com.primeton.pmq.security.pmq.dto.PMQQueueAuthorizationEntry;
import com.primeton.pmq.security.pmq.dto.PMQTopicAuthorizationEntry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlAdapter;

public class AuthorizationEntriesAdapter
extends XmlAdapter<AdaptedMap, Map<String, PMQAuthorizationEntry>> {
    private static final String TOPIC_PREFIX = "topic://";
    private static final String QUEUE_PREFIX = "queue://";

    public Map<String, PMQAuthorizationEntry> unmarshal(AdaptedMap adaptedMap) {
        HashMap<String, PMQAuthorizationEntry> map = new HashMap<String, PMQAuthorizationEntry>();
        for (PMQAuthorizationEntry e : adaptedMap.list) {
            if (e instanceof PMQTopicAuthorizationEntry) {
                PMQTopicAuthorizationEntry t = (PMQTopicAuthorizationEntry)e;
                map.put(TOPIC_PREFIX + t.getTopic(), e);
            }
            if (!(e instanceof PMQQueueAuthorizationEntry)) continue;
            PMQQueueAuthorizationEntry q = (PMQQueueAuthorizationEntry)e;
            map.put(QUEUE_PREFIX + q.getQueue(), q);
        }
        return map;
    }

    public AdaptedMap marshal(Map<String, PMQAuthorizationEntry> map) {
        AdaptedMap adaptedMap = new AdaptedMap();
        adaptedMap.list = new ArrayList<PMQAuthorizationEntry>(map.values());
        return adaptedMap;
    }

    @XmlType(name="authorizations")
    public static class AdaptedMap {
        @XmlElementRef
        public List<PMQAuthorizationEntry> list = new ArrayList<PMQAuthorizationEntry>();
    }
}

