/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.store.jdbc.adapter;

import com.primeton.pmq.command.MessageId;
import com.primeton.pmq.command.PMQDestination;
import com.primeton.pmq.command.XATransactionId;
import com.primeton.pmq.store.jdbc.Statements;
import com.primeton.pmq.store.jdbc.TransactionContext;
import com.primeton.pmq.store.jdbc.adapter.DefaultJDBCAdapter;
import java.io.IOException;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class BlobJDBCAdapter
extends DefaultJDBCAdapter {
    @Override
    public void setStatements(Statements statements) {
        String addMessageStatement = "INSERT INTO " + statements.getFullMessageTableName() + "(ID, MSGID_PROD, MSGID_SEQ, CONTAINER, EXPIRATION, PRIORITY, MSG, XID) VALUES (?, ?, ?, ?, ?, ?, empty_blob(), empty_blob())";
        statements.setAddMessageStatement(addMessageStatement);
        String findMessageByIdStatement = "SELECT MSG FROM " + statements.getFullMessageTableName() + " WHERE ID=? FOR UPDATE";
        statements.setFindMessageByIdStatement(findMessageByIdStatement);
        super.setStatements(statements);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doAddMessage(TransactionContext c, long sequence, MessageId messageID, PMQDestination destination, byte[] data, long expiration, byte priority, XATransactionId xid) throws SQLException, IOException {
        PreparedStatement s = null;
        try {
            s = c.getConnection().prepareStatement(this.statements.getAddMessageStatement());
            s.setLong(1, sequence);
            s.setString(2, messageID.getProducerId().toString());
            s.setLong(3, messageID.getProducerSequenceId());
            s.setString(4, destination.getQualifiedName());
            s.setLong(5, expiration);
            s.setLong(6, priority);
            if (s.executeUpdate() != 1) {
                throw new IOException("Failed to add broker message: " + messageID + " in container.");
            }
            s.close();
            this.updateBlob(c.getConnection(), this.statements.getFindMessageByIdStatement(), sequence, data);
            if (xid != null) {
                byte[] xidVal = xid.getEncodedXidBytes();
                xidVal[0] = 43;
                this.updateBlob(c.getConnection(), this.statements.getFindXidByIdStatement(), sequence, xidVal);
            }
        }
        catch (Throwable throwable) {
            BlobJDBCAdapter.close(s);
            throw throwable;
        }
        BlobJDBCAdapter.close(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateBlob(Connection connection, String findMessageByIdStatement, long sequence, byte[] data) throws SQLException, IOException {
        PreparedStatement s = null;
        ResultSet rs = null;
        try {
            s = connection.prepareStatement(this.statements.getFindMessageByIdStatement(), 1003, 1008);
            s.setLong(1, sequence);
            rs = s.executeQuery();
            if (!rs.next()) {
                throw new IOException("Failed select blob for message: " + sequence + " in container.");
            }
            Blob blob = rs.getBlob(1);
            blob.truncate(0L);
            blob.setBytes(1L, data);
            rs.updateBlob(1, blob);
            rs.updateRow();
        }
        catch (Throwable throwable) {
            BlobJDBCAdapter.close(rs);
            BlobJDBCAdapter.close(s);
            throw throwable;
        }
        BlobJDBCAdapter.close(rs);
        BlobJDBCAdapter.close(s);
    }

    /*
     * Exception decompiling
     */
    @Override
    public byte[] doGetMessage(TransactionContext c, MessageId id) throws SQLException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

