/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.transport.amqp.message;

import com.primeton.pmq.command.PMQBytesMessage;
import com.primeton.pmq.command.PMQMapMessage;
import com.primeton.pmq.command.PMQMessage;
import com.primeton.pmq.command.PMQObjectMessage;
import com.primeton.pmq.command.PMQStreamMessage;
import com.primeton.pmq.command.PMQTextMessage;
import com.primeton.pmq.transport.amqp.AmqpProtocolException;
import com.primeton.pmq.transport.amqp.message.AMQPNativeInboundTransformer;
import com.primeton.pmq.transport.amqp.message.AmqpMessageSupport;
import com.primeton.pmq.transport.amqp.message.EncodedMessage;
import com.primeton.pmq.transport.amqp.message.InboundTransformer;
import com.primeton.pmq.util.ByteSequence;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jms.JMSException;
import javax.jms.MessageNotWriteableException;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.messaging.AmqpSequence;
import org.apache.qpid.proton.amqp.messaging.AmqpValue;
import org.apache.qpid.proton.amqp.messaging.Data;
import org.apache.qpid.proton.amqp.messaging.Section;
import org.apache.qpid.proton.message.Message;

public class JMSMappingInboundTransformer
extends InboundTransformer {
    @Override
    public String getTransformerName() {
        return "jms";
    }

    @Override
    public InboundTransformer getFallbackTransformer() {
        return new AMQPNativeInboundTransformer();
    }

    @Override
    protected PMQMessage doTransform(EncodedMessage amqpMessage) throws Exception {
        Message amqp = amqpMessage.decode();
        PMQMessage result = this.createMessage(amqp, amqpMessage);
        this.populateMessage(result, amqp);
        if (amqpMessage.getMessageFormat() != 0L) {
            result.setLongProperty("JMS_AMQP_MESSAGE_FORMAT", amqpMessage.getMessageFormat());
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private PMQMessage createMessage(Message message, EncodedMessage original) throws Exception {
        PMQMessage result;
        Section body = message.getBody();
        if (body == null) {
            Charset charset;
            result = AmqpMessageSupport.isContentType("application/x-java-serialized-object", message) ? new PMQObjectMessage() : (AmqpMessageSupport.isContentType("application/octet-stream", message) || AmqpMessageSupport.isContentType(null, message) ? new PMQBytesMessage() : ((charset = AmqpMessageSupport.getCharsetForTextualContent(message.getContentType())) != null ? new PMQTextMessage() : new PMQMessage()));
            result.setShortProperty("JMS_AMQP_ORIGINAL_ENCODING", (short)1);
            return result;
        } else if (body instanceof Data) {
            Binary payload = ((Data)body).getValue();
            if (AmqpMessageSupport.isContentType("application/x-java-serialized-object", message)) {
                result = JMSMappingInboundTransformer.createObjectMessage(payload.getArray(), payload.getArrayOffset(), payload.getLength());
            } else if (AmqpMessageSupport.isContentType("application/octet-stream", message)) {
                result = JMSMappingInboundTransformer.createBytesMessage(payload.getArray(), payload.getArrayOffset(), payload.getLength());
            } else {
                Charset charset = AmqpMessageSupport.getCharsetForTextualContent(message.getContentType());
                if (StandardCharsets.UTF_8.equals(charset)) {
                    ByteBuffer buf = ByteBuffer.wrap(payload.getArray(), payload.getArrayOffset(), payload.getLength());
                    try {
                        CharBuffer chars = charset.newDecoder().decode(buf);
                        result = JMSMappingInboundTransformer.createTextMessage(String.valueOf(chars));
                    }
                    catch (CharacterCodingException e) {
                        result = JMSMappingInboundTransformer.createBytesMessage(payload.getArray(), payload.getArrayOffset(), payload.getLength());
                    }
                } else {
                    result = JMSMappingInboundTransformer.createBytesMessage(payload.getArray(), payload.getArrayOffset(), payload.getLength());
                }
            }
            result.setShortProperty("JMS_AMQP_ORIGINAL_ENCODING", (short)2);
            return result;
        } else if (body instanceof AmqpSequence) {
            AmqpSequence sequence = (AmqpSequence)body;
            PMQStreamMessage m = new PMQStreamMessage();
            for (Object item : sequence.getValue()) {
                m.writeObject(item);
            }
            result = m;
            result.setShortProperty("JMS_AMQP_ORIGINAL_ENCODING", (short)3);
            return result;
        } else {
            if (!(body instanceof AmqpValue)) throw new RuntimeException("Unexpected body type: " + body.getClass());
            Object value = ((AmqpValue)body).getValue();
            if (value == null || value instanceof String) {
                result = JMSMappingInboundTransformer.createTextMessage((String)value);
                result.setShortProperty("JMS_AMQP_ORIGINAL_ENCODING", value == null ? (short)4 : 5);
                return result;
            } else if (value instanceof Binary) {
                Binary payload = (Binary)value;
                result = AmqpMessageSupport.isContentType("application/x-java-serialized-object", message) ? JMSMappingInboundTransformer.createObjectMessage(payload.getArray(), payload.getArrayOffset(), payload.getLength()) : JMSMappingInboundTransformer.createBytesMessage(payload.getArray(), payload.getArrayOffset(), payload.getLength());
                result.setShortProperty("JMS_AMQP_ORIGINAL_ENCODING", (short)6);
                return result;
            } else if (value instanceof List) {
                PMQStreamMessage m = new PMQStreamMessage();
                for (Object item : (List)value) {
                    m.writeObject(item);
                }
                result = m;
                result.setShortProperty("JMS_AMQP_ORIGINAL_ENCODING", (short)8);
                return result;
            } else {
                if (!(value instanceof Map)) throw new AmqpProtocolException("Unable to encode to PMQ JMS Message", false);
                result = JMSMappingInboundTransformer.createMapMessage((Map)value);
                result.setShortProperty("JMS_AMQP_ORIGINAL_ENCODING", (short)7);
            }
        }
        return result;
    }

    private static PMQBytesMessage createBytesMessage(byte[] content, int offset, int length) {
        PMQBytesMessage message = new PMQBytesMessage();
        message.setContent(new ByteSequence(content, offset, length));
        return message;
    }

    public static PMQTextMessage createTextMessage(String text) {
        PMQTextMessage message = new PMQTextMessage();
        try {
            message.setText(text);
        }
        catch (MessageNotWriteableException messageNotWriteableException) {
            // empty catch block
        }
        return message;
    }

    public static PMQObjectMessage createObjectMessage(byte[] content, int offset, int length) {
        PMQObjectMessage message = new PMQObjectMessage();
        message.setContent(new ByteSequence(content, offset, length));
        return message;
    }

    public static PMQMapMessage createMapMessage(Map<String, Object> content) throws JMSException {
        PMQMapMessage message = new PMQMapMessage();
        Set<Map.Entry<String, Object>> set = content.entrySet();
        for (Map.Entry<String, Object> entry : set) {
            Object value = entry.getValue();
            if (value instanceof Binary) {
                Binary binary = (Binary)value;
                value = Arrays.copyOfRange(binary.getArray(), binary.getArrayOffset(), binary.getLength());
            }
            message.setObject(entry.getKey(), value);
        }
        return message;
    }
}

