/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.transport.auto.nio;

import com.primeton.pmq.broker.BrokerService;
import com.primeton.pmq.broker.BrokerServiceAware;
import com.primeton.pmq.openwire.OpenWireFormatFactory;
import com.primeton.pmq.transport.TransportServer;
import com.primeton.pmq.transport.auto.AutoTcpTransportServer;
import com.primeton.pmq.transport.auto.AutoTransportUtils;
import com.primeton.pmq.transport.auto.nio.AutoNIOTransport;
import com.primeton.pmq.transport.nio.NIOTransportFactory;
import com.primeton.pmq.transport.tcp.TcpTransport;
import com.primeton.pmq.transport.tcp.TcpTransportFactory;
import com.primeton.pmq.util.IOExceptionSupport;
import com.primeton.pmq.util.IntrospectionSupport;
import com.primeton.pmq.util.URISupport;
import com.primeton.pmq.wireformat.WireFormat;
import java.io.IOException;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.net.ServerSocketFactory;

public class AutoNioTransportFactory
extends NIOTransportFactory
implements BrokerServiceAware {
    protected BrokerService brokerService;
    boolean allowLinkStealingSet = false;
    private Set<String> enabledProtocols;

    @Override
    public void setBrokerService(BrokerService brokerService) {
        this.brokerService = brokerService;
    }

    @Override
    protected AutoTcpTransportServer createTcpTransportServer(URI location, ServerSocketFactory serverSocketFactory) throws IOException, URISyntaxException {
        return new AutoTcpTransportServer(this, location, serverSocketFactory, this.brokerService, this.enabledProtocols){

            @Override
            protected TcpTransport createTransport(Socket socket, WireFormat format2, TcpTransportFactory detectedTransportFactory, TcpTransport.InitBuffer initBuffer) throws IOException {
                TcpTransport nioTransport = null;
                nioTransport = detectedTransportFactory.getClass().equals(NIOTransportFactory.class) ? new AutoNIOTransport(format2, socket, initBuffer) : detectedTransportFactory.createTransport(format2, socket, initBuffer);
                if (format2.getClass().toString().contains("MQTT") && !AutoNioTransportFactory.this.allowLinkStealingSet) {
                    this.setAllowLinkStealing(true);
                }
                return nioTransport;
            }
        };
    }

    @Override
    public TransportServer doBind(URI location) throws IOException {
        try {
            HashMap<String, String> options = new HashMap<String, String>(URISupport.parseParameters(location));
            Map<String, Object> autoProperties = IntrospectionSupport.extractProperties(options, "auto.");
            this.enabledProtocols = AutoTransportUtils.parseProtocols((String)autoProperties.get("protocols"));
            ServerSocketFactory serverSocketFactory = this.createServerSocketFactory();
            AutoTcpTransportServer server = this.createTcpTransportServer(location, serverSocketFactory);
            server.setWireFormatFactory(new OpenWireFormatFactory());
            if (options.get("allowLinkStealing") != null) {
                this.allowLinkStealingSet = true;
            }
            IntrospectionSupport.setProperties(server, options);
            server.setTransportOption(IntrospectionSupport.extractProperties(options, "transport."));
            server.setWireFormatOptions(AutoTransportUtils.extractWireFormatOptions(options));
            server.bind();
            return server;
        }
        catch (URISyntaxException e) {
            throw IOExceptionSupport.create(e);
        }
    }
}

