/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.transport.discovery.http;

import com.primeton.pmq.Service;
import com.primeton.pmq.command.DiscoveryEvent;
import com.primeton.pmq.transport.discovery.DiscoveryAgent;
import com.primeton.pmq.transport.discovery.DiscoveryListener;
import com.primeton.pmq.util.IntrospectionSupport;
import com.primeton.pmq.util.Suspendable;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Scanner;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.HttpClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPDiscoveryAgent
implements DiscoveryAgent,
Suspendable {
    private static final Logger LOG = LoggerFactory.getLogger(HTTPDiscoveryAgent.class);
    private String registryURL = "http://localhost:8080/discovery-registry/default";
    private HttpClient httpClient = HttpClientBuilder.create().build();
    private AtomicBoolean running = new AtomicBoolean();
    private final AtomicReference<DiscoveryListener> discoveryListener = new AtomicReference();
    private final HashSet<String> registeredServices = new HashSet();
    private final HashMap<String, SimpleDiscoveryEvent> discoveredServices = new HashMap();
    private Thread thread;
    private long updateInterval = 10000L;
    private String brokerName;
    private boolean startEmbeddRegistry = false;
    private Service jetty;
    private AtomicInteger startCounter = new AtomicInteger(0);
    private long initialReconnectDelay = 1000L;
    private long maxReconnectDelay = 30000L;
    private long backOffMultiplier = 2L;
    private boolean useExponentialBackOff = true;
    private int maxReconnectAttempts;
    private final Object sleepMutex = new Object();
    private final Object updateMutex = new Object();
    private UpdateState updateState = UpdateState.RESUMED;
    private long minConnectTime = 5000L;

    public String getGroup() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerService(String service) throws IOException {
        HashSet<String> hashSet = this.registeredServices;
        synchronized (hashSet) {
            this.registeredServices.add(service);
        }
        this.doRegister(service);
    }

    private synchronized void doRegister(String service) {
        String url = this.registryURL;
        try {
            HttpPut method = new HttpPut(url);
            method.addHeader("service", service);
            BasicResponseHandler handler = new BasicResponseHandler();
            String responseBody = (String)this.httpClient.execute((HttpUriRequest)method, (ResponseHandler)handler);
            LOG.debug("PUT to " + url + " got a " + responseBody);
        }
        catch (Exception e) {
            LOG.debug("PUT to " + url + " failed with: " + e);
        }
    }

    private synchronized void doUnRegister(String service) {
        String url = this.registryURL;
        try {
            HttpDelete method = new HttpDelete(url);
            method.addHeader("service", service);
            BasicResponseHandler handler = new BasicResponseHandler();
            String responseBody = (String)this.httpClient.execute((HttpUriRequest)method, (ResponseHandler)handler);
            LOG.debug("DELETE to " + url + " got a " + responseBody);
        }
        catch (Exception e) {
            LOG.debug("DELETE to " + url + " failed with: " + e);
        }
    }

    private synchronized Set<String> doLookup(long freshness) {
        String url = this.registryURL + "?freshness=" + freshness;
        try {
            HttpGet method = new HttpGet(url);
            BasicResponseHandler handler = new BasicResponseHandler();
            String response = (String)this.httpClient.execute((HttpUriRequest)method, (ResponseHandler)handler);
            LOG.debug("GET to " + url + " got a " + response);
            HashSet<String> rc = new HashSet<String>();
            Scanner scanner = new Scanner(response);
            while (scanner.hasNextLine()) {
                String service = scanner.nextLine();
                if (service.trim().length() == 0) continue;
                rc.add(service);
            }
            scanner.close();
            return rc;
        }
        catch (Exception e) {
            LOG.debug("GET to " + url + " failed with: " + e);
            return null;
        }
    }

    @Override
    public void serviceFailed(DiscoveryEvent devent) throws IOException {
        final SimpleDiscoveryEvent event = (SimpleDiscoveryEvent)devent;
        if (event.failed.compareAndSet(false, true)) {
            this.discoveryListener.get().onServiceRemove(event);
            if (!event.removed.get()) {
                Thread thread = new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        if (event.connectTime + HTTPDiscoveryAgent.this.minConnectTime > System.currentTimeMillis()) {
                            LOG.debug("Failure occured soon after the discovery event was generated.  It will be clasified as a connection failure: " + event);
                            event.connectFailures++;
                            if (HTTPDiscoveryAgent.this.maxReconnectAttempts > 0 && event.connectFailures >= HTTPDiscoveryAgent.this.maxReconnectAttempts) {
                                LOG.debug("Reconnect attempts exceeded " + HTTPDiscoveryAgent.this.maxReconnectAttempts + " tries.  Reconnecting has been disabled.");
                                return;
                            }
                            Object object = HTTPDiscoveryAgent.this.sleepMutex;
                            synchronized (object) {
                                try {
                                    if (!HTTPDiscoveryAgent.this.running.get() || event.removed.get()) {
                                        return;
                                    }
                                    LOG.debug("Waiting " + event.reconnectDelay + " ms before attepting to reconnect.");
                                    HTTPDiscoveryAgent.this.sleepMutex.wait(event.reconnectDelay);
                                }
                                catch (InterruptedException ie) {
                                    Thread.currentThread().interrupt();
                                    return;
                                }
                            }
                            if (!HTTPDiscoveryAgent.this.useExponentialBackOff) {
                                event.reconnectDelay = HTTPDiscoveryAgent.this.initialReconnectDelay;
                            } else {
                                event.reconnectDelay = event.reconnectDelay * HTTPDiscoveryAgent.this.backOffMultiplier;
                                if (event.reconnectDelay > HTTPDiscoveryAgent.this.maxReconnectDelay) {
                                    event.reconnectDelay = HTTPDiscoveryAgent.this.maxReconnectDelay;
                                }
                            }
                        } else {
                            event.connectFailures = 0;
                            event.reconnectDelay = HTTPDiscoveryAgent.this.initialReconnectDelay;
                        }
                        if (!HTTPDiscoveryAgent.this.running.get() || event.removed.get()) {
                            return;
                        }
                        event.connectTime = System.currentTimeMillis();
                        event.failed.set(false);
                        ((DiscoveryListener)HTTPDiscoveryAgent.this.discoveryListener.get()).onServiceAdd(event);
                    }
                };
                thread.setDaemon(true);
                thread.start();
            }
        }
    }

    public void setBrokerName(String brokerName) {
        this.brokerName = brokerName;
    }

    @Override
    public void setDiscoveryListener(DiscoveryListener discoveryListener) {
        this.discoveryListener.set(discoveryListener);
    }

    public void setGroup(String group) {
    }

    @Override
    public void start() throws Exception {
        if (this.startCounter.addAndGet(1) == 1) {
            if (this.startEmbeddRegistry) {
                this.jetty = this.createEmbeddedJettyServer();
                HashMap<String, HTTPDiscoveryAgent> props = new HashMap<String, HTTPDiscoveryAgent>();
                props.put("agent", this);
                IntrospectionSupport.setProperties(this.jetty, props);
                this.jetty.start();
            }
            this.running.set(true);
            this.thread = new Thread("HTTPDiscovery Agent"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    while (HTTPDiscoveryAgent.this.running.get()) {
                        try {
                            HTTPDiscoveryAgent.this.update();
                            Object object = HTTPDiscoveryAgent.this.updateMutex;
                            synchronized (object) {
                                do {
                                    if (HTTPDiscoveryAgent.this.updateState == UpdateState.RESUMING) {
                                        HTTPDiscoveryAgent.this.updateState = UpdateState.RESUMED;
                                        continue;
                                    }
                                    HTTPDiscoveryAgent.this.updateMutex.wait(HTTPDiscoveryAgent.this.updateInterval);
                                } while (HTTPDiscoveryAgent.this.updateState == UpdateState.SUSPENDED && HTTPDiscoveryAgent.this.running.get());
                            }
                        }
                        catch (InterruptedException e) {
                            return;
                        }
                    }
                }
            };
            this.thread.setDaemon(true);
            this.thread.start();
        }
    }

    private Service createEmbeddedJettyServer() throws Exception {
        Class<?> clazz = HTTPDiscoveryAgent.class.getClassLoader().loadClass("com.primeton.pmq.transport.discovery.http.EmbeddedJettyServer");
        return (Service)clazz.newInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update() {
        Set<String> activeServices;
        HashSet<String> hashSet = this.registeredServices;
        synchronized (hashSet) {
            for (String service : this.registeredServices) {
                this.doRegister(service);
            }
        }
        DiscoveryListener discoveryListener = this.discoveryListener.get();
        if (discoveryListener != null && (activeServices = this.doLookup(this.updateInterval * 3L)) != null) {
            HashMap<String, SimpleDiscoveryEvent> hashMap = this.discoveredServices;
            synchronized (hashMap) {
                SimpleDiscoveryEvent e;
                HashSet<String> removedServices = new HashSet<String>(this.discoveredServices.keySet());
                removedServices.removeAll(activeServices);
                HashSet<String> addedServices = new HashSet<String>(activeServices);
                addedServices.removeAll(this.discoveredServices.keySet());
                addedServices.removeAll(removedServices);
                for (String service : addedServices) {
                    e = new SimpleDiscoveryEvent(service);
                    this.discoveredServices.put(service, e);
                    discoveryListener.onServiceAdd(e);
                }
                for (String service : removedServices) {
                    e = this.discoveredServices.remove(service);
                    if (e != null) {
                        e.removed.set(true);
                    }
                    discoveryListener.onServiceRemove(e);
                }
            }
        }
    }

    @Override
    public void stop() throws Exception {
        if (this.startCounter.decrementAndGet() == 0) {
            this.resume();
            this.running.set(false);
            if (this.thread != null) {
                this.thread.join(this.updateInterval * 3L);
                this.thread = null;
            }
            if (this.jetty != null) {
                this.jetty.stop();
                this.jetty = null;
            }
        }
    }

    public String getRegistryURL() {
        return this.registryURL;
    }

    public void setRegistryURL(String discoveryRegistryURL) {
        this.registryURL = discoveryRegistryURL;
    }

    public long getUpdateInterval() {
        return this.updateInterval;
    }

    public void setUpdateInterval(long updateInterval) {
        this.updateInterval = updateInterval;
    }

    public boolean isStartEmbeddRegistry() {
        return this.startEmbeddRegistry;
    }

    public void setStartEmbeddRegistry(boolean startEmbeddRegistry) {
        this.startEmbeddRegistry = startEmbeddRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void suspend() throws Exception {
        Object object = this.updateMutex;
        synchronized (object) {
            this.updateState = UpdateState.SUSPENDED;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resume() throws Exception {
        Object object = this.updateMutex;
        synchronized (object) {
            this.updateState = UpdateState.RESUMING;
            this.updateMutex.notify();
        }
    }

    class SimpleDiscoveryEvent
    extends DiscoveryEvent {
        private int connectFailures;
        private long reconnectDelay;
        private long connectTime;
        private AtomicBoolean failed;
        private AtomicBoolean removed;

        public SimpleDiscoveryEvent(String service) {
            super(service);
            this.reconnectDelay = HTTPDiscoveryAgent.this.initialReconnectDelay;
            this.connectTime = System.currentTimeMillis();
            this.failed = new AtomicBoolean(false);
            this.removed = new AtomicBoolean(false);
        }
    }

    static enum UpdateState {
        SUSPENDED,
        RESUMING,
        RESUMED;

    }
}

