/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.transport.http;

import com.primeton.pmq.transport.Transport;
import com.primeton.pmq.transport.TransportFactory;
import com.primeton.pmq.transport.TransportLoggerFactory;
import com.primeton.pmq.transport.TransportServer;
import com.primeton.pmq.transport.http.HttpClientTransport;
import com.primeton.pmq.transport.http.HttpInactivityMonitor;
import com.primeton.pmq.transport.http.HttpTransportServer;
import com.primeton.pmq.transport.util.TextWireFormat;
import com.primeton.pmq.transport.xstream.XStreamWireFormat;
import com.primeton.pmq.util.IOExceptionSupport;
import com.primeton.pmq.util.IntrospectionSupport;
import com.primeton.pmq.util.URISupport;
import com.primeton.pmq.wireformat.WireFormat;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpTransportFactory
extends TransportFactory {
    private static final Logger LOG = LoggerFactory.getLogger(HttpTransportFactory.class);

    @Override
    public TransportServer doBind(URI location) throws IOException {
        try {
            HashMap<String, String> options = new HashMap<String, String>(URISupport.parseParameters(location));
            HttpTransportServer result = new HttpTransportServer(location, this);
            Map<String, Object> jettyOptions = IntrospectionSupport.extractProperties(options, "jetty.");
            Map<String, Object> httpOptions = IntrospectionSupport.extractProperties(options, "http.");
            Map<String, Object> transportOptions = IntrospectionSupport.extractProperties(options, "transport.");
            Map<String, Object> wireFormatOptions = IntrospectionSupport.extractProperties(options, "wireFormat.");
            result.setJettyOptions(jettyOptions);
            result.setTransportOption(transportOptions);
            result.setHttpOptions(httpOptions);
            result.setWireFormatOptions(wireFormatOptions);
            return result;
        }
        catch (URISyntaxException e) {
            throw IOExceptionSupport.create(e);
        }
    }

    protected TextWireFormat asTextWireFormat(WireFormat wireFormat) {
        if (wireFormat instanceof TextWireFormat) {
            return (TextWireFormat)wireFormat;
        }
        LOG.trace("Not created with a TextWireFormat: {}", (Object)wireFormat);
        return new XStreamWireFormat();
    }

    @Override
    protected String getDefaultWireFormatType() {
        return "xstream";
    }

    @Override
    protected Transport createTransport(URI location, WireFormat wf) throws IOException {
        URI uri;
        TextWireFormat textWireFormat = this.asTextWireFormat(wf);
        try {
            uri = URISupport.removeQuery(location);
        }
        catch (URISyntaxException e) {
            MalformedURLException cause = new MalformedURLException("Error removing query on " + location);
            cause.initCause(e);
            throw cause;
        }
        return new HttpClientTransport(textWireFormat, uri);
    }

    @Override
    public Transport serverConfigure(Transport transport, WireFormat format2, HashMap options) throws Exception {
        return this.compositeConfigure(transport, format2, options);
    }

    @Override
    public Transport compositeConfigure(Transport transport, WireFormat format2, Map options) {
        boolean useInactivityMonitor;
        HttpClientTransport httpTransport = (transport = super.compositeConfigure(transport, format2, options)).narrow(HttpClientTransport.class);
        if (httpTransport != null && httpTransport.isTrace()) {
            try {
                transport = TransportLoggerFactory.getInstance().createTransportLogger(transport);
            }
            catch (Throwable e) {
                LOG.error("Could not create TransportLogger object for: " + TransportLoggerFactory.defaultLogWriterName + ", reason: " + e, e);
            }
        }
        if (useInactivityMonitor = "true".equals(this.getOption(options, "useInactivityMonitor", "true"))) {
            transport = new HttpInactivityMonitor(transport);
            IntrospectionSupport.setProperties(transport, options);
        }
        return transport;
    }
}

