/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.transport.http;

import com.primeton.pmq.command.BrokerInfo;
import com.primeton.pmq.transport.SocketConnectorFactory;
import com.primeton.pmq.transport.WebTransportServerSupport;
import com.primeton.pmq.transport.http.HttpTransportFactory;
import com.primeton.pmq.transport.http.HttpTunnelServlet;
import com.primeton.pmq.transport.util.TextWireFormat;
import com.primeton.pmq.transport.xstream.XStreamWireFormat;
import com.primeton.pmq.util.ServiceStopper;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.Servlet;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;

public class HttpTransportServer
extends WebTransportServerSupport {
    private TextWireFormat wireFormat;
    private final HttpTransportFactory transportFactory;
    private Map<String, Object> wireFormatOptions = new HashMap<String, Object>();

    public HttpTransportServer(URI uri, HttpTransportFactory factory) {
        super(uri);
        this.bindAddress = uri;
        this.transportFactory = factory;
        this.socketConnectorFactory = new SocketConnectorFactory();
    }

    @Override
    public void setBrokerInfo(BrokerInfo brokerInfo) {
    }

    public TextWireFormat getWireFormat() {
        if (this.wireFormat == null) {
            this.wireFormat = this.createWireFormat();
        }
        return this.wireFormat;
    }

    public void setWireFormat(TextWireFormat wireFormat) {
        this.wireFormat = wireFormat;
    }

    protected TextWireFormat createWireFormat() {
        return new XStreamWireFormat();
    }

    protected void setConnector(Connector connector) {
        this.connector = connector;
    }

    @Override
    protected void doStart() throws Exception {
        this.createServer();
        if (this.connector == null) {
            this.connector = this.socketConnectorFactory.createConnector(this.server);
        }
        URI boundTo = this.bind();
        ServletContextHandler contextHandler = new ServletContextHandler((HandlerContainer)this.server, "/", 2);
        ServletHolder holder = new ServletHolder();
        holder.setServlet((Servlet)new HttpTunnelServlet());
        contextHandler.addServlet(holder, "/");
        contextHandler.setAttribute("acceptListener", (Object)this.getAcceptListener());
        contextHandler.setAttribute("wireFormat", (Object)this.getWireFormat());
        contextHandler.setAttribute("transportFactory", (Object)this.transportFactory);
        contextHandler.setAttribute("transportOptions", (Object)this.transportOptions);
        contextHandler.setAttribute("wireFormatOptions", this.wireFormatOptions);
        this.configureTraceMethod((ConstraintSecurityHandler)contextHandler.getSecurityHandler(), this.httpOptions.isEnableTrace());
        this.addGzipHandler(contextHandler);
        this.server.start();
        int port = boundTo.getPort();
        int p2 = this.getConnectorLocalPort();
        if (p2 != -1) {
            port = p2;
        }
        this.setConnectURI(new URI(boundTo.getScheme(), boundTo.getUserInfo(), boundTo.getHost(), port, boundTo.getPath(), boundTo.getQuery(), boundTo.getFragment()));
    }

    private int getConnectorLocalPort() throws Exception {
        return (Integer)this.connector.getClass().getMethod("getLocalPort", new Class[0]).invoke((Object)this.connector, new Object[0]);
    }

    private void addGzipHandler(ServletContextHandler contextHandler) throws Exception {
        HandlerWrapper handler = null;
        try {
            handler = (HandlerWrapper)this.forName("org.eclipse.jetty.servlets.gzip.GzipHandler").newInstance();
        }
        catch (Throwable t) {
            handler = (HandlerWrapper)this.forName("org.eclipse.jetty.server.handler.gzip.GzipHandler").newInstance();
        }
        contextHandler.insertHandler(handler);
    }

    private Class<?> forName(String name) throws ClassNotFoundException {
        Class<?> clazz = null;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader != null) {
            try {
                clazz = loader.loadClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (clazz == null) {
            clazz = HttpTransportServer.class.getClassLoader().loadClass(name);
        }
        return clazz;
    }

    @Override
    protected void doStop(ServiceStopper stopper) throws Exception {
        Server temp = this.server;
        this.server = null;
        if (temp != null) {
            temp.stop();
        }
    }

    @Override
    public InetSocketAddress getSocketAddress() {
        return null;
    }

    @Override
    public void setTransportOption(Map<String, Object> transportOptions) {
        this.socketConnectorFactory.setTransportOptions(transportOptions);
        super.setTransportOption(transportOptions);
    }

    public void setWireFormatOptions(Map<String, Object> wireFormatOptions) {
        this.wireFormatOptions = wireFormatOptions;
    }

    @Override
    public boolean isSslServer() {
        return false;
    }
}

