/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.transport.mqtt;

import com.primeton.pmq.broker.BrokerService;
import com.primeton.pmq.broker.BrokerServiceAware;
import com.primeton.pmq.command.Command;
import com.primeton.pmq.command.ConnectionError;
import com.primeton.pmq.command.ConnectionId;
import com.primeton.pmq.command.ConnectionInfo;
import com.primeton.pmq.command.ExceptionResponse;
import com.primeton.pmq.command.MessageAck;
import com.primeton.pmq.command.MessageDispatch;
import com.primeton.pmq.command.MessageId;
import com.primeton.pmq.command.PMQBytesMessage;
import com.primeton.pmq.command.PMQDestination;
import com.primeton.pmq.command.PMQMapMessage;
import com.primeton.pmq.command.PMQMessage;
import com.primeton.pmq.command.PMQTextMessage;
import com.primeton.pmq.command.ProducerId;
import com.primeton.pmq.command.ProducerInfo;
import com.primeton.pmq.command.Response;
import com.primeton.pmq.command.SessionId;
import com.primeton.pmq.command.SessionInfo;
import com.primeton.pmq.command.ShutdownInfo;
import com.primeton.pmq.transport.mqtt.MQTTInactivityMonitor;
import com.primeton.pmq.transport.mqtt.MQTTPacketIdGenerator;
import com.primeton.pmq.transport.mqtt.MQTTProtocolException;
import com.primeton.pmq.transport.mqtt.MQTTProtocolSupport;
import com.primeton.pmq.transport.mqtt.MQTTSubscription;
import com.primeton.pmq.transport.mqtt.MQTTTransport;
import com.primeton.pmq.transport.mqtt.ResponseHandler;
import com.primeton.pmq.transport.mqtt.strategy.MQTTSubscriptionStrategy;
import com.primeton.pmq.util.ByteArrayOutputStream;
import com.primeton.pmq.util.ByteSequence;
import com.primeton.pmq.util.FactoryFinder;
import com.primeton.pmq.util.IOExceptionSupport;
import com.primeton.pmq.util.IdGenerator;
import com.primeton.pmq.util.JMSExceptionSupport;
import com.primeton.pmq.util.LRUCache;
import com.primeton.pmq.util.LongSequenceGenerator;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import javax.jms.Destination;
import javax.jms.InvalidClientIDException;
import javax.jms.JMSException;
import javax.security.auth.login.CredentialException;
import org.fusesource.hawtbuf.Buffer;
import org.fusesource.hawtbuf.UTF8Buffer;
import org.fusesource.mqtt.client.QoS;
import org.fusesource.mqtt.client.Topic;
import org.fusesource.mqtt.codec.CONNACK;
import org.fusesource.mqtt.codec.CONNECT;
import org.fusesource.mqtt.codec.MQTTFrame;
import org.fusesource.mqtt.codec.PINGRESP;
import org.fusesource.mqtt.codec.PUBACK;
import org.fusesource.mqtt.codec.PUBCOMP;
import org.fusesource.mqtt.codec.PUBLISH;
import org.fusesource.mqtt.codec.PUBREC;
import org.fusesource.mqtt.codec.PUBREL;
import org.fusesource.mqtt.codec.SUBACK;
import org.fusesource.mqtt.codec.SUBSCRIBE;
import org.fusesource.mqtt.codec.UNSUBACK;
import org.fusesource.mqtt.codec.UNSUBSCRIBE;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MQTTProtocolConverter {
    private static final Logger LOG = LoggerFactory.getLogger(MQTTProtocolConverter.class);
    public static final String QOS_PROPERTY_NAME = "PMQ.MQTT.QoS";
    public static final int V3_1 = 3;
    public static final int V3_1_1 = 4;
    public static final String SINGLE_LEVEL_WILDCARD = "+";
    public static final String MULTI_LEVEL_WILDCARD = "#";
    private static final IdGenerator CONNECTION_ID_GENERATOR = new IdGenerator();
    private static final MQTTFrame PING_RESP_FRAME = new PINGRESP().encode();
    private static final double MQTT_KEEP_ALIVE_GRACE_PERIOD = 0.5;
    static final int DEFAULT_CACHE_SIZE = 5000;
    private final ConnectionId connectionId = new ConnectionId(CONNECTION_ID_GENERATOR.generateId());
    private final SessionId sessionId = new SessionId(this.connectionId, -1L);
    private final ProducerId producerId = new ProducerId(this.sessionId, 1L);
    private final LongSequenceGenerator publisherIdGenerator = new LongSequenceGenerator();
    private final ConcurrentMap<Integer, ResponseHandler> resposeHandlers = new ConcurrentHashMap<Integer, ResponseHandler>();
    private final Map<String, PMQDestination> pmqDestinationMap = new LRUCache<String, PMQDestination>(5000);
    private final Map<Destination, String> mqttTopicMap = new LRUCache<Destination, String>(5000);
    private final Map<Short, MessageAck> consumerAcks = new LRUCache<Short, MessageAck>(5000);
    private final Map<Short, PUBREC> publisherRecs = new LRUCache<Short, PUBREC>(5000);
    private final MQTTTransport mqttTransport;
    private final BrokerService brokerService;
    private final Object commnadIdMutex = new Object();
    private int lastCommandId;
    private final AtomicBoolean connected = new AtomicBoolean(false);
    private final ConnectionInfo connectionInfo = new ConnectionInfo();
    private CONNECT connect;
    private String clientId;
    private long defaultKeepAlive;
    private int pmqSubscriptionPrefetch = -1;
    private final MQTTPacketIdGenerator packetIdGenerator;
    private boolean publishDollarTopics;
    public int version;
    private final FactoryFinder STRATAGY_FINDER = new FactoryFinder("META-INF/services/com/primeton/pmq/transport/strategies/");
    private String subscriptionStrategyName = "mqtt-default-subscriptions";
    private MQTTSubscriptionStrategy subsciptionStrategy;
    boolean willSent = false;

    public MQTTProtocolConverter(MQTTTransport mqttTransport, BrokerService brokerService) {
        this.mqttTransport = mqttTransport;
        this.brokerService = brokerService;
        this.packetIdGenerator = MQTTPacketIdGenerator.getMQTTPacketIdGenerator(brokerService);
        this.defaultKeepAlive = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int generateCommandId() {
        Object object = this.commnadIdMutex;
        synchronized (object) {
            return this.lastCommandId++;
        }
    }

    public void sendToPMQ(Command command, ResponseHandler handler) {
        block7: {
            if (command instanceof PMQMessage) {
                PMQMessage msg = (PMQMessage)command;
                try {
                    if (this.getPublishDollarTopics() || !this.findSubscriptionStrategy().isControlTopic(msg.getDestination())) break block7;
                    if (handler != null) {
                        try {
                            handler.onResponse(this, new Response());
                        }
                        catch (IOException e) {
                            LOG.warn("Failed to send command " + command, (Throwable)e);
                        }
                    }
                    return;
                }
                catch (IOException e) {
                    LOG.warn("Failed to send command " + command, (Throwable)e);
                }
            }
        }
        command.setCommandId(this.generateCommandId());
        if (handler != null) {
            command.setResponseRequired(true);
            this.resposeHandlers.put(command.getCommandId(), handler);
        }
        this.getMQTTTransport().sendToPMQ(command);
    }

    void sendToMQTT(MQTTFrame frame) {
        try {
            this.mqttTransport.sendToMQTT(frame);
        }
        catch (IOException e) {
            LOG.warn("Failed to send frame " + frame, (Throwable)e);
        }
    }

    public void onMQTTCommand(MQTTFrame frame) throws IOException, JMSException {
        switch (frame.messageType()) {
            case 12: {
                LOG.debug("Received a ping from client: " + this.getClientId());
                this.checkConnected();
                this.sendToMQTT(PING_RESP_FRAME);
                LOG.debug("Sent Ping Response to " + this.getClientId());
                break;
            }
            case 1: {
                CONNECT connect = new CONNECT().decode(frame);
                this.onMQTTConnect(connect);
                LOG.debug("MQTT Client {} connected. (version: {})", (Object)this.getClientId(), (Object)connect.version());
                break;
            }
            case 14: {
                LOG.debug("MQTT Client {} disconnecting", (Object)this.getClientId());
                this.onMQTTDisconnect();
                break;
            }
            case 8: {
                this.onSubscribe(new SUBSCRIBE().decode(frame));
                break;
            }
            case 10: {
                this.onUnSubscribe(new UNSUBSCRIBE().decode(frame));
                break;
            }
            case 3: {
                this.onMQTTPublish(new PUBLISH().decode(frame));
                break;
            }
            case 4: {
                this.onMQTTPubAck(new PUBACK().decode(frame));
                break;
            }
            case 5: {
                this.onMQTTPubRec(new PUBREC().decode(frame));
                break;
            }
            case 6: {
                this.onMQTTPubRel(new PUBREL().decode(frame));
                break;
            }
            case 7: {
                this.onMQTTPubComp(new PUBCOMP().decode(frame));
                break;
            }
            default: {
                this.handleException(new MQTTProtocolException("Unknown MQTTFrame type: " + frame.messageType(), true), frame);
            }
        }
    }

    void onMQTTConnect(final CONNECT connect) throws MQTTProtocolException {
        if (this.connected.get()) {
            throw new MQTTProtocolException("Already connected.");
        }
        this.connect = connect;
        if (connect.version() < 3 || connect.version() > 4) {
            CONNACK ack = new CONNACK();
            ack.code(CONNACK.Code.CONNECTION_REFUSED_UNACCEPTED_PROTOCOL_VERSION);
            try {
                this.getMQTTTransport().sendToMQTT(ack.encode());
                this.getMQTTTransport().onException(IOExceptionSupport.create("Unsupported or invalid protocol version", null));
            }
            catch (IOException e) {
                this.getMQTTTransport().onException(IOExceptionSupport.create(e));
            }
            return;
        }
        String clientId = "";
        if (connect.clientId() != null) {
            clientId = connect.clientId().toString();
        }
        String userName = null;
        if (connect.userName() != null) {
            userName = connect.userName().toString();
        }
        String passswd = null;
        if (connect.password() != null) {
            if (userName == null && connect.version() != 3) {
                this.getMQTTTransport().onException(IOExceptionSupport.create("Password given without a user name", null));
                return;
            }
            passswd = connect.password().toString();
        }
        this.version = connect.version();
        this.configureInactivityMonitor(connect.keepAlive());
        this.connectionInfo.setConnectionId(this.connectionId);
        if (clientId != null && !clientId.isEmpty()) {
            this.connectionInfo.setClientId(clientId);
        } else {
            if (!connect.cleanSession()) {
                CONNACK ack = new CONNACK();
                ack.code(CONNACK.Code.CONNECTION_REFUSED_IDENTIFIER_REJECTED);
                try {
                    this.getMQTTTransport().sendToMQTT(ack.encode());
                    this.getMQTTTransport().onException(IOExceptionSupport.create("Invalid Client ID", null));
                }
                catch (IOException e) {
                    this.getMQTTTransport().onException(IOExceptionSupport.create(e));
                }
                return;
            }
            this.connectionInfo.setClientId("" + this.connectionInfo.getConnectionId().toString());
        }
        this.connectionInfo.setResponseRequired(true);
        this.connectionInfo.setUserName(userName);
        this.connectionInfo.setPassword(passswd);
        this.connectionInfo.setTransportContext(this.mqttTransport.getPeerCertificates());
        this.sendToPMQ(this.connectionInfo, new ResponseHandler(){

            @Override
            public void onResponse(MQTTProtocolConverter converter, Response response) throws IOException {
                if (response.isException()) {
                    Throwable exception = ((ExceptionResponse)response).getException();
                    CONNACK ack = new CONNACK();
                    if (exception instanceof InvalidClientIDException) {
                        ack.code(CONNACK.Code.CONNECTION_REFUSED_IDENTIFIER_REJECTED);
                    } else if (exception instanceof SecurityException) {
                        ack.code(CONNACK.Code.CONNECTION_REFUSED_NOT_AUTHORIZED);
                    } else if (exception instanceof CredentialException) {
                        ack.code(CONNACK.Code.CONNECTION_REFUSED_BAD_USERNAME_OR_PASSWORD);
                    } else {
                        ack.code(CONNACK.Code.CONNECTION_REFUSED_SERVER_UNAVAILABLE);
                    }
                    MQTTProtocolConverter.this.getMQTTTransport().sendToMQTT(ack.encode());
                    MQTTProtocolConverter.this.getMQTTTransport().onException(IOExceptionSupport.create(exception));
                    return;
                }
                SessionInfo sessionInfo = new SessionInfo(MQTTProtocolConverter.this.sessionId);
                MQTTProtocolConverter.this.sendToPMQ(sessionInfo, null);
                ProducerInfo producerInfo = new ProducerInfo(MQTTProtocolConverter.this.producerId);
                MQTTProtocolConverter.this.sendToPMQ(producerInfo, new ResponseHandler(){

                    @Override
                    public void onResponse(MQTTProtocolConverter converter, Response response) throws IOException {
                        if (response.isException()) {
                            Throwable exception = ((ExceptionResponse)response).getException();
                            CONNACK ack = new CONNACK();
                            ack.code(CONNACK.Code.CONNECTION_REFUSED_BAD_USERNAME_OR_PASSWORD);
                            MQTTProtocolConverter.this.getMQTTTransport().sendToMQTT(ack.encode());
                            MQTTProtocolConverter.this.getMQTTTransport().onException(IOExceptionSupport.create(exception));
                            return;
                        }
                        CONNACK ack = new CONNACK();
                        ack.code(CONNACK.Code.CONNECTION_ACCEPTED);
                        MQTTProtocolConverter.this.connected.set(true);
                        MQTTProtocolConverter.this.getMQTTTransport().sendToMQTT(ack.encode());
                        if (connect.cleanSession()) {
                            MQTTProtocolConverter.this.packetIdGenerator.stopClientSession(MQTTProtocolConverter.this.getClientId());
                        } else {
                            MQTTProtocolConverter.this.packetIdGenerator.startClientSession(MQTTProtocolConverter.this.getClientId());
                        }
                        MQTTProtocolConverter.this.findSubscriptionStrategy().onConnect(connect);
                    }
                });
            }
        });
    }

    void onMQTTDisconnect() throws MQTTProtocolException {
        if (this.connected.compareAndSet(true, false)) {
            this.sendToPMQ(this.connectionInfo.createRemoveCommand(), null);
            this.sendToPMQ(new ShutdownInfo(), null);
        }
        this.stopTransport();
    }

    void onSubscribe(SUBSCRIBE command) throws MQTTProtocolException {
        this.checkConnected();
        LOG.trace("MQTT SUBSCRIBE message:{} client:{} connection:{}", new Object[]{command.messageId(), this.clientId, this.connectionInfo.getConnectionId()});
        Topic[] topics = command.topics();
        if (topics != null) {
            byte[] qos = new byte[topics.length];
            for (int i = 0; i < topics.length; ++i) {
                MQTTProtocolSupport.validate(topics[i].name().toString());
                try {
                    qos[i] = this.findSubscriptionStrategy().onSubscribe(topics[i]);
                    continue;
                }
                catch (IOException e) {
                    throw new MQTTProtocolException("Failed to process subscription request", true, e);
                }
            }
            SUBACK ack = new SUBACK();
            ack.messageId(command.messageId());
            ack.grantedQos(qos);
            try {
                this.getMQTTTransport().sendToMQTT(ack.encode());
            }
            catch (IOException e) {
                LOG.warn("Couldn't send SUBACK for " + command, (Throwable)e);
            }
        } else {
            LOG.warn("No topics defined for Subscription " + command);
            throw new MQTTProtocolException("SUBSCRIBE command received with no topic filter");
        }
    }

    public void onUnSubscribe(UNSUBSCRIBE command) throws MQTTProtocolException {
        this.checkConnected();
        if (!(command.qos() == QoS.AT_LEAST_ONCE || this.version == 3 && this.publishDollarTopics)) {
            throw new MQTTProtocolException("Failed to process unsubscribe request", true, new Exception("UNSUBSCRIBE frame not properly formatted, QoS"));
        }
        UTF8Buffer[] topics = command.topics();
        if (topics != null) {
            for (UTF8Buffer topic : topics) {
                MQTTProtocolSupport.validate(topic.toString());
                try {
                    this.findSubscriptionStrategy().onUnSubscribe(topic.toString());
                }
                catch (IOException e) {
                    throw new MQTTProtocolException("Failed to process unsubscribe request", true, e);
                }
            }
        } else {
            LOG.warn("No topics defined for Subscription " + command);
            throw new MQTTProtocolException("UNSUBSCRIBE command received with no topic filter");
        }
        UNSUBACK ack = new UNSUBACK();
        ack.messageId(command.messageId());
        this.sendToMQTT(ack.encode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPMQCommand(Command command) throws Exception {
        if (command.isResponse()) {
            Response response = (Response)command;
            ResponseHandler rh = (ResponseHandler)this.resposeHandlers.remove(response.getCorrelationId());
            if (rh != null) {
                rh.onResponse(this, response);
            } else if (response.isException()) {
                Throwable exception = ((ExceptionResponse)response).getException();
                this.handleException(exception, null);
            }
        } else if (command.isMessageDispatch()) {
            MessageDispatch md = (MessageDispatch)command;
            MQTTSubscription sub = this.findSubscriptionStrategy().getSubscription(md.getConsumerId());
            if (sub != null) {
                MessageAck ack = sub.createMessageAck(md);
                PUBLISH publish = sub.createPublish((PMQMessage)md.getMessage());
                switch (publish.qos()) {
                    case AT_LEAST_ONCE: 
                    case EXACTLY_ONCE: {
                        publish.dup(publish.dup() ? true : md.getMessage().isRedelivered());
                    }
                }
                if (ack != null && sub.expectAck(publish)) {
                    Map<Short, MessageAck> map = this.consumerAcks;
                    synchronized (map) {
                        this.consumerAcks.put(publish.messageId(), ack);
                    }
                }
                LOG.trace("MQTT Snd PUBLISH message:{} client:{} connection:{}", new Object[]{publish.messageId(), this.clientId, this.connectionInfo.getConnectionId()});
                this.getMQTTTransport().sendToMQTT(publish.encode());
                if (ack != null && !sub.expectAck(publish)) {
                    this.getMQTTTransport().sendToPMQ(ack);
                }
            }
        } else if (command.getDataStructureType() == 16) {
            Throwable exception = ((ConnectionError)command).getException();
            this.handleException(exception, null);
        } else if (!command.isBrokerInfo()) {
            LOG.debug("Do not know how to process PMQ Command {}", (Object)command);
        }
    }

    void onMQTTPublish(PUBLISH command) throws IOException, JMSException {
        this.checkConnected();
        LOG.trace("MQTT Rcv PUBLISH message:{} client:{} connection:{}", new Object[]{command.messageId(), this.clientId, this.connectionInfo.getConnectionId()});
        if (this.containsMqttWildcard(command.topicName().toString())) {
            this.getMQTTTransport().onException(IOExceptionSupport.create("The topic name must not contain wildcard characters.", null));
            return;
        }
        PMQMessage message = this.convertMessage(command);
        message.setProducerId(this.producerId);
        message.onSend();
        this.sendToPMQ(message, this.createResponseHandler(command));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onMQTTPubAck(PUBACK command) {
        MessageAck ack;
        short messageId = command.messageId();
        LOG.trace("MQTT Rcv PUBACK message:{} client:{} connection:{}", new Object[]{messageId, this.clientId, this.connectionInfo.getConnectionId()});
        this.packetIdGenerator.ackPacketId(this.getClientId(), messageId);
        Map<Short, MessageAck> map = this.consumerAcks;
        synchronized (map) {
            ack = this.consumerAcks.remove(messageId);
        }
        if (ack != null) {
            this.getMQTTTransport().sendToPMQ(ack);
        }
    }

    void onMQTTPubRec(PUBREC commnand) {
        PUBREL pubrel = new PUBREL();
        pubrel.messageId(commnand.messageId());
        this.sendToMQTT(pubrel.encode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onMQTTPubRel(PUBREL command) {
        PUBREC ack;
        Map<Short, PUBREC> map = this.publisherRecs;
        synchronized (map) {
            ack = this.publisherRecs.remove(command.messageId());
        }
        if (ack == null) {
            LOG.warn("Unknown PUBREL: {} received", (Object)command.messageId());
        }
        PUBCOMP pubcomp = new PUBCOMP();
        pubcomp.messageId(command.messageId());
        this.sendToMQTT(pubcomp.encode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onMQTTPubComp(PUBCOMP command) {
        MessageAck ack;
        short messageId = command.messageId();
        this.packetIdGenerator.ackPacketId(this.getClientId(), messageId);
        Map<Short, MessageAck> map = this.consumerAcks;
        synchronized (map) {
            ack = this.consumerAcks.remove(messageId);
        }
        if (ack != null) {
            this.getMQTTTransport().sendToPMQ(ack);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PMQMessage convertMessage(PUBLISH command) throws JMSException {
        PMQDestination destination;
        PMQBytesMessage msg = new PMQBytesMessage();
        msg.setProducerId(this.producerId);
        MessageId id = new MessageId(this.producerId, this.publisherIdGenerator.getNextSequenceId());
        msg.setMessageId(id);
        LOG.trace("MQTT-->PMQ: MQTT_MSGID:{} client:{} connection:{} PMQ_MSGID:{}", new Object[]{command.messageId(), this.clientId, this.connectionInfo.getConnectionId(), msg.getMessageId()});
        msg.setTimestamp(System.currentTimeMillis());
        msg.setPriority((byte)4);
        msg.setPersistent(command.qos() != QoS.AT_MOST_ONCE && !command.retain());
        msg.setIntProperty(QOS_PROPERTY_NAME, command.qos().ordinal());
        if (command.retain()) {
            msg.setBooleanProperty("PMQ.Retain", true);
        }
        Map<String, PMQDestination> map = this.pmqDestinationMap;
        synchronized (map) {
            destination = this.pmqDestinationMap.get(command.topicName().toString());
            if (destination == null) {
                String topicName = MQTTProtocolSupport.convertMQTTToPMQ(command.topicName().toString());
                try {
                    destination = this.findSubscriptionStrategy().onSend(topicName);
                }
                catch (IOException e) {
                    throw JMSExceptionSupport.create(e);
                }
                this.pmqDestinationMap.put(command.topicName().toString(), destination);
            }
        }
        msg.setJMSDestination(destination);
        msg.writeBytes(command.payload().data, command.payload().offset, command.payload().length);
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PUBLISH convertMessage(PMQMessage message) throws IOException, JMSException, DataFormatException {
        PMQMessage msg;
        String topicName;
        QoS qoS;
        PUBLISH result = new PUBLISH();
        if (message.propertyExists(QOS_PROPERTY_NAME)) {
            int ordinal = message.getIntProperty(QOS_PROPERTY_NAME);
            qoS = QoS.values()[ordinal];
        } else {
            qoS = message.isPersistent() ? QoS.AT_MOST_ONCE : QoS.AT_LEAST_ONCE;
        }
        result.qos(qoS);
        if (message.getBooleanProperty("PMQ.Retained")) {
            result.retain(true);
        }
        Map<Destination, String> map = this.mqttTopicMap;
        synchronized (map) {
            topicName = this.mqttTopicMap.get(message.getJMSDestination());
            if (topicName == null) {
                String amqTopicName = this.findSubscriptionStrategy().onSend(message.getDestination());
                topicName = MQTTProtocolSupport.convertPMQToMQTT(amqTopicName);
                this.mqttTopicMap.put(message.getJMSDestination(), topicName);
            }
        }
        result.topicName(new UTF8Buffer(topicName));
        if (message.getDataStructureType() == 28) {
            msg = (PMQTextMessage)message.copy();
            msg.setReadOnlyBody(true);
            String messageText = ((PMQTextMessage)msg).getText();
            if (messageText != null) {
                result.payload(new Buffer(messageText.getBytes("UTF-8")));
            }
        } else if (message.getDataStructureType() == 24) {
            msg = (PMQBytesMessage)message.copy();
            msg.setReadOnlyBody(true);
            byte[] data = new byte[(int)((PMQBytesMessage)msg).getBodyLength()];
            ((PMQBytesMessage)msg).readBytes(data);
            result.payload(new Buffer(data));
        } else if (message.getDataStructureType() == 25) {
            msg = (PMQMapMessage)message.copy();
            msg.setReadOnlyBody(true);
            Map<String, Object> map2 = ((PMQMapMessage)msg).getContentMap();
            if (map2 != null) {
                result.payload(new Buffer(map2.toString().getBytes("UTF-8")));
            }
        } else {
            ByteSequence byteSequence = message.getContent();
            if (byteSequence != null && byteSequence.getLength() > 0) {
                if (message.isCompressed()) {
                    int read2;
                    Inflater inflater = new Inflater();
                    inflater.setInput(byteSequence.data, byteSequence.offset, byteSequence.length);
                    byte[] data = new byte[4096];
                    ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
                    while ((read2 = inflater.inflate(data)) != 0) {
                        bytesOut.write(data, 0, read2);
                    }
                    byteSequence = bytesOut.toByteSequence();
                    bytesOut.close();
                }
                result.payload(new Buffer(byteSequence.data, byteSequence.offset, byteSequence.length));
            }
        }
        LOG.trace("PMQ-->MQTT:MQTT_MSGID:{} client:{} connection:{} PMQ_MSGID:{}", new Object[]{result.messageId(), this.clientId, this.connectionInfo.getConnectionId(), message.getMessageId()});
        return result;
    }

    public MQTTTransport getMQTTTransport() {
        return this.mqttTransport;
    }

    public void onTransportError() {
        if (this.connect != null && this.connected.get()) {
            if (this.connect.willTopic() != null && this.connect.willMessage() != null && !this.willSent) {
                this.willSent = true;
                try {
                    PUBLISH publish = new PUBLISH();
                    publish.topicName(this.connect.willTopic());
                    publish.qos(this.connect.willQos());
                    publish.messageId(this.packetIdGenerator.getNextSequenceId(this.getClientId()));
                    publish.payload((Buffer)this.connect.willMessage());
                    publish.retain(this.connect.willRetain());
                    PMQMessage message = this.convertMessage(publish);
                    message.setProducerId(this.producerId);
                    message.onSend();
                    this.sendToPMQ(message, null);
                }
                catch (Exception e) {
                    LOG.warn("Failed to publish Will Message " + this.connect.willMessage());
                }
            }
            this.sendToPMQ(this.connectionInfo.createRemoveCommand(), null);
        }
    }

    void configureInactivityMonitor(short keepAliveSeconds) {
        MQTTInactivityMonitor monitor = this.getMQTTTransport().getInactivityMonitor();
        if (monitor == null) {
            return;
        }
        monitor.stopConnectChecker();
        long keepAliveMS = keepAliveSeconds * 1000;
        LOG.debug("MQTT Client {} requests heart beat of {} ms", (Object)this.getClientId(), (Object)keepAliveMS);
        try {
            if (keepAliveMS == 0L && this.defaultKeepAlive > 0L) {
                keepAliveMS = this.defaultKeepAlive;
            }
            long readGracePeriod = (long)((double)keepAliveMS * 0.5);
            monitor.setProtocolConverter(this);
            monitor.setReadKeepAliveTime(keepAliveMS);
            monitor.setReadGraceTime(readGracePeriod);
            monitor.startReadChecker();
            LOG.debug("MQTT Client {} established heart beat of  {} ms ({} ms + {} ms grace period)", new Object[]{this.getClientId(), keepAliveMS, keepAliveMS, readGracePeriod});
        }
        catch (Exception ex) {
            LOG.warn("Failed to start MQTT InactivityMonitor ", (Throwable)ex);
        }
    }

    void handleException(Throwable exception, MQTTFrame command) {
        LOG.warn("Exception occurred processing: \n" + command + ": " + exception.toString());
        LOG.debug("Exception detail", exception);
        if (this.connected.get() && this.connectionInfo != null) {
            this.connected.set(false);
            this.sendToPMQ(this.connectionInfo.createRemoveCommand(), null);
        }
        this.stopTransport();
    }

    void checkConnected() throws MQTTProtocolException {
        if (!this.connected.get()) {
            throw new MQTTProtocolException("Not connected.");
        }
    }

    private void stopTransport() {
        try {
            this.getMQTTTransport().stop();
        }
        catch (Throwable e) {
            LOG.debug("Failed to stop MQTT transport ", e);
        }
    }

    ResponseHandler createResponseHandler(final PUBLISH command) {
        if (command != null) {
            return new ResponseHandler(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onResponse(MQTTProtocolConverter converter, Response response) throws IOException {
                    if (response.isException()) {
                        Throwable error = ((ExceptionResponse)response).getException();
                        LOG.warn("Failed to send MQTT Publish: {}: {}", (Object)command, (Object)error.getMessage());
                        LOG.trace("Error trace: {}", (Object)error);
                    }
                    switch (command.qos()) {
                        case AT_LEAST_ONCE: {
                            PUBACK ack = new PUBACK();
                            ack.messageId(command.messageId());
                            LOG.trace("MQTT Snd PUBACK message:{} client:{} connection:{}", new Object[]{command.messageId(), MQTTProtocolConverter.this.clientId, MQTTProtocolConverter.this.connectionInfo.getConnectionId()});
                            converter.getMQTTTransport().sendToMQTT(ack.encode());
                            break;
                        }
                        case EXACTLY_ONCE: {
                            PUBREC req = new PUBREC();
                            req.messageId(command.messageId());
                            Map map = MQTTProtocolConverter.this.publisherRecs;
                            synchronized (map) {
                                MQTTProtocolConverter.this.publisherRecs.put(command.messageId(), req);
                            }
                            LOG.trace("MQTT Snd PUBREC message:{} client:{} connection:{}", new Object[]{command.messageId(), MQTTProtocolConverter.this.clientId, MQTTProtocolConverter.this.connectionInfo.getConnectionId()});
                            converter.getMQTTTransport().sendToMQTT(req.encode());
                            break;
                        }
                    }
                }
            };
        }
        return null;
    }

    public long getDefaultKeepAlive() {
        return this.defaultKeepAlive;
    }

    public void setDefaultKeepAlive(long keepAlive) {
        this.defaultKeepAlive = keepAlive;
    }

    public int getPMQSubscriptionPrefetch() {
        return this.pmqSubscriptionPrefetch;
    }

    public void setPMQSubscriptionPrefetch(int pmqSubscriptionPrefetch) {
        this.pmqSubscriptionPrefetch = pmqSubscriptionPrefetch;
    }

    public MQTTPacketIdGenerator getPacketIdGenerator() {
        return this.packetIdGenerator;
    }

    public void setPublishDollarTopics(boolean publishDollarTopics) {
        this.publishDollarTopics = publishDollarTopics;
    }

    public boolean getPublishDollarTopics() {
        return this.publishDollarTopics;
    }

    public ConnectionId getConnectionId() {
        return this.connectionId;
    }

    public SessionId getSessionId() {
        return this.sessionId;
    }

    public boolean isCleanSession() {
        return this.connect.cleanSession();
    }

    public String getSubscriptionStrategy() {
        return this.subscriptionStrategyName;
    }

    public void setSubscriptionStrategy(String name) {
        this.subscriptionStrategyName = name;
    }

    public String getClientId() {
        if (this.clientId == null) {
            this.clientId = this.connect != null && this.connect.clientId() != null ? this.connect.clientId().toString() : "";
        }
        return this.clientId;
    }

    protected boolean containsMqttWildcard(String value) {
        return value != null && (value.contains(SINGLE_LEVEL_WILDCARD) || value.contains(MULTI_LEVEL_WILDCARD));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MQTTSubscriptionStrategy findSubscriptionStrategy() throws IOException {
        if (this.subsciptionStrategy == null) {
            FactoryFinder factoryFinder = this.STRATAGY_FINDER;
            synchronized (factoryFinder) {
                if (this.subsciptionStrategy != null) {
                    return this.subsciptionStrategy;
                }
                MQTTSubscriptionStrategy strategy = null;
                if (this.subscriptionStrategyName != null && !this.subscriptionStrategyName.isEmpty()) {
                    try {
                        strategy = (MQTTSubscriptionStrategy)this.STRATAGY_FINDER.newInstance(this.subscriptionStrategyName);
                        LOG.debug("MQTT Using subscription strategy: {}", (Object)this.subscriptionStrategyName);
                        if (strategy instanceof BrokerServiceAware) {
                            ((BrokerServiceAware)((Object)strategy)).setBrokerService(this.brokerService);
                        }
                        strategy.initialize(this);
                    }
                    catch (Exception e) {
                        throw IOExceptionSupport.create(e);
                    }
                } else {
                    throw new IOException("Invalid subscription strategy name given: " + this.subscriptionStrategyName);
                }
                this.subsciptionStrategy = strategy;
            }
        }
        return this.subsciptionStrategy;
    }
}

