/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.transport.peer;

import com.primeton.pmq.broker.BrokerFactoryHandler;
import com.primeton.pmq.broker.BrokerService;
import com.primeton.pmq.broker.TransportConnector;
import com.primeton.pmq.transport.Transport;
import com.primeton.pmq.transport.TransportFactory;
import com.primeton.pmq.transport.TransportServer;
import com.primeton.pmq.transport.vm.VMTransportFactory;
import com.primeton.pmq.util.IOExceptionSupport;
import com.primeton.pmq.util.IdGenerator;
import com.primeton.pmq.util.IntrospectionSupport;
import com.primeton.pmq.util.URISupport;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class PeerTransportFactory
extends TransportFactory {
    public static final ConcurrentMap BROKERS = new ConcurrentHashMap();
    public static final ConcurrentMap CONNECTORS = new ConcurrentHashMap();
    public static final ConcurrentMap SERVERS = new ConcurrentHashMap();
    private static final IdGenerator ID_GENERATOR = new IdGenerator("peer-");

    @Override
    public Transport doConnect(URI location) throws Exception {
        VMTransportFactory vmTransportFactory = this.createTransportFactory(location);
        return vmTransportFactory.doConnect(location);
    }

    @Override
    public Transport doCompositeConnect(URI location) throws Exception {
        VMTransportFactory vmTransportFactory = this.createTransportFactory(location);
        return vmTransportFactory.doCompositeConnect(location);
    }

    private VMTransportFactory createTransportFactory(URI location) throws IOException {
        try {
            HashMap<String, String> brokerOptions;
            String group = location.getHost();
            String broker = URISupport.stripPrefix(location.getPath(), "/");
            if (group == null) {
                group = "default";
            }
            if (broker == null || broker.length() == 0) {
                broker = ID_GENERATOR.generateSanitizedId();
            }
            if (!(brokerOptions = new HashMap<String, String>(URISupport.parseParameters(location))).containsKey("persistent")) {
                brokerOptions.put("persistent", "false");
            }
            final URI finalLocation = new URI("vm://" + broker);
            final String finalBroker = broker;
            final String finalGroup = group;
            VMTransportFactory rc = new VMTransportFactory(){

                @Override
                public Transport doConnect(URI ignore) throws Exception {
                    return super.doConnect(finalLocation);
                }

                @Override
                public Transport doCompositeConnect(URI ignore) throws Exception {
                    return super.doCompositeConnect(finalLocation);
                }
            };
            rc.setBrokerFactoryHandler(new BrokerFactoryHandler(){

                @Override
                public BrokerService createBroker(URI brokerURI) throws Exception {
                    BrokerService service = new BrokerService();
                    IntrospectionSupport.setProperties(service, brokerOptions);
                    service.setBrokerName(finalBroker);
                    TransportConnector c = service.addConnector("tcp://0.0.0.0:0");
                    c.setDiscoveryUri(new URI("multicast://default?group=" + finalGroup));
                    service.addNetworkConnector("multicast://default?group=" + finalGroup);
                    return service;
                }
            });
            return rc;
        }
        catch (URISyntaxException e) {
            throw IOExceptionSupport.create(e);
        }
    }

    @Override
    public TransportServer doBind(URI location) throws IOException {
        throw new IOException("This protocol does not support being bound.");
    }
}

