/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.transport.stomp;

import com.primeton.pmq.command.PMQBytesMessage;
import com.primeton.pmq.command.PMQDestination;
import com.primeton.pmq.command.PMQMessage;
import com.primeton.pmq.command.PMQTextMessage;
import com.primeton.pmq.transport.stomp.FrameTranslator;
import com.primeton.pmq.transport.stomp.ProtocolConverter;
import com.primeton.pmq.transport.stomp.ProtocolException;
import com.primeton.pmq.transport.stomp.StompFrame;
import com.primeton.pmq.util.ByteArrayOutputStream;
import com.primeton.pmq.util.ByteSequence;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.jms.Destination;
import javax.jms.JMSException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LegacyFrameTranslator
implements FrameTranslator {
    private static final Logger LOG = LoggerFactory.getLogger(LegacyFrameTranslator.class);

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public PMQMessage convertFrame(ProtocolConverter converter, StompFrame command) throws JMSException, ProtocolException {
        void var4_20;
        Map<String, String> headers = command.getHeaders();
        if (headers.containsKey("amq-msg-type")) {
            String intendedType = headers.get("amq-msg-type");
            if (intendedType.equalsIgnoreCase("text")) {
                PMQTextMessage text = new PMQTextMessage();
                try {
                    ByteArrayOutputStream bytes = new ByteArrayOutputStream(command.getContent().length + 4);
                    DataOutputStream data = new DataOutputStream(bytes);
                    data.writeInt(command.getContent().length);
                    data.write(command.getContent());
                    text.setContent(bytes.toByteSequence());
                    data.close();
                }
                catch (Throwable e) {
                    throw new ProtocolException("Text could not bet set: " + e, false, e);
                }
                PMQTextMessage pMQTextMessage = text;
            } else {
                if (!intendedType.equalsIgnoreCase("bytes")) throw new ProtocolException("Unsupported message type '" + intendedType + "'", false);
                PMQBytesMessage byteMessage = new PMQBytesMessage();
                byteMessage.writeBytes(command.getContent());
                PMQBytesMessage pMQBytesMessage = byteMessage;
            }
        } else if (headers.containsKey("content-length")) {
            headers.remove("content-length");
            PMQBytesMessage bm = new PMQBytesMessage();
            bm.writeBytes(command.getContent());
            PMQBytesMessage pMQBytesMessage = bm;
        } else {
            PMQTextMessage text = new PMQTextMessage();
            try {
                ByteArrayOutputStream bytes = new ByteArrayOutputStream(command.getContent().length + 4);
                DataOutputStream data = new DataOutputStream(bytes);
                data.writeInt(command.getContent().length);
                data.write(command.getContent());
                text.setContent(bytes.toByteSequence());
                data.close();
            }
            catch (Throwable e) {
                throw new ProtocolException("Text could not bet set: " + e, false, e);
            }
            PMQTextMessage pMQTextMessage = text;
        }
        FrameTranslator.Helper.copyStandardHeadersFromFrameToMessage(converter, command, (PMQMessage)var4_20, this);
        return var4_20;
    }

    @Override
    public StompFrame convertMessage(ProtocolConverter converter, PMQMessage message) throws IOException, JMSException {
        StompFrame command = new StompFrame();
        command.setAction("MESSAGE");
        HashMap<String, String> headers = new HashMap<String, String>(25);
        command.setHeaders(headers);
        FrameTranslator.Helper.copyStandardHeadersFromMessageToFrame(converter, message, command, this);
        if (message.getDataStructureType() == 28) {
            if (!message.isCompressed() && message.getContent() != null) {
                ByteSequence msgContent = message.getContent();
                if (msgContent.getLength() > 4) {
                    byte[] content = new byte[msgContent.getLength() - 4];
                    System.arraycopy(msgContent.data, 4, content, 0, content.length);
                    command.setContent(content);
                }
            } else {
                PMQTextMessage msg = (PMQTextMessage)message.copy();
                String messageText = msg.getText();
                if (messageText != null) {
                    command.setContent(msg.getText().getBytes("UTF-8"));
                }
            }
        } else if (message.getDataStructureType() == 24) {
            PMQBytesMessage msg = (PMQBytesMessage)message.copy();
            msg.setReadOnlyBody(true);
            byte[] data = new byte[(int)msg.getBodyLength()];
            msg.readBytes(data);
            headers.put("content-length", Integer.toString(data.length));
            command.setContent(data);
        }
        return command;
    }

    @Override
    public String convertDestination(ProtocolConverter converter, Destination d) {
        if (d == null) {
            return null;
        }
        PMQDestination pmqDestination = (PMQDestination)d;
        String physicalName = pmqDestination.getPhysicalName();
        String rc = converter.getCreatedTempDestinationName(pmqDestination);
        if (rc != null) {
            return rc;
        }
        StringBuilder buffer = new StringBuilder();
        if (pmqDestination.isQueue()) {
            if (pmqDestination.isTemporary()) {
                buffer.append("/remote-temp-queue/");
            } else {
                buffer.append("/queue/");
            }
        } else if (pmqDestination.isTemporary()) {
            buffer.append("/remote-temp-topic/");
        } else {
            buffer.append("/topic/");
        }
        buffer.append(physicalName);
        return buffer.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public PMQDestination convertDestination(ProtocolConverter converter, String name, boolean forceFallback) throws ProtocolException {
        if (name == null) {
            return null;
        }
        String originalName = name;
        String[] destinations = (name = name.trim()).split(",");
        if (destinations == null || destinations.length == 0) {
            destinations = new String[]{name};
        }
        StringBuilder destinationBuilder = new StringBuilder();
        for (int i = 0; i < destinations.length; ++i) {
            PMQDestination converted;
            String destinationName = destinations[i];
            if (destinationName.startsWith("/queue/")) {
                destinationName = destinationName.substring("/queue/".length(), destinationName.length());
                destinationBuilder.append("queue://" + destinationName);
            } else if (destinationName.startsWith("/topic/")) {
                destinationName = destinationName.substring("/topic/".length(), destinationName.length());
                destinationBuilder.append("topic://" + destinationName);
            } else if (destinationName.startsWith("/remote-temp-queue/")) {
                destinationName = destinationName.substring("/remote-temp-queue/".length(), destinationName.length());
                destinationBuilder.append("temp-queue://" + destinationName);
            } else if (destinationName.startsWith("/remote-temp-topic/")) {
                destinationName = destinationName.substring("/remote-temp-topic/".length(), destinationName.length());
                destinationBuilder.append("temp-topic://" + destinationName);
            } else if (destinationName.startsWith("/temp-queue/")) {
                converted = converter.createTempDestination(destinationName, false);
                destinationBuilder.append(converted.getQualifiedName());
            } else if (destinationName.startsWith("/temp-topic/")) {
                converted = converter.createTempDestination(destinationName, true);
                destinationBuilder.append(converted.getQualifiedName());
            } else {
                if (!forceFallback) throw new ProtocolException("Illegal destination name: [" + originalName + "] -- PMQ STOMP destinations must begin with one of: /queue/ /topic/ /temp-queue/ /temp-topic/");
                String fallbackName = destinationName;
                if (destinationName.length() == 1) {
                    fallbackName = originalName;
                }
                try {
                    PMQDestination fallback = PMQDestination.getUnresolvableDestinationTransformer().transform(fallbackName);
                    if (fallback != null) {
                        destinationBuilder.append(fallback.getQualifiedName());
                    }
                }
                catch (JMSException e) {
                    throw new ProtocolException("Illegal destination name: [" + fallbackName + "] -- PMQ STOMP destinations must begin with one of: /queue/ /topic/ /temp-queue/ /temp-topic/", false, e);
                }
            }
            if (i >= destinations.length - 1) continue;
            destinationBuilder.append(",");
        }
        LOG.trace("New Composite Destination name: {}", (Object)destinationBuilder);
        return PMQDestination.createDestination(destinationBuilder.toString(), (byte)1);
    }
}

