/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.transport.stomp;

import com.primeton.pmq.transport.nio.NIOSSLTransport;
import com.primeton.pmq.transport.stomp.StompCodec;
import com.primeton.pmq.transport.stomp.StompFrame;
import com.primeton.pmq.transport.tcp.TcpTransport;
import com.primeton.pmq.wireformat.WireFormat;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.Socket;
import java.net.URI;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.security.cert.X509Certificate;
import javax.net.SocketFactory;
import javax.net.ssl.SSLEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StompNIOSSLTransport
extends NIOSSLTransport {
    private static final Logger LOGGER = LoggerFactory.getLogger(StompNIOSSLTransport.class);
    StompCodec codec;
    private X509Certificate[] cachedPeerCerts;

    public StompNIOSSLTransport(WireFormat wireFormat, SocketFactory socketFactory, URI remoteLocation, URI localLocation) throws UnknownHostException, IOException {
        super(wireFormat, socketFactory, remoteLocation, localLocation);
    }

    public StompNIOSSLTransport(WireFormat wireFormat, Socket socket) throws IOException {
        super(wireFormat, socket, null, null, null);
    }

    public StompNIOSSLTransport(WireFormat wireFormat, Socket socket, SSLEngine engine, TcpTransport.InitBuffer initBuffer, ByteBuffer inputBuffer) throws IOException {
        super(wireFormat, socket, engine, initBuffer, inputBuffer);
    }

    @Override
    protected void initializeStreams() throws IOException {
        this.codec = new StompCodec(this);
        super.initializeStreams();
        if (this.inputBuffer.position() != 0 && this.inputBuffer.hasRemaining()) {
            this.serviceRead();
        }
    }

    @Override
    protected void processCommand(ByteBuffer plain) throws Exception {
        byte[] fill = new byte[plain.remaining()];
        plain.get(fill);
        ByteArrayInputStream input = new ByteArrayInputStream(fill);
        this.codec.parse(input, fill.length);
    }

    @Override
    public void doConsume(Object command) {
        StompFrame frame = (StompFrame)command;
        if (this.cachedPeerCerts == null) {
            this.cachedPeerCerts = this.getPeerCertificates();
        }
        frame.setTransportContext(this.cachedPeerCerts);
        super.doConsume(command);
    }

    @Override
    protected void doInit() throws Exception {
        if (this.initBuffer != null) {
            this.nextFrameSize = -1;
            this.receiveCounter += this.initBuffer.readSize;
            this.initBuffer.buffer.flip();
            this.processCommand(this.initBuffer.buffer);
        }
        super.doInit();
    }
}

