/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.transport.stomp;

import com.primeton.pmq.command.ConsumerInfo;
import com.primeton.pmq.command.MessageAck;
import com.primeton.pmq.command.MessageDispatch;
import com.primeton.pmq.command.TransactionId;
import com.primeton.pmq.transport.stomp.ProtocolConverter;
import com.primeton.pmq.transport.stomp.ProtocolException;
import com.primeton.pmq.transport.stomp.StompAckEntry;
import com.primeton.pmq.transport.stomp.StompFrame;
import com.primeton.pmq.transport.stomp.StompSubscription;
import java.io.IOException;
import java.util.Map;
import javax.jms.JMSException;

public class StompQueueBrowserSubscription
extends StompSubscription {
    public StompQueueBrowserSubscription(ProtocolConverter stompTransport, String subscriptionId, ConsumerInfo consumerInfo, String transformation, Map<String, StompAckEntry> pendingAcks) {
        super(stompTransport, subscriptionId, consumerInfo, transformation, pendingAcks);
    }

    @Override
    void onMessageDispatch(MessageDispatch md) throws IOException, JMSException {
        if (md.getMessage() != null) {
            super.onMessageDispatch(md);
        } else {
            StompFrame browseDone = new StompFrame("MESSAGE");
            browseDone.getHeaders().put("subscription", this.getSubscriptionId());
            browseDone.getHeaders().put("browser", "end");
            browseDone.getHeaders().put("destination", this.protocolConverter.findTranslator(null).convertDestination(this.protocolConverter, this.destination));
            browseDone.getHeaders().put("message-id", "0");
            this.protocolConverter.sendToStomp(browseDone);
        }
    }

    @Override
    public MessageAck onStompMessageNack(String messageId, TransactionId transactionId) throws ProtocolException {
        throw new ProtocolException("Cannot Nack a message on a Queue Browser Subscription.");
    }
}

