/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.transport.stomp;

import com.primeton.pmq.broker.BrokerContext;
import com.primeton.pmq.broker.BrokerService;
import com.primeton.pmq.broker.BrokerServiceAware;
import com.primeton.pmq.transport.MutexTransport;
import com.primeton.pmq.transport.Transport;
import com.primeton.pmq.transport.stomp.StompFrame;
import com.primeton.pmq.transport.stomp.StompInactivityMonitor;
import com.primeton.pmq.transport.stomp.StompTransportFilter;
import com.primeton.pmq.transport.tcp.SslTransport;
import com.primeton.pmq.transport.tcp.SslTransportFactory;
import com.primeton.pmq.transport.tcp.SslTransportServer;
import com.primeton.pmq.transport.tcp.TcpTransport;
import com.primeton.pmq.util.IntrospectionSupport;
import com.primeton.pmq.wireformat.WireFormat;
import java.io.IOException;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;

public class StompSslTransportFactory
extends SslTransportFactory
implements BrokerServiceAware {
    private BrokerContext brokerContext = null;

    @Override
    protected String getDefaultWireFormatType() {
        return "stomp";
    }

    @Override
    protected SslTransportServer createSslTransportServer(URI location, SSLServerSocketFactory serverSocketFactory) throws IOException, URISyntaxException {
        return new SslTransportServer(this, location, serverSocketFactory){

            @Override
            protected Transport createTransport(Socket socket, WireFormat format2) throws IOException {
                return new SslTransport(format2, (SSLSocket)socket){
                    private X509Certificate[] cachedPeerCerts;

                    @Override
                    public void doConsume(Object command) {
                        StompFrame frame = (StompFrame)command;
                        if (this.cachedPeerCerts == null) {
                            this.cachedPeerCerts = this.getPeerCertificates();
                        }
                        frame.setTransportContext(this.cachedPeerCerts);
                        super.doConsume(command);
                    }
                };
            }
        };
    }

    @Override
    public SslTransport createTransport(WireFormat wireFormat, Socket socket, TcpTransport.InitBuffer initBuffer) throws IOException {
        return new SslTransport(wireFormat, (SSLSocket)socket, initBuffer){
            private X509Certificate[] cachedPeerCerts;

            @Override
            public void doConsume(Object command) {
                StompFrame frame = (StompFrame)command;
                if (this.cachedPeerCerts == null) {
                    this.cachedPeerCerts = this.getPeerCertificates();
                }
                frame.setTransportContext(this.cachedPeerCerts);
                super.doConsume(command);
            }
        };
    }

    @Override
    public Transport compositeConfigure(Transport transport, WireFormat format2, Map options) {
        transport = new StompTransportFilter(transport, format2, this.brokerContext);
        IntrospectionSupport.setProperties(transport, options);
        return super.compositeConfigure(transport, format2, options);
    }

    @Override
    public Transport serverConfigure(Transport transport, WireFormat format2, HashMap options) throws Exception {
        MutexTransport mutex = (transport = super.serverConfigure(transport, format2, options)).narrow(MutexTransport.class);
        if (mutex != null) {
            mutex.setSyncOnCommand(true);
        }
        return transport;
    }

    @Override
    public void setBrokerService(BrokerService brokerService) {
        this.brokerContext = brokerService.getBrokerContext();
    }

    @Override
    protected Transport createInactivityMonitor(Transport transport, WireFormat format2) {
        StompInactivityMonitor monitor = new StompInactivityMonitor(transport, format2);
        StompTransportFilter filter = transport.narrow(StompTransportFilter.class);
        filter.setInactivityMonitor(monitor);
        return monitor;
    }
}

