/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.transport.stomp;

import com.primeton.pmq.broker.BrokerContext;
import com.primeton.pmq.broker.BrokerService;
import com.primeton.pmq.broker.BrokerServiceAware;
import com.primeton.pmq.transport.MutexTransport;
import com.primeton.pmq.transport.Transport;
import com.primeton.pmq.transport.stomp.StompInactivityMonitor;
import com.primeton.pmq.transport.stomp.StompTransportFilter;
import com.primeton.pmq.transport.tcp.TcpTransportFactory;
import com.primeton.pmq.util.IntrospectionSupport;
import com.primeton.pmq.wireformat.WireFormat;
import java.util.HashMap;
import java.util.Map;

public class StompTransportFactory
extends TcpTransportFactory
implements BrokerServiceAware {
    private BrokerContext brokerContext = null;

    @Override
    protected String getDefaultWireFormatType() {
        return "stomp";
    }

    @Override
    public Transport compositeConfigure(Transport transport, WireFormat format2, Map options) {
        transport = new StompTransportFilter(transport, format2, this.brokerContext);
        IntrospectionSupport.setProperties(transport, options);
        return super.compositeConfigure(transport, format2, options);
    }

    @Override
    public void setBrokerService(BrokerService brokerService) {
        this.brokerContext = brokerService.getBrokerContext();
    }

    @Override
    public Transport serverConfigure(Transport transport, WireFormat format2, HashMap options) throws Exception {
        MutexTransport mutex = (transport = super.serverConfigure(transport, format2, options)).narrow(MutexTransport.class);
        if (mutex != null) {
            mutex.setSyncOnCommand(true);
        }
        return transport;
    }

    @Override
    protected Transport createInactivityMonitor(Transport transport, WireFormat format2) {
        StompInactivityMonitor monitor = new StompInactivityMonitor(transport, format2);
        StompTransportFilter filter = transport.narrow(StompTransportFilter.class);
        filter.setInactivityMonitor(monitor);
        return monitor;
    }
}

