/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.transport.stomp;

import com.primeton.pmq.util.ClassLoadingAwareObjectInputStream;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.security.AnyTypePermission;
import com.thoughtworks.xstream.security.NoTypePermission;
import com.thoughtworks.xstream.security.PrimitiveTypePermission;
import java.util.Collection;
import java.util.Map;

public class XStreamSupport {
    public static XStream createXStream() {
        XStream stream = new XStream();
        stream.addPermission(NoTypePermission.NONE);
        stream.addPermission(PrimitiveTypePermission.PRIMITIVES);
        stream.allowTypeHierarchy(Collection.class);
        stream.allowTypeHierarchy(Map.class);
        stream.allowTypes(new Class[]{String.class});
        if (ClassLoadingAwareObjectInputStream.isAllAllowed()) {
            stream.addPermission(AnyTypePermission.ANY);
        } else {
            for (String packageName : ClassLoadingAwareObjectInputStream.serializablePackages) {
                stream.allowTypesByWildcard(new String[]{packageName + ".**"});
            }
        }
        return stream;
    }
}

