/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.transport.tcp;

import com.primeton.pmq.transport.Transport;
import com.primeton.pmq.transport.tcp.SslTransport;
import com.primeton.pmq.transport.tcp.SslTransportFactory;
import com.primeton.pmq.transport.tcp.TcpTransportServer;
import com.primeton.pmq.wireformat.WireFormat;
import java.io.IOException;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;

public class SslTransportServer
extends TcpTransportServer {
    private boolean needClientAuth;
    private boolean wantClientAuth;

    public SslTransportServer(SslTransportFactory transportFactory, URI location, SSLServerSocketFactory serverSocketFactory) throws IOException, URISyntaxException {
        super(transportFactory, location, serverSocketFactory);
    }

    public void setNeedClientAuth(boolean needAuth) {
        this.needClientAuth = needAuth;
    }

    public boolean getNeedClientAuth() {
        return this.needClientAuth;
    }

    public boolean getWantClientAuth() {
        return this.wantClientAuth;
    }

    public void setWantClientAuth(boolean wantAuth) {
        this.wantClientAuth = wantAuth;
    }

    @Override
    public void bind() throws IOException {
        super.bind();
        if (this.needClientAuth) {
            ((SSLServerSocket)this.serverSocket).setNeedClientAuth(true);
        } else if (this.wantClientAuth) {
            ((SSLServerSocket)this.serverSocket).setWantClientAuth(true);
        }
    }

    @Override
    protected Transport createTransport(Socket socket, WireFormat format2) throws IOException {
        return new SslTransport(format2, (SSLSocket)socket);
    }

    @Override
    public boolean isSslServer() {
        return true;
    }
}

