/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.transport.udp;

import com.primeton.pmq.command.Command;
import com.primeton.pmq.openwire.OpenWireFormat;
import com.primeton.pmq.transport.reliable.ReplayBuffer;
import com.primeton.pmq.transport.udp.CommandChannel;
import com.primeton.pmq.transport.udp.DatagramHeaderMarshaller;
import com.primeton.pmq.transport.udp.UdpTransport;
import com.primeton.pmq.util.IntSequenceGenerator;
import java.io.IOException;
import java.net.SocketAddress;

public abstract class CommandChannelSupport
implements CommandChannel {
    protected OpenWireFormat wireFormat;
    protected int datagramSize = 4096;
    protected SocketAddress targetAddress;
    protected SocketAddress replayAddress;
    protected final String name;
    protected final IntSequenceGenerator sequenceGenerator;
    protected DatagramHeaderMarshaller headerMarshaller;
    private ReplayBuffer replayBuffer;

    public CommandChannelSupport(UdpTransport transport, OpenWireFormat wireFormat, int datagramSize, SocketAddress targetAddress, DatagramHeaderMarshaller headerMarshaller) {
        this.wireFormat = wireFormat;
        this.datagramSize = datagramSize;
        this.targetAddress = targetAddress;
        this.headerMarshaller = headerMarshaller;
        this.name = transport.toString();
        this.sequenceGenerator = transport.getSequenceGenerator();
        this.replayAddress = targetAddress;
        if (this.sequenceGenerator == null) {
            throw new IllegalArgumentException("No sequenceGenerator on the given transport: " + transport);
        }
    }

    public void write(Command command) throws IOException {
        this.write(command, this.targetAddress);
    }

    @Override
    public int getDatagramSize() {
        return this.datagramSize;
    }

    @Override
    public void setDatagramSize(int datagramSize) {
        this.datagramSize = datagramSize;
    }

    public SocketAddress getTargetAddress() {
        return this.targetAddress;
    }

    @Override
    public void setTargetAddress(SocketAddress targetAddress) {
        this.targetAddress = targetAddress;
    }

    public SocketAddress getReplayAddress() {
        return this.replayAddress;
    }

    @Override
    public void setReplayAddress(SocketAddress replayAddress) {
        this.replayAddress = replayAddress;
    }

    public String toString() {
        return "CommandChannel#" + this.name;
    }

    @Override
    public DatagramHeaderMarshaller getHeaderMarshaller() {
        return this.headerMarshaller;
    }

    @Override
    public void setHeaderMarshaller(DatagramHeaderMarshaller headerMarshaller) {
        this.headerMarshaller = headerMarshaller;
    }

    public ReplayBuffer getReplayBuffer() {
        return this.replayBuffer;
    }

    @Override
    public void setReplayBuffer(ReplayBuffer replayBuffer) {
        this.replayBuffer = replayBuffer;
    }
}

