/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.transport.udp;

import com.primeton.pmq.TransportLoggerSupport;
import com.primeton.pmq.openwire.OpenWireFormat;
import com.primeton.pmq.transport.CommandJoiner;
import com.primeton.pmq.transport.InactivityMonitor;
import com.primeton.pmq.transport.Transport;
import com.primeton.pmq.transport.TransportFactory;
import com.primeton.pmq.transport.TransportServer;
import com.primeton.pmq.transport.reliable.DefaultReplayStrategy;
import com.primeton.pmq.transport.reliable.ExceptionIfDroppedReplayStrategy;
import com.primeton.pmq.transport.reliable.ReliableTransport;
import com.primeton.pmq.transport.reliable.ReplayStrategy;
import com.primeton.pmq.transport.reliable.Replayer;
import com.primeton.pmq.transport.tcp.TcpTransportFactory;
import com.primeton.pmq.transport.udp.ResponseRedirectInterceptor;
import com.primeton.pmq.transport.udp.UdpTransport;
import com.primeton.pmq.transport.udp.UdpTransportServer;
import com.primeton.pmq.util.IOExceptionSupport;
import com.primeton.pmq.util.IntrospectionSupport;
import com.primeton.pmq.util.URISupport;
import com.primeton.pmq.wireformat.WireFormat;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class UdpTransportFactory
extends TransportFactory {
    private static final Logger log = LoggerFactory.getLogger(TcpTransportFactory.class);

    @Override
    public TransportServer doBind(URI location) throws IOException {
        try {
            HashMap<String, String> options = new HashMap<String, String>(URISupport.parseParameters(location));
            if (options.containsKey("port")) {
                throw new IllegalArgumentException("The port property cannot be specified on a UDP server transport - please use the port in the URI syntax");
            }
            WireFormat wf = this.createWireFormat(options);
            int port = location.getPort();
            OpenWireFormat openWireFormat = this.asOpenWireFormat(wf);
            UdpTransport transport = (UdpTransport)this.createTransport(location.getPort(), wf);
            Transport configuredTransport = this.configure(transport, wf, options, true);
            UdpTransportServer server = new UdpTransportServer(location, transport, configuredTransport, this.createReplayStrategy());
            return server;
        }
        catch (URISyntaxException e) {
            throw IOExceptionSupport.create(e);
        }
        catch (Exception e) {
            throw IOExceptionSupport.create(e);
        }
    }

    @Override
    public Transport configure(Transport transport, WireFormat format2, Map options) throws Exception {
        return this.configure(transport, format2, options, false);
    }

    @Override
    public Transport compositeConfigure(Transport transport, WireFormat format2, Map options) {
        IntrospectionSupport.setProperties(transport, options);
        UdpTransport udpTransport = (UdpTransport)transport;
        transport = new CommandJoiner(transport, this.asOpenWireFormat(format2));
        if (udpTransport.isTrace()) {
            try {
                transport = TransportLoggerSupport.createTransportLogger(transport);
            }
            catch (Throwable e) {
                log.error("Could not create TransportLogger, reason: " + e, e);
            }
        }
        transport = new InactivityMonitor(transport, format2);
        if (format2 instanceof OpenWireFormat) {
            transport = this.configureClientSideNegotiator(transport, format2, udpTransport);
        }
        return transport;
    }

    @Override
    protected Transport createTransport(URI location, WireFormat wf) throws UnknownHostException, IOException {
        OpenWireFormat wireFormat = this.asOpenWireFormat(wf);
        return new UdpTransport(wireFormat, location);
    }

    protected Transport createTransport(int port, WireFormat wf) throws UnknownHostException, IOException {
        OpenWireFormat wireFormat = this.asOpenWireFormat(wf);
        return new UdpTransport(wireFormat, port);
    }

    protected Transport configure(Transport transport, WireFormat format2, Map options, boolean acceptServer) throws Exception {
        IntrospectionSupport.setProperties(transport, options);
        UdpTransport udpTransport = (UdpTransport)transport;
        OpenWireFormat openWireFormat = this.asOpenWireFormat(format2);
        if (udpTransport.isTrace()) {
            transport = TransportLoggerSupport.createTransportLogger(transport);
        }
        transport = new InactivityMonitor(transport, format2);
        if (!acceptServer && format2 instanceof OpenWireFormat) {
            transport = this.configureClientSideNegotiator(transport, format2, udpTransport);
        }
        if (acceptServer) {
            udpTransport.setReplayEnabled(false);
            transport = new CommandJoiner(transport, openWireFormat);
            return transport;
        }
        ReliableTransport reliableTransport = new ReliableTransport(transport, udpTransport);
        Replayer replayer = reliableTransport.getReplayer();
        reliableTransport.setReplayStrategy(this.createReplayStrategy(replayer));
        return new CommandJoiner(reliableTransport, openWireFormat);
    }

    protected ReplayStrategy createReplayStrategy(Replayer replayer) {
        if (replayer != null) {
            return new DefaultReplayStrategy(5);
        }
        return new ExceptionIfDroppedReplayStrategy(1);
    }

    protected ReplayStrategy createReplayStrategy() {
        return new DefaultReplayStrategy(5);
    }

    protected Transport configureClientSideNegotiator(Transport transport, WireFormat format2, UdpTransport udpTransport) {
        return new ResponseRedirectInterceptor(transport, udpTransport);
    }

    protected OpenWireFormat asOpenWireFormat(WireFormat wf) {
        OpenWireFormat answer = (OpenWireFormat)wf;
        return answer;
    }
}

