/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.transport.wss;

import com.primeton.pmq.broker.BrokerService;
import com.primeton.pmq.broker.BrokerServiceAware;
import com.primeton.pmq.broker.SslContext;
import com.primeton.pmq.transport.TransportFactory;
import com.primeton.pmq.transport.TransportServer;
import com.primeton.pmq.transport.wss.WSSTransportServer;
import com.primeton.pmq.util.IOExceptionSupport;
import com.primeton.pmq.util.IntrospectionSupport;
import com.primeton.pmq.util.URISupport;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;

public class WSSTransportFactory
extends TransportFactory
implements BrokerServiceAware {
    private BrokerService brokerService;

    @Override
    public TransportServer doBind(URI location) throws IOException {
        try {
            HashMap<String, String> options = new HashMap<String, String>(URISupport.parseParameters(location));
            WSSTransportServer result = new WSSTransportServer(location, SslContext.getCurrentSslContext());
            Map<String, Object> httpOptions = IntrospectionSupport.extractProperties(options, "http.");
            Map<String, Object> transportOptions = IntrospectionSupport.extractProperties(options, "");
            IntrospectionSupport.setProperties(result, transportOptions);
            result.setTransportOption(transportOptions);
            result.setHttpOptions(httpOptions);
            result.setBrokerService(this.brokerService);
            return result;
        }
        catch (URISyntaxException e) {
            throw IOExceptionSupport.create(e);
        }
    }

    @Override
    public void setBrokerService(BrokerService brokerService) {
        this.brokerService = brokerService;
    }
}

