/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.stream.impl;

import com.rabbitmq.stream.Message;
import com.rabbitmq.stream.impl.RoutingStrategy;
import com.rabbitmq.stream.impl.StreamEnvironment;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;

class HashRoutingStrategy
implements RoutingStrategy {
    private final Function<Message, String> routingKeyExtractor;
    private final StreamEnvironment env;
    private final List<List<String>> partitions;
    private final ToIntFunction<String> hash;

    HashRoutingStrategy(String superStream, Function<Message, String> routingKeyExtractor, StreamEnvironment env, ToIntFunction<String> hash) {
        this.routingKeyExtractor = routingKeyExtractor;
        this.env = env;
        List<String> ps = this.env.locator().partitions(superStream);
        this.partitions = new CopyOnWriteArrayList<List<String>>(ps.stream().map(Collections::singletonList).collect(Collectors.toList()));
        this.hash = hash;
    }

    @Override
    public List<String> route(Message message) {
        String routingKey = this.routingKeyExtractor.apply(message);
        int hashValue = this.hash.applyAsInt(routingKey);
        return this.partitions.get((hashValue & Integer.MAX_VALUE) % this.partitions.size());
    }
}

