/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.stream.perf;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShutdownService
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ShutdownService.class);
    private final List<AutoCloseable> closeables = Collections.synchronizedList(new ArrayList());

    AutoCloseable wrap(final CloseCallback closeCallback) {
        final AtomicBoolean closingOrAlreadyClosed = new AtomicBoolean(false);
        AutoCloseable idempotentCloseCallback = new AutoCloseable(){

            @Override
            public void close() throws Exception {
                if (closingOrAlreadyClosed.compareAndSet(false, true)) {
                    closeCallback.run();
                }
            }

            public String toString() {
                return closeCallback.toString();
            }
        };
        this.closeables.add(idempotentCloseCallback);
        return idempotentCloseCallback;
    }

    @Override
    public synchronized void close() {
        if (this.closeables.size() > 0) {
            for (int i = this.closeables.size() - 1; i >= 0; --i) {
                try {
                    this.closeables.get(i).close();
                    continue;
                }
                catch (Exception e) {
                    LOGGER.warn("Could not properly execute closing step '{}'", (Object)this.closeables.get(i), (Object)e);
                }
            }
        }
    }

    @FunctionalInterface
    static interface CloseCallback {
        public void run() throws Exception;
    }
}

