/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import okhttp3.Dns;
import org.assertj.core.api.Assertions;

public final class FakeDns
implements Dns {
    private final Map<String, List<InetAddress>> hostAddresses = new LinkedHashMap<String, List<InetAddress>>();
    private final List<String> requestedHosts = new ArrayList<String>();
    private int nextAddress = 100;

    public FakeDns set(String hostname, List<InetAddress> addresses) {
        this.hostAddresses.put(hostname, addresses);
        return this;
    }

    public FakeDns clear(String hostname) {
        this.hostAddresses.remove(hostname);
        return this;
    }

    public InetAddress lookup(String hostname, int index) throws UnknownHostException {
        return this.hostAddresses.get(hostname).get(index);
    }

    public List<InetAddress> lookup(String hostname) throws UnknownHostException {
        this.requestedHosts.add(hostname);
        List<InetAddress> result = this.hostAddresses.get(hostname);
        if (result != null) {
            return result;
        }
        throw new UnknownHostException();
    }

    public void assertRequests(String ... expectedHosts) {
        Assertions.assertThat(this.requestedHosts).containsExactly((Object[])expectedHosts);
        this.requestedHosts.clear();
    }

    public List<InetAddress> allocate(int count) {
        try {
            ArrayList<InetAddress> result = new ArrayList<InetAddress>();
            for (int i = 0; i < count; ++i) {
                if (this.nextAddress > 255) {
                    throw new AssertionError((Object)"too many addresses allocated");
                }
                result.add(InetAddress.getByAddress(new byte[]{-1, 0, 0, (byte)this.nextAddress++}));
            }
            return result;
        }
        catch (UnknownHostException e) {
            throw new AssertionError();
        }
    }
}

