/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.io.IOException;
import okhttp3.ForwardingResponseBody;
import okhttp3.Interceptor;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSource;
import okio.ForwardingSource;
import okio.Okio;
import okio.Source;

public final class UppercaseResponseInterceptor
implements Interceptor {
    public Response intercept(Interceptor.Chain chain) throws IOException {
        return this.uppercaseResponse(chain.proceed(chain.request()));
    }

    private Response uppercaseResponse(Response response) {
        ForwardingResponseBody uppercaseBody = new ForwardingResponseBody(response.body()){

            @Override
            public BufferedSource source() {
                return Okio.buffer((Source)UppercaseResponseInterceptor.this.uppercaseSource(this.delegate().source()));
            }
        };
        return response.newBuilder().body((ResponseBody)uppercaseBody).build();
    }

    private ForwardingSource uppercaseSource(BufferedSource source) {
        return new ForwardingSource((Source)source){

            public long read(Buffer sink, long byteCount) throws IOException {
                Buffer buffer = new Buffer();
                long read = this.delegate().read(buffer, byteCount);
                if (read != -1L) {
                    sink.write(buffer.readByteString().toAsciiUppercase());
                }
                return read;
            }
        };
    }
}

