/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.ds.common;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Properties;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.sql.CommonDataSource;
import org.postgresql.Driver;
import org.postgresql.PGProperty;
import org.postgresql.ds.common.PGObjectFactory;
import org.postgresql.jdbc.AutoSave;
import org.postgresql.jdbc.PreferQueryMode;
import org.postgresql.log.Log;
import org.postgresql.util.ExpressionProperties;
import org.postgresql.util.GT;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;
import org.postgresql.util.URLCoder;

public abstract class BaseDataSource
implements CommonDataSource,
Referenceable {
    private static Log LOGGER = org.postgresql.log.Logger.getLogger(BaseDataSource.class.getName());
    private String originUrl;
    private String[] serverNames = new String[]{"localhost"};
    private String databaseName = "";
    private String user;
    private String password;
    private int[] portNumbers = new int[]{0};
    private boolean allowEncodingChanges = false;
    private String characterEncoding = "UTF8";
    private boolean connectionExtraInfo = false;
    private Properties properties = new Properties();

    public boolean getAllowEncodingChanges() {
        return this.allowEncodingChanges;
    }

    public void setAllowEncodingChanges(boolean allow) {
        this.allowEncodingChanges = allow;
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public void setCharacterEncoding(String encode) {
        this.characterEncoding = encode;
    }

    public Connection getConnection() throws SQLException {
        return this.getConnection(this.user, this.password);
    }

    public Connection getConnection(String user, String password) throws SQLException {
        try {
            Connection con = DriverManager.getConnection(this.getUrl(), user, password);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Created a " + this.getDescription() + " for " + user + " at " + this.getUrl());
            }
            return con;
        }
        catch (SQLException e) {
            LOGGER.debug("Failed to create a " + this.getDescription() + " for " + user + " at " + this.getUrl() + ": " + e);
            throw e;
        }
    }

    @Override
    public PrintWriter getLogWriter() {
        return null;
    }

    @Override
    public void setLogWriter(PrintWriter printWriter) {
    }

    @Deprecated
    public String getServerName() {
        return this.serverNames[0];
    }

    public String[] getServerNames() {
        return this.serverNames;
    }

    @Deprecated
    public void setServerName(String serverName) {
        this.setServerNames(new String[]{serverName});
    }

    public void setServerNames(String[] serverNames) {
        if (serverNames == null || serverNames.length == 0) {
            this.serverNames = new String[]{"localhost"};
        } else {
            serverNames = Arrays.copyOf(serverNames, serverNames.length);
            for (int i = 0; i < serverNames.length; ++i) {
                if (serverNames[i] != null && !serverNames[i].equals("")) continue;
                serverNames[i] = "localhost";
            }
            this.serverNames = serverNames;
        }
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public abstract String getDescription();

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Deprecated
    public int getPortNumber() {
        if (this.portNumbers == null || this.portNumbers.length == 0) {
            return 0;
        }
        return this.portNumbers[0];
    }

    public int[] getPortNumbers() {
        return this.portNumbers;
    }

    @Deprecated
    public void setPortNumber(int portNumber) {
        this.setPortNumbers(new int[]{portNumber});
    }

    public void setPortNumbers(int[] portNumbers) {
        if (portNumbers == null || portNumbers.length == 0) {
            portNumbers = new int[]{0};
        }
        this.portNumbers = Arrays.copyOf(portNumbers, portNumbers.length);
    }

    @Override
    public int getLoginTimeout() {
        return PGProperty.LOGIN_TIMEOUT.getIntNoCheck(this.properties);
    }

    @Override
    public void setLoginTimeout(int loginTimeout) {
        PGProperty.LOGIN_TIMEOUT.set(this.properties, loginTimeout);
    }

    public int getConnectTimeout() {
        return PGProperty.CONNECT_TIMEOUT.getIntNoCheck(this.properties);
    }

    public void setConnectTimeout(int connectTimeout) {
        PGProperty.CONNECT_TIMEOUT.set(this.properties, connectTimeout);
    }

    public int getProtocolVersion() {
        if (!PGProperty.PROTOCOL_VERSION.isPresent(this.properties)) {
            return 0;
        }
        return PGProperty.PROTOCOL_VERSION.getIntNoCheck(this.properties);
    }

    public void setProtocolVersion(int protocolVersion) {
        if (protocolVersion == 0) {
            PGProperty.PROTOCOL_VERSION.set(this.properties, null);
        } else {
            PGProperty.PROTOCOL_VERSION.set(this.properties, protocolVersion);
        }
    }

    public int getReceiveBufferSize() {
        return PGProperty.RECEIVE_BUFFER_SIZE.getIntNoCheck(this.properties);
    }

    public void setReceiveBufferSize(int nbytes) {
        PGProperty.RECEIVE_BUFFER_SIZE.set(this.properties, nbytes);
    }

    public int getSendBufferSize() {
        return PGProperty.SEND_BUFFER_SIZE.getIntNoCheck(this.properties);
    }

    public void setSendBufferSize(int nbytes) {
        PGProperty.SEND_BUFFER_SIZE.set(this.properties, nbytes);
    }

    public void setPrepareThreshold(int count) {
        PGProperty.PREPARE_THRESHOLD.set(this.properties, count);
    }

    public int getPrepareThreshold() {
        return PGProperty.PREPARE_THRESHOLD.getIntNoCheck(this.properties);
    }

    public int getPreparedStatementCacheQueries() {
        return PGProperty.PREPARED_STATEMENT_CACHE_QUERIES.getIntNoCheck(this.properties);
    }

    public void setPreparedStatementCacheQueries(int cacheSize) {
        PGProperty.PREPARED_STATEMENT_CACHE_QUERIES.set(this.properties, cacheSize);
    }

    public int getPreparedStatementCacheSizeMiB() {
        return PGProperty.PREPARED_STATEMENT_CACHE_SIZE_MIB.getIntNoCheck(this.properties);
    }

    public void setPreparedStatementCacheSizeMiB(int cacheSize) {
        PGProperty.PREPARED_STATEMENT_CACHE_SIZE_MIB.set(this.properties, cacheSize);
    }

    public int getDatabaseMetadataCacheFields() {
        return PGProperty.DATABASE_METADATA_CACHE_FIELDS.getIntNoCheck(this.properties);
    }

    public void setDatabaseMetadataCacheFields(int cacheSize) {
        PGProperty.DATABASE_METADATA_CACHE_FIELDS.set(this.properties, cacheSize);
    }

    public int getDatabaseMetadataCacheFieldsMiB() {
        return PGProperty.DATABASE_METADATA_CACHE_FIELDS_MIB.getIntNoCheck(this.properties);
    }

    public void setDatabaseMetadataCacheFieldsMiB(int cacheSize) {
        PGProperty.DATABASE_METADATA_CACHE_FIELDS_MIB.set(this.properties, cacheSize);
    }

    public void setDefaultRowFetchSize(int fetchSize) {
        PGProperty.DEFAULT_ROW_FETCH_SIZE.set(this.properties, fetchSize);
    }

    public int getDefaultRowFetchSize() {
        return PGProperty.DEFAULT_ROW_FETCH_SIZE.getIntNoCheck(this.properties);
    }

    public void setUnknownLength(int unknownLength) {
        PGProperty.UNKNOWN_LENGTH.set(this.properties, unknownLength);
    }

    public int getUnknownLength() {
        return PGProperty.UNKNOWN_LENGTH.getIntNoCheck(this.properties);
    }

    public void setSocketTimeout(int seconds) {
        PGProperty.SOCKET_TIMEOUT.set(this.properties, seconds);
    }

    public int getSocketTimeout() {
        return PGProperty.SOCKET_TIMEOUT.getIntNoCheck(this.properties);
    }

    public void setCancelSignalTimeout(int seconds) {
        PGProperty.CANCEL_SIGNAL_TIMEOUT.set(this.properties, seconds);
    }

    public int getCancelSignalTimeout() {
        return PGProperty.CANCEL_SIGNAL_TIMEOUT.getIntNoCheck(this.properties);
    }

    public void setSsl(boolean enabled) {
        if (enabled) {
            PGProperty.SSL.set(this.properties, true);
        } else {
            PGProperty.SSL.set(this.properties, false);
        }
    }

    public boolean getSsl() {
        return PGProperty.SSL.getBoolean(this.properties) || "".equals(PGProperty.SSL.get(this.properties));
    }

    public void setSslfactory(String classname) {
        PGProperty.SSL_FACTORY.set(this.properties, classname);
    }

    public String getSslfactory() {
        return PGProperty.SSL_FACTORY.get(this.properties);
    }

    public String getSslMode() {
        return PGProperty.SSL_MODE.get(this.properties);
    }

    public void setSslMode(String mode) {
        PGProperty.SSL_MODE.set(this.properties, mode);
    }

    public String getSslFactoryArg() {
        return PGProperty.SSL_FACTORY_ARG.get(this.properties);
    }

    public void setSslFactoryArg(String arg) {
        PGProperty.SSL_FACTORY_ARG.set(this.properties, arg);
    }

    public String getSslHostnameVerifier() {
        return PGProperty.SSL_HOSTNAME_VERIFIER.get(this.properties);
    }

    public void setSslHostnameVerifier(String className) {
        PGProperty.SSL_HOSTNAME_VERIFIER.set(this.properties, className);
    }

    public String getSslCert() {
        return PGProperty.SSL_CERT.get(this.properties);
    }

    public void setSslCert(String file) {
        PGProperty.SSL_CERT.set(this.properties, file);
    }

    public String getSslKey() {
        return PGProperty.SSL_KEY.get(this.properties);
    }

    public void setSslKey(String file) {
        PGProperty.SSL_KEY.set(this.properties, file);
    }

    public String getSslRootCert() {
        return PGProperty.SSL_ROOT_CERT.get(this.properties);
    }

    public void setSslRootCert(String file) {
        PGProperty.SSL_ROOT_CERT.set(this.properties, file);
    }

    public String getSslPassword() {
        return PGProperty.SSL_PASSWORD.get(this.properties);
    }

    public void setSslPassword(String password) {
        PGProperty.SSL_PASSWORD.set(this.properties, password);
    }

    public String getSslPasswordCallback() {
        return PGProperty.SSL_PASSWORD_CALLBACK.get(this.properties);
    }

    public void setSslPasswordCallback(String className) {
        PGProperty.SSL_PASSWORD_CALLBACK.set(this.properties, className);
    }

    public void setApplicationName(String applicationName) {
        PGProperty.APPLICATION_NAME.set(this.properties, applicationName);
    }

    public String getApplicationName() {
        return PGProperty.APPLICATION_NAME.get(this.properties);
    }

    public void setTargetServerType(String targetServerType) {
        PGProperty.TARGET_SERVER_TYPE.set(this.properties, targetServerType);
    }

    public String getTargetServerType() {
        return PGProperty.TARGET_SERVER_TYPE.get(this.properties);
    }

    public void setUsingEip(String usingEip) {
        PGProperty.USING_EIP.set(this.properties, usingEip);
    }

    public String getUsingEip() {
        return PGProperty.USING_EIP.get(this.properties);
    }

    public void setLoadBalanceHosts(boolean loadBalanceHosts) {
        PGProperty.LOAD_BALANCE_HOSTS.set(this.properties, loadBalanceHosts);
    }

    public boolean getLoadBalanceHosts() {
        return PGProperty.LOAD_BALANCE_HOSTS.isPresent(this.properties);
    }

    public void setHostRecheckSeconds(int hostRecheckSeconds) {
        PGProperty.HOST_RECHECK_SECONDS.set(this.properties, hostRecheckSeconds);
    }

    public int getHostRecheckSeconds() {
        return PGProperty.HOST_RECHECK_SECONDS.getIntNoCheck(this.properties);
    }

    public void setTcpKeepAlive(boolean enabled) {
        PGProperty.TCP_KEEP_ALIVE.set(this.properties, enabled);
    }

    public boolean getTcpKeepAlive() {
        return PGProperty.TCP_KEEP_ALIVE.getBoolean(this.properties);
    }

    public void setBinaryTransfer(boolean enabled) {
        PGProperty.BINARY_TRANSFER.set(this.properties, enabled);
    }

    public boolean getBinaryTransfer() {
        return PGProperty.BINARY_TRANSFER.getBoolean(this.properties);
    }

    public void setBinaryTransferEnable(String oidList) {
        PGProperty.BINARY_TRANSFER_ENABLE.set(this.properties, oidList);
    }

    public String getBinaryTransferEnable() {
        return PGProperty.BINARY_TRANSFER_ENABLE.get(this.properties);
    }

    public void setBinaryTransferDisable(String oidList) {
        PGProperty.BINARY_TRANSFER_DISABLE.set(this.properties, oidList);
    }

    public String getBinaryTransferDisable() {
        return PGProperty.BINARY_TRANSFER_DISABLE.get(this.properties);
    }

    public String getStringType() {
        return PGProperty.STRING_TYPE.get(this.properties);
    }

    public void setStringType(String stringType) {
        PGProperty.STRING_TYPE.set(this.properties, stringType);
    }

    public boolean isColumnSanitiserDisabled() {
        return PGProperty.DISABLE_COLUMN_SANITISER.getBoolean(this.properties);
    }

    public boolean getDisableColumnSanitiser() {
        return PGProperty.DISABLE_COLUMN_SANITISER.getBoolean(this.properties);
    }

    public void setDisableColumnSanitiser(boolean disableColumnSanitiser) {
        PGProperty.DISABLE_COLUMN_SANITISER.set(this.properties, disableColumnSanitiser);
    }

    public String getCurrentSchema() {
        return PGProperty.CURRENT_SCHEMA.get(this.properties);
    }

    public void setCurrentSchema(String currentSchema) {
        PGProperty.CURRENT_SCHEMA.set(this.properties, currentSchema);
    }

    public boolean getReadOnly() {
        return PGProperty.READ_ONLY.getBoolean(this.properties);
    }

    public void setReadOnly(boolean readOnly) {
        PGProperty.READ_ONLY.set(this.properties, readOnly);
    }

    public boolean getLogUnclosedConnections() {
        return PGProperty.LOG_UNCLOSED_CONNECTIONS.getBoolean(this.properties);
    }

    public void setLogUnclosedConnections(boolean enabled) {
        PGProperty.LOG_UNCLOSED_CONNECTIONS.set(this.properties, enabled);
    }

    public String getAssumeMinServerVersion() {
        return PGProperty.ASSUME_MIN_SERVER_VERSION.get(this.properties);
    }

    public void setAssumeMinServerVersion(String minVersion) {
        PGProperty.ASSUME_MIN_SERVER_VERSION.set(this.properties, minVersion);
    }

    public String getJaasApplicationName() {
        return PGProperty.JAAS_APPLICATION_NAME.get(this.properties);
    }

    public void setJaasApplicationName(String name) {
        PGProperty.JAAS_APPLICATION_NAME.set(this.properties, name);
    }

    public boolean getJaasLogin() {
        return PGProperty.JAAS_LOGIN.getBoolean(this.properties);
    }

    public void setJaasLogin(boolean doLogin) {
        PGProperty.JAAS_LOGIN.set(this.properties, doLogin);
    }

    public String getKerberosServerName() {
        return PGProperty.KERBEROS_SERVER_NAME.get(this.properties);
    }

    public void setKerberosServerName(String serverName) {
        PGProperty.KERBEROS_SERVER_NAME.set(this.properties, serverName);
    }

    public boolean getUseSpNego() {
        return PGProperty.USE_SPNEGO.getBoolean(this.properties);
    }

    public void setUseSpNego(boolean use) {
        PGProperty.USE_SPNEGO.set(this.properties, use);
    }

    public String getGssLib() {
        return PGProperty.GSS_LIB.get(this.properties);
    }

    public void setGssLib(String lib) {
        PGProperty.GSS_LIB.set(this.properties, lib);
    }

    public String getSspiServiceClass() {
        return PGProperty.SSPI_SERVICE_CLASS.get(this.properties);
    }

    public void setSspiServiceClass(String serviceClass) {
        PGProperty.SSPI_SERVICE_CLASS.set(this.properties, serviceClass);
    }

    public String getSocketFactory() {
        return PGProperty.SOCKET_FACTORY.get(this.properties);
    }

    public void setSocketFactory(String socketFactoryClassName) {
        PGProperty.SOCKET_FACTORY.set(this.properties, socketFactoryClassName);
    }

    public String getSocketFactoryArg() {
        return PGProperty.SOCKET_FACTORY_ARG.get(this.properties);
    }

    public void setSocketFactoryArg(String socketFactoryArg) {
        PGProperty.SOCKET_FACTORY_ARG.set(this.properties, socketFactoryArg);
    }

    public void setReplication(String replication) {
        PGProperty.REPLICATION.set(this.properties, replication);
    }

    public String getReplication() {
        return PGProperty.REPLICATION.get(this.properties);
    }

    public String getLoggerLevel() {
        return PGProperty.LOGGER_LEVEL.get(this.properties);
    }

    public void setLoggerLevel(String loggerLevel) {
        PGProperty.LOGGER_LEVEL.set(this.properties, loggerLevel);
    }

    public String getLoggerFile() {
        ExpressionProperties exprProps = new ExpressionProperties(this.properties, System.getProperties());
        return PGProperty.LOGGER_FILE.get(exprProps);
    }

    public void setLoggerFile(String loggerFile) {
        PGProperty.LOGGER_FILE.set(this.properties, loggerFile);
    }

    public void setConnectionExtraInfo(boolean connectionExtraInfo) {
        this.connectionExtraInfo = connectionExtraInfo;
    }

    public boolean getConnectionExtraInfo() {
        return this.connectionExtraInfo;
    }

    public String getUrl() {
        if (this.originUrl != null && this.originUrl.length() > 0 && this.databaseName == null) {
            return this.originUrl;
        }
        StringBuilder url = new StringBuilder(100);
        url.append("jdbc:postgresql://");
        for (int i = 0; i < this.serverNames.length; ++i) {
            if (i > 0) {
                url.append(",");
            }
            url.append(this.serverNames[i]);
            if (this.portNumbers == null || this.portNumbers.length < i || this.portNumbers[i] == 0) continue;
            url.append(":").append(this.portNumbers[i]);
        }
        url.append("/").append(URLCoder.encode(this.databaseName));
        StringBuilder query = new StringBuilder(100);
        for (PGProperty property : PGProperty.values()) {
            if (!property.isPresent(this.properties)) continue;
            if (query.length() != 0) {
                query.append("&");
            }
            query.append(property.getName());
            query.append("=");
            query.append(URLCoder.encode(property.get(this.properties)));
        }
        query.append("&binaryTransfer=true");
        query.append("&allowEncodingChanges=").append(this.allowEncodingChanges);
        query.append("&characterEncoding=").append(this.characterEncoding);
        query.append("&connectionExtraInfo=").append(this.connectionExtraInfo);
        if (query.length() > 0) {
            url.append("?");
            url.append((CharSequence)query);
        }
        return url.toString();
    }

    public String getURL() {
        return this.getUrl();
    }

    public void setUrl(String url) throws PSQLException {
        this.originUrl = url;
        Properties p = Driver.parseURL(url, null);
        if (p == null) {
            throw new IllegalArgumentException("URL invalid " + url);
        }
        for (PGProperty property : PGProperty.values()) {
            if (this.properties.containsKey(property.getName())) continue;
            this.setProperty(property, property.get(p));
        }
    }

    public void setURL(String url) throws PSQLException {
        this.setUrl(url);
    }

    public String getProperty(String name) throws SQLException {
        PGProperty pgProperty = PGProperty.forName(name);
        if (pgProperty != null) {
            return this.getProperty(pgProperty);
        }
        throw new PSQLException(GT.tr("Unsupported property name: {0}", name), PSQLState.INVALID_PARAMETER_VALUE);
    }

    public void setProperty(String name, String value) throws SQLException {
        PGProperty pgProperty = PGProperty.forName(name);
        if (pgProperty == null) {
            throw new PSQLException(GT.tr("Unsupported property name: {0}", name), PSQLState.INVALID_PARAMETER_VALUE);
        }
        this.setProperty(pgProperty, value);
    }

    public String getProperty(PGProperty property) {
        return property.get(this.properties);
    }

    public void setProperty(PGProperty property, String value) {
        if (value == null) {
            return;
        }
        switch (property) {
            case PG_HOST: {
                this.setServerNames(value.split(","));
                break;
            }
            case PG_PORT: {
                String[] ps = value.split(",");
                int[] ports = new int[ps.length];
                for (int i = 0; i < ps.length; ++i) {
                    try {
                        ports[i] = Integer.parseInt(ps[i]);
                        continue;
                    }
                    catch (NumberFormatException e) {
                        ports[i] = 0;
                    }
                }
                this.setPortNumbers(ports);
                break;
            }
            case PG_DBNAME: {
                this.setDatabaseName(value);
                break;
            }
            case USER: {
                this.setUser(value);
                break;
            }
            case PASSWORD: {
                this.setPassword(value);
                break;
            }
            default: {
                this.properties.setProperty(property.getName(), value);
            }
        }
    }

    protected Reference createReference() {
        return new Reference(this.getClass().getName(), PGObjectFactory.class.getName(), null);
    }

    @Override
    public Reference getReference() throws NamingException {
        Reference ref = this.createReference();
        StringBuilder serverString = new StringBuilder();
        for (int i = 0; i < this.serverNames.length; ++i) {
            if (i > 0) {
                serverString.append(",");
            }
            String serverName = this.serverNames[i];
            serverString.append(serverName);
        }
        ref.add(new StringRefAddr("serverName", serverString.toString()));
        StringBuilder portString = new StringBuilder();
        for (int i = 0; i < this.portNumbers.length; ++i) {
            if (i > 0) {
                portString.append(",");
            }
            int p = this.portNumbers[i];
            portString.append(Integer.toString(p));
        }
        ref.add(new StringRefAddr("portNumber", portString.toString()));
        ref.add(new StringRefAddr("databaseName", this.databaseName));
        if (this.user != null) {
            ref.add(new StringRefAddr("user", this.user));
        }
        if (this.password != null) {
            ref.add(new StringRefAddr("password", this.password));
        }
        ref.add(new StringRefAddr("characterEncoding", this.characterEncoding));
        ref.add(new StringRefAddr("connectionExtraInfo", Boolean.toString(this.connectionExtraInfo)));
        for (PGProperty property : PGProperty.values()) {
            if (!property.isPresent(this.properties)) continue;
            ref.add(new StringRefAddr(property.getName(), property.get(this.properties)));
        }
        return ref;
    }

    public void setFromReference(Reference ref) {
        this.databaseName = BaseDataSource.getReferenceProperty(ref, "databaseName");
        String portNumberString = BaseDataSource.getReferenceProperty(ref, "portNumber");
        if (portNumberString != null) {
            String[] ps = portNumberString.split(",");
            int[] ports = new int[ps.length];
            for (int i = 0; i < ps.length; ++i) {
                try {
                    ports[i] = Integer.parseInt(ps[i]);
                    continue;
                }
                catch (NumberFormatException e) {
                    ports[i] = 0;
                }
            }
            this.setPortNumbers(ports);
        } else {
            this.setPortNumbers(null);
        }
        String serverNameString = BaseDataSource.getReferenceProperty(ref, "serverName");
        if (serverNameString != null) {
            String[] serverNames = serverNameString.split(",");
            this.setServerNames(serverNames);
        } else {
            this.setServerNames(null);
        }
        for (PGProperty property : PGProperty.values()) {
            this.setProperty(property, BaseDataSource.getReferenceProperty(ref, property.getName()));
        }
    }

    private static String getReferenceProperty(Reference ref, String propertyName) {
        RefAddr addr = ref.get(propertyName);
        if (addr == null) {
            return null;
        }
        return (String)addr.getContent();
    }

    protected void writeBaseObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.serverNames);
        out.writeObject(this.databaseName);
        out.writeObject(this.user);
        out.writeObject(this.password);
        out.writeObject(this.portNumbers);
        out.writeBoolean(this.allowEncodingChanges);
        out.writeObject(this.characterEncoding);
        out.writeBoolean(this.connectionExtraInfo);
        out.writeObject(this.properties);
    }

    protected void readBaseObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.serverNames = (String[])in.readObject();
        this.databaseName = (String)in.readObject();
        this.user = (String)in.readObject();
        this.password = (String)in.readObject();
        this.portNumbers = (int[])in.readObject();
        this.allowEncodingChanges = in.readBoolean();
        this.characterEncoding = (String)in.readObject();
        this.connectionExtraInfo = in.readBoolean();
        this.properties = (Properties)in.readObject();
    }

    public void initializeFrom(BaseDataSource source) throws IOException, ClassNotFoundException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        source.writeBaseObject(oos);
        oos.close();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        ObjectInputStream ois = new ObjectInputStream(bais);
        this.readBaseObject(ois);
    }

    public PreferQueryMode getPreferQueryMode() {
        return PreferQueryMode.of(PGProperty.PREFER_QUERY_MODE.get(this.properties));
    }

    public void setPreferQueryMode(PreferQueryMode preferQueryMode) {
        PGProperty.PREFER_QUERY_MODE.set(this.properties, preferQueryMode.value());
    }

    public AutoSave getAutosave() {
        return AutoSave.of(PGProperty.AUTOSAVE.get(this.properties));
    }

    public void setAutosave(AutoSave autoSave) {
        PGProperty.AUTOSAVE.set(this.properties, autoSave.value());
    }

    public boolean getCleanupSavepoints() {
        return PGProperty.CLEANUP_SAVEPOINTS.getBoolean(this.properties);
    }

    public void setCleanupSavepoints(boolean cleanupSavepoints) {
        PGProperty.CLEANUP_SAVEPOINTS.set(this.properties, cleanupSavepoints);
    }

    public boolean getReWriteBatchedInserts() {
        return PGProperty.REWRITE_BATCHED_INSERTS.getBoolean(this.properties);
    }

    public void setReWriteBatchedInserts(boolean reWrite) {
        PGProperty.REWRITE_BATCHED_INSERTS.set(this.properties, reWrite);
    }

    public boolean isCleanupSavePoints() {
        return this.getCleanupSavepoints();
    }

    public void setCleanupSavePoints(boolean cleanupSavepoints) {
        this.setCleanupSavepoints(cleanupSavepoints);
    }

    @Override
    public Logger getParentLogger() {
        if (org.postgresql.log.Logger.isUsingJDKLogger()) {
            return Logger.getLogger("org.postgresql");
        }
        return null;
    }

    public String getXmlFactoryFactory() {
        return PGProperty.XML_FACTORY_FACTORY.get(this.properties);
    }

    public void setXmlFactoryFactory(String xmlFactoryFactory) {
        PGProperty.XML_FACTORY_FACTORY.set(this.properties, xmlFactoryFactory);
    }

    static {
        try {
            Class.forName("org.postgresql.Driver");
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("BaseDataSource is unable to load org.postgresql.Driver. Please check if you have proper PostgreSQL JDBC Driver jar on the classpath", e);
        }
    }
}

