/*
 * Decompiled with CFR 0.152.
 */
package cn.com.vastbase.jdbc;

import cn.com.vastbase.Driver;
import cn.com.vastbase.core.BaseConnection;
import cn.com.vastbase.core.CachedQuery;
import cn.com.vastbase.core.ParameterList;
import cn.com.vastbase.core.Query;
import cn.com.vastbase.core.ServerVersion;
import cn.com.vastbase.core.TypeInfo;
import cn.com.vastbase.core.types.PGBlob;
import cn.com.vastbase.core.v3.BatchedQuery;
import cn.com.vastbase.core.v3.ConnectionFactoryImpl;
import cn.com.vastbase.jdbc.BooleanTypeUtil;
import cn.com.vastbase.jdbc.DbCompatibility;
import cn.com.vastbase.jdbc.PgArray;
import cn.com.vastbase.jdbc.PgConnection;
import cn.com.vastbase.jdbc.PgParameterMetaData;
import cn.com.vastbase.jdbc.PgResultSet;
import cn.com.vastbase.jdbc.PgSQLXML;
import cn.com.vastbase.jdbc.PgStatement;
import cn.com.vastbase.jdbc.PreferQueryMode;
import cn.com.vastbase.jdbc.PrimitiveArraySupport;
import cn.com.vastbase.jdbc.ResultWrapper;
import cn.com.vastbase.jdbc.TimestampUtils;
import cn.com.vastbase.largeobject.LargeObject;
import cn.com.vastbase.largeobject.LargeObjectManager;
import cn.com.vastbase.log.Log;
import cn.com.vastbase.log.Logger;
import cn.com.vastbase.util.ByteConverter;
import cn.com.vastbase.util.GT;
import cn.com.vastbase.util.HStoreConverter;
import cn.com.vastbase.util.PGBinaryObject;
import cn.com.vastbase.util.PGTime;
import cn.com.vastbase.util.PGTimestamp;
import cn.com.vastbase.util.PGobject;
import cn.com.vastbase.util.PSQLException;
import cn.com.vastbase.util.PSQLState;
import cn.com.vastbase.util.ReaderInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.SQLXML;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public class PgPreparedStatement
extends PgStatement
implements PreparedStatement {
    protected final CachedQuery preparedQuery;
    protected final ParameterList preparedParameters;
    private static final Log LOGGER = Logger.getLogger(PgPreparedStatement.class.getName());
    private TimeZone defaultTimeZone;
    private static final ConcurrentHashMap<Integer, Integer> sqlTypeToOid = new ConcurrentHashMap();

    PgPreparedStatement(PgConnection connection, String sql, int rsType, int rsConcurrency, int rsHoldability) throws SQLException {
        this(connection, connection.borrowQuery(sql), rsType, rsConcurrency, rsHoldability);
    }

    PgPreparedStatement(PgConnection connection, CachedQuery query, int rsType, int rsConcurrency, int rsHoldability) throws SQLException {
        super(connection, rsType, rsConcurrency, rsHoldability);
        this.preparedQuery = query;
        this.preparedParameters = this.preparedQuery.query.createParameterList();
        int parameterCount = this.preparedParameters.getParameterCount();
        int maxSupportedParameters = this.maximumNumberOfParameters();
        if (parameterCount > maxSupportedParameters) {
            throw new PSQLException(GT.tr("PreparedStatement can have at most {0} parameters. Please consider using arrays, or splitting the query in several ones, or using COPY. Given query has {1} parameters", maxSupportedParameters, parameterCount), PSQLState.INVALID_PARAMETER_VALUE);
        }
        this.setPoolable(true);
    }

    final int maximumNumberOfParameters() {
        return this.connection.getPreferQueryMode() == PreferQueryMode.SIMPLE ? Integer.MAX_VALUE : 65535;
    }

    @Override
    public ResultSet executeQuery(String p_sql) throws SQLException {
        throw new PSQLException(GT.tr("Can''t use query methods that take a query string on a PreparedStatement.", new Object[0]), PSQLState.WRONG_OBJECT_TYPE);
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        if (!this.executeWithFlags(0)) {
            throw new PSQLException(GT.tr("No results were returned by the query.", new Object[0]), PSQLState.NO_DATA);
        }
        return this.getSingleResultSet();
    }

    @Override
    public int executeUpdate(String p_sql) throws SQLException {
        throw new PSQLException(GT.tr("Can''t use query methods that take a query string on a PreparedStatement.", new Object[0]), PSQLState.WRONG_OBJECT_TYPE);
    }

    @Override
    public int executeUpdate() throws SQLException {
        this.executeWithFlags(4);
        this.checkNoResultUpdate();
        return this.getUpdateCount();
    }

    @Override
    public long executeLargeUpdate() throws SQLException {
        this.executeWithFlags(4);
        this.checkNoResultUpdate();
        return this.getLargeUpdateCount();
    }

    @Override
    public boolean execute(String p_sql) throws SQLException {
        throw new PSQLException(GT.tr("Can''t use query methods that take a query string on a PreparedStatement.", new Object[0]), PSQLState.WRONG_OBJECT_TYPE);
    }

    @Override
    public boolean execute() throws SQLException {
        return this.executeWithFlags(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean executeWithFlags(int flags) throws SQLException {
        try {
            this.checkClosed();
            if (this.connection.getPreferQueryMode() == PreferQueryMode.SIMPLE) {
                flags |= 0x400;
            }
            this.execute(this.preparedQuery, this.preparedParameters, flags);
            PgPreparedStatement pgPreparedStatement = this;
            synchronized (pgPreparedStatement) {
                this.checkClosed();
                boolean bl = this.result != null && this.result.getResultSet() != null;
                return bl;
            }
        }
        finally {
            this.defaultTimeZone = null;
        }
    }

    @Override
    protected boolean isOneShotQuery(CachedQuery cachedQuery) {
        if (cachedQuery == null) {
            cachedQuery = this.preparedQuery;
        }
        return super.isOneShotQuery(cachedQuery);
    }

    @Override
    public void closeImpl() throws SQLException {
        if (this.preparedQuery != null) {
            ((PgConnection)this.connection).releaseQuery(this.preparedQuery);
        }
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        int oid;
        this.checkClosed();
        if (sqlType == -2 || sqlType == -4 || sqlType == -3) {
            oid = 0;
        } else if (sqlType == 12 || sqlType == -1 || sqlType == 2005 || sqlType == 2011) {
            oid = this.connection.getStringVarcharFlag() ? 1043 : 0;
        } else if (sqlType == 16) {
            oid = ConnectionFactoryImpl.USE_BOOLEAN != null && "TRUE".equals(ConnectionFactoryImpl.USE_BOOLEAN.toUpperCase(Locale.ENGLISH)) ? 16 : 21;
        } else if (sqlTypeToOid.containsKey(sqlType)) {
            oid = sqlTypeToOid.get(sqlType);
        } else {
            throw new PSQLException(GT.tr("Unknown Types value.", new Object[0]), PSQLState.INVALID_PARAMETER_TYPE);
        }
        this.preparedParameters.setNull(parameterIndex, oid);
    }

    public void setNull(String parameterName, int sqlType) throws SQLException {
        List<Integer> parameterIndexList = this.preparedQuery.query.getBindParameterIndex(parameterName);
        for (int index : parameterIndexList) {
            this.setNull(index, sqlType);
        }
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.checkClosed();
        if (ConnectionFactoryImpl.USE_BOOLEAN != null && "TRUE".equals(ConnectionFactoryImpl.USE_BOOLEAN.toUpperCase(Locale.ENGLISH))) {
            this.bindString(parameterIndex, x ? "1" : "0", 16);
        } else if (DbCompatibility.MYSQL == this.connection.getDbCompatibility()) {
            this.bindString(parameterIndex, x ? "1" : "0", 0);
        } else {
            this.bindString(parameterIndex, x ? "1" : "0", 21);
        }
    }

    public void setBoolean(String parameterName, boolean x) throws SQLException {
        List<Integer> parameterIndexList = this.preparedQuery.query.getBindParameterIndex(parameterName);
        for (int index : parameterIndexList) {
            this.setBoolean(index, x);
        }
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.setShort(parameterIndex, (short)x);
    }

    public void setByte(String parameterName, byte x) throws SQLException {
        List<Integer> parameterIndexList = this.preparedQuery.query.getBindParameterIndex(parameterName);
        for (int index : parameterIndexList) {
            this.setByte(index, x);
        }
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        this.checkClosed();
        if (this.connection.binaryTransferSend(21)) {
            byte[] val = new byte[2];
            ByteConverter.int2(val, 0, x);
            this.bindBytes(parameterIndex, val, 21);
            this.preparedParameters.saveLiteralValueForClientLogic(parameterIndex, Integer.toString(x));
            return;
        }
        this.bindLiteral(parameterIndex, Integer.toString(x), 21);
    }

    public void setShort(String parameterName, short x) throws SQLException {
        List<Integer> parameterIndexList = this.preparedQuery.query.getBindParameterIndex(parameterName);
        for (int index : parameterIndexList) {
            this.setShort(index, x);
        }
    }

    public void setTiny(int parameterIndex, short x) throws SQLException {
        this.checkClosed();
        if (this.connection.binaryTransferSend(5545)) {
            byte[] val = new byte[2];
            ByteConverter.int2(val, 0, x);
            this.bindBytes(parameterIndex, val, 21);
            this.preparedParameters.saveLiteralValueForClientLogic(parameterIndex, Integer.toString(x));
            return;
        }
        this.bindLiteral(parameterIndex, Integer.toString(x), 21);
    }

    public void setTiny(String parameterName, short x) throws SQLException {
        List<Integer> parameterIndexList = this.preparedQuery.query.getBindParameterIndex(parameterName);
        for (int index : parameterIndexList) {
            this.setTiny(index, x);
        }
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        this.checkClosed();
        if (this.connection.binaryTransferSend(23)) {
            byte[] val = new byte[4];
            ByteConverter.int4(val, 0, x);
            this.bindBytes(parameterIndex, val, 23);
            this.preparedParameters.saveLiteralValueForClientLogic(parameterIndex, Integer.toString(x));
            return;
        }
        this.bindLiteral(parameterIndex, Integer.toString(x), 23);
    }

    public void setInt(String parameterName, int x) throws SQLException {
        List<Integer> parameterIndexList = this.preparedQuery.query.getBindParameterIndex(parameterName);
        for (int index : parameterIndexList) {
            this.setInt(index, x);
        }
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        this.checkClosed();
        if (this.connection.binaryTransferSend(20)) {
            byte[] val = new byte[8];
            ByteConverter.int8(val, 0, x);
            this.bindBytes(parameterIndex, val, 20);
            this.preparedParameters.saveLiteralValueForClientLogic(parameterIndex, Long.toString(x));
            return;
        }
        this.bindLiteral(parameterIndex, Long.toString(x), 20);
    }

    public void setLong(String parameterName, long x) throws SQLException {
        List<Integer> parameterIndexList = this.preparedQuery.query.getBindParameterIndex(parameterName);
        for (int index : parameterIndexList) {
            this.setLong(index, x);
        }
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.checkClosed();
        if (this.connection.binaryTransferSend(700)) {
            byte[] val = new byte[4];
            ByteConverter.float4(val, 0, x);
            this.bindBytes(parameterIndex, val, 700);
            this.preparedParameters.saveLiteralValueForClientLogic(parameterIndex, Float.toString(x));
            return;
        }
        this.bindLiteral(parameterIndex, Float.toString(x), 701);
    }

    public void setFloat(String parameterName, float x) throws SQLException {
        List<Integer> parameterIndexList = this.preparedQuery.query.getBindParameterIndex(parameterName);
        for (int index : parameterIndexList) {
            this.setFloat(index, x);
        }
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.checkClosed();
        if (this.connection.binaryTransferSend(701)) {
            byte[] val = new byte[8];
            ByteConverter.float8(val, 0, x);
            this.bindBytes(parameterIndex, val, 701);
            this.preparedParameters.saveLiteralValueForClientLogic(parameterIndex, Double.toString(x));
            return;
        }
        this.bindLiteral(parameterIndex, Double.toString(x), 701);
    }

    public void setDouble(String parameterName, double x) throws SQLException {
        List<Integer> parameterIndexList = this.preparedQuery.query.getBindParameterIndex(parameterName);
        for (int index : parameterIndexList) {
            this.setDouble(index, x);
        }
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.setNumber(parameterIndex, x);
    }

    public void setBigDecimal(String parameterName, BigDecimal x) throws SQLException {
        List<Integer> parameterIndexList = this.preparedQuery.query.getBindParameterIndex(parameterName);
        for (int index : parameterIndexList) {
            this.setBigDecimal(index, x);
        }
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        this.checkClosed();
        this.setString(parameterIndex, x, this.connection.getStringVarcharFlag() ? 1043 : 0);
    }

    public void setString(String parameterName, String x) throws SQLException {
        List<Integer> parameterIndexList = this.preparedQuery.query.getBindParameterIndex(parameterName);
        for (int index : parameterIndexList) {
            this.setString(index, x);
        }
    }

    private int getStringType() {
        return this.connection.getStringVarcharFlag() ? 1043 : 0;
    }

    protected void setString(int parameterIndex, String x, int oid) throws SQLException {
        this.checkClosed();
        if (x == null) {
            this.preparedParameters.setNull(parameterIndex, oid);
        } else {
            this.bindString(parameterIndex, x, oid);
        }
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.checkClosed();
        if (null == x) {
            this.setNull(parameterIndex, -3);
            return;
        }
        byte[] copy = new byte[x.length];
        System.arraycopy(x, 0, copy, 0, x.length);
        this.preparedParameters.setBytea(parameterIndex, copy, 0, x.length);
    }

    public void setBytes(String parameterName, byte[] x) throws SQLException {
        List<Integer> parameterIndexList = this.preparedQuery.query.getBindParameterIndex(parameterName);
        for (int index : parameterIndexList) {
            this.setBytes(index, x);
        }
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.setDate(parameterIndex, x, null);
    }

    public void setDate(String parameterName, Date x) throws SQLException {
        List<Integer> parameterIndexList = this.preparedQuery.query.getBindParameterIndex(parameterName);
        for (int index : parameterIndexList) {
            this.setDate(index, x);
        }
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.setTime(parameterIndex, x, null);
    }

    public void setTime(String parameterName, Time x) throws SQLException {
        List<Integer> parameterIndexList = this.preparedQuery.query.getBindParameterIndex(parameterName);
        for (int index : parameterIndexList) {
            this.setTime(index, x);
        }
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.setTimestamp(parameterIndex, x, null);
    }

    public void setTimestamp(String parameterName, Timestamp x) throws SQLException {
        List<Integer> parameterIndexList = this.preparedQuery.query.getBindParameterIndex(parameterName);
        for (int index : parameterIndexList) {
            this.setTimestamp(index, x);
        }
    }

    private void setCharacterStreamPost71(int parameterIndex, InputStream x, int length, String encoding) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex, 12);
            return;
        }
        if (length < 0) {
            throw new PSQLException(GT.tr("Invalid stream length {0}.", length), PSQLState.INVALID_PARAMETER_VALUE);
        }
        try {
            int n;
            InputStreamReader l_inStream = new InputStreamReader(x, encoding);
            char[] l_chars = new char[length];
            int l_charsRead = 0;
            while ((n = l_inStream.read(l_chars, l_charsRead, length - l_charsRead)) != -1 && (l_charsRead += n) != length) {
            }
            this.setString(parameterIndex, new String(l_chars, 0, l_charsRead), 1043);
        }
        catch (UnsupportedEncodingException l_uee) {
            throw new PSQLException(GT.tr("The JVM claims not to support the {0} encoding.", encoding), PSQLState.UNEXPECTED_ERROR, (Throwable)l_uee);
        }
        catch (IOException l_ioe) {
            throw new PSQLException(GT.tr("Provided InputStream failed.", new Object[0]), PSQLState.UNEXPECTED_ERROR, (Throwable)l_ioe);
        }
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.checkClosed();
        this.setCharacterStreamPost71(parameterIndex, x, length, "ASCII");
    }

    public void setAsciiStream(String parameterName, InputStream x, int length) throws SQLException {
        List<Integer> parameterIndexList = this.preparedQuery.query.getBindParameterIndex(parameterName);
        for (int index : parameterIndexList) {
            this.setAsciiStream(index, x, length);
        }
    }

    @Override
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.checkClosed();
        this.setCharacterStreamPost71(parameterIndex, x, length, "UTF-8");
    }

    public void setUnicodeStream(String parameterName, InputStream x, int length) throws SQLException {
        List<Integer> parameterIndexList = this.preparedQuery.query.getBindParameterIndex(parameterName);
        for (int index : parameterIndexList) {
            this.setUnicodeStream(index, x, length);
        }
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.checkClosed();
        if (((PgConnection)this.connection).isBlobMode()) {
            if (x == null) {
                this.setNull(parameterIndex, 2004);
                return;
            }
            if (length < 0) {
                throw new PSQLException(GT.tr("Invalid stream length {0}.", length), PSQLState.INVALID_PARAMETER_VALUE);
            }
            PGBlob blob = new PGBlob();
            byte[] tmp = new byte[length];
            try {
                int len = x.read(tmp);
                if (len < length) {
                    throw new PSQLException(GT.tr("Invalid stream length {0}.", length), PSQLState.INVALID_PARAMETER_VALUE);
                }
                blob.setBytes(1L, tmp);
            }
            catch (IOException e) {
                throw new PSQLException(GT.tr("Provided InputStream failed.", new Object[0]), PSQLState.UNEXPECTED_ERROR, (Throwable)e);
            }
            this.setBlob(parameterIndex, (Blob)blob);
        } else {
            if (x == null) {
                this.setNull(parameterIndex, -3);
                return;
            }
            if (length < 0) {
                throw new PSQLException(GT.tr("Invalid stream length {0}.", length), PSQLState.INVALID_PARAMETER_VALUE);
            }
            this.preparedParameters.setBytea(parameterIndex, x, length);
        }
    }

    public void setBinaryStream(String parameterName, InputStream x, int length) throws SQLException {
        List<Integer> parameterIndexList = this.preparedQuery.query.getBindParameterIndex(parameterName);
        for (int index : parameterIndexList) {
            this.setBinaryStream(index, x, length);
        }
    }

    @Override
    public void clearParameters() throws SQLException {
        this.checkClosed();
        this.preparedParameters.clear();
    }

    private void setPGobject(int parameterIndex, PGobject x) throws SQLException {
        String typename = x.getType();
        int oid = this.connection.getTypeInfo().getPGType(typename);
        if (oid == 0) {
            throw new PSQLException(GT.tr("Unknown type {0}.", typename), PSQLState.INVALID_PARAMETER_TYPE);
        }
        if (x instanceof PGBinaryObject && this.connection.binaryTransferSend(oid)) {
            PGBinaryObject binObj = (PGBinaryObject)((Object)x);
            byte[] data = new byte[binObj.lengthInBytes()];
            binObj.toBytes(data, 0);
            this.bindBytes(parameterIndex, data, oid);
            this.preparedParameters.saveLiteralValueForClientLogic(parameterIndex, x.getValue());
        } else {
            this.setString(parameterIndex, x.getValue(), oid);
        }
    }

    private void setMap(int parameterIndex, Map<?, ?> x) throws SQLException {
        int oid = this.connection.getTypeInfo().getPGType("hstore");
        if (oid == 0) {
            throw new PSQLException(GT.tr("No hstore extension installed.", new Object[0]), PSQLState.INVALID_PARAMETER_TYPE);
        }
        if (this.connection.binaryTransferSend(oid)) {
            byte[] data = HStoreConverter.toBytes(x, this.connection.getEncoding());
            this.bindBytes(parameterIndex, data, oid);
        } else {
            this.setString(parameterIndex, HStoreConverter.toString(x), oid);
        }
    }

    private void setNumber(int parameterIndex, Number x) throws SQLException {
        this.checkClosed();
        if (x == null) {
            this.setNull(parameterIndex, 3);
        } else {
            this.bindLiteral(parameterIndex, x.toString(), 1700);
        }
    }

    @Override
    public void setObject(int parameterIndex, Object in, int targetSqlType, int scale) throws SQLException {
        this.checkClosed();
        if (in == null) {
            this.setNull(parameterIndex, targetSqlType);
            return;
        }
        if (targetSqlType == 1111 && in instanceof UUID && this.connection.haveMinimumServerVersion(ServerVersion.v8_3)) {
            this.setUuid(parameterIndex, (UUID)in);
            return;
        }
        switch (targetSqlType) {
            case 2009: {
                if (in instanceof SQLXML) {
                    this.setSQLXML(parameterIndex, (SQLXML)in);
                    break;
                }
                this.setSQLXML(parameterIndex, (SQLXML)new PgSQLXML(this.connection, in.toString()));
                break;
            }
            case 4: {
                this.setInt(parameterIndex, PgPreparedStatement.castToInt(in));
                break;
            }
            case -6: {
                this.bindLiteral(parameterIndex, Integer.toString(PgPreparedStatement.castToShort(in)), 5545);
                break;
            }
            case 5: {
                this.setShort(parameterIndex, PgPreparedStatement.castToShort(in));
                break;
            }
            case -5: {
                this.setLong(parameterIndex, PgPreparedStatement.castToLong(in));
                break;
            }
            case 7: {
                this.setFloat(parameterIndex, PgPreparedStatement.castToFloat(in));
                break;
            }
            case 6: 
            case 8: {
                this.setDouble(parameterIndex, PgPreparedStatement.castToDouble(in));
                break;
            }
            case 2: 
            case 3: {
                this.setBigDecimal(parameterIndex, PgPreparedStatement.castToBigDecimal(in, scale));
                break;
            }
            case 1: {
                this.setString(parameterIndex, PgPreparedStatement.castToString(in), 1042);
                break;
            }
            case 12: {
                this.setString(parameterIndex, PgPreparedStatement.castToString(in), this.connection.getStringVarcharFlag() ? 1043 : 0);
                break;
            }
            case -1: {
                if (in instanceof InputStream) {
                    this.preparedParameters.setText(parameterIndex, (InputStream)in);
                    break;
                }
                this.setString(parameterIndex, PgPreparedStatement.castToString(in), 1043);
                break;
            }
            case 91: {
                Date tmpd;
                if (in instanceof Date) {
                    this.setDate(parameterIndex, (Date)in);
                    break;
                }
                if (in instanceof java.util.Date) {
                    tmpd = new Date(((java.util.Date)in).getTime());
                } else {
                    if (in instanceof LocalDate) {
                        this.setDate(parameterIndex, (LocalDate)in);
                        break;
                    }
                    tmpd = this.connection.getTimestampUtils().toDate(this.getDefaultCalendar(), in.toString());
                }
                this.setDate(parameterIndex, tmpd);
                break;
            }
            case 92: {
                Time tmpt;
                if (in instanceof Time) {
                    this.setTime(parameterIndex, (Time)in);
                    break;
                }
                if (in instanceof java.util.Date) {
                    tmpt = new Time(((java.util.Date)in).getTime());
                } else {
                    if (in instanceof LocalTime) {
                        this.setTime(parameterIndex, (LocalTime)in);
                        break;
                    }
                    tmpt = this.connection.getTimestampUtils().toTime(this.getDefaultCalendar(), in.toString());
                }
                this.setTime(parameterIndex, tmpt);
                break;
            }
            case 93: {
                Timestamp tmpts;
                if (in instanceof PGTimestamp) {
                    this.setObject(parameterIndex, in);
                    break;
                }
                if (in instanceof Timestamp) {
                    this.setTimestamp(parameterIndex, (Timestamp)in);
                    break;
                }
                if (in instanceof java.util.Date) {
                    tmpts = new Timestamp(((java.util.Date)in).getTime());
                } else {
                    if (in instanceof LocalDateTime) {
                        this.setTimestamp(parameterIndex, (LocalDateTime)in);
                        break;
                    }
                    tmpts = this.connection.getTimestampUtils().toTimestamp(this.getDefaultCalendar(), in.toString());
                }
                this.setTimestamp(parameterIndex, tmpts);
                break;
            }
            case 2014: {
                if (in instanceof OffsetDateTime) {
                    this.setTimestamp(parameterIndex, (OffsetDateTime)in);
                    break;
                }
                if (in instanceof PGTimestamp) {
                    this.setObject(parameterIndex, in);
                    break;
                }
                throw new PSQLException(GT.tr("Cannot cast an instance of {0} to type {1}", in.getClass().getName(), "Types.TIMESTAMP_WITH_TIMEZONE"), PSQLState.INVALID_PARAMETER_TYPE);
            }
            case -7: 
            case 16: {
                this.setBoolean(parameterIndex, BooleanTypeUtil.castToBoolean(in));
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                this.setObject(parameterIndex, in);
                break;
            }
            case 2004: {
                if (in instanceof Blob) {
                    this.setBlob(parameterIndex, (Blob)in);
                    break;
                }
                if (in instanceof InputStream) {
                    long oid = this.createBlob(parameterIndex, (InputStream)in, -1L);
                    this.setLong(parameterIndex, oid);
                    break;
                }
                throw new PSQLException(GT.tr("Cannot cast an instance of {0} to type {1}", in.getClass().getName(), "Types.BLOB"), PSQLState.INVALID_PARAMETER_TYPE);
            }
            case 2005: {
                if (in instanceof Clob) {
                    this.setClob(parameterIndex, (Clob)in);
                    break;
                }
                throw new PSQLException(GT.tr("Cannot cast an instance of {0} to type {1}", in.getClass().getName(), "Types.CLOB"), PSQLState.INVALID_PARAMETER_TYPE);
            }
            case 2011: {
                if (in instanceof NClob) {
                    this.setNClob(parameterIndex, (NClob)in);
                    break;
                }
                throw new PSQLException(GT.tr("Cannot cast an instance of {0} to type {1}", in.getClass().getName(), "Types.NCLOB"), PSQLState.INVALID_PARAMETER_TYPE);
            }
            case 2003: {
                if (in instanceof Array) {
                    this.setArray(parameterIndex, (Array)in);
                    break;
                }
                if (PrimitiveArraySupport.isSupportedPrimitiveArray(in)) {
                    this.setPrimitiveArray(parameterIndex, in);
                    break;
                }
                throw new PSQLException(GT.tr("Cannot cast an instance of {0} to type {1}", in.getClass().getName(), "Types.ARRAY"), PSQLState.INVALID_PARAMETER_TYPE);
            }
            case 2001: {
                this.bindString(parameterIndex, in.toString(), 0);
                break;
            }
            case -8: {
                this.setString(parameterIndex, PgPreparedStatement.castToString(in), 7301);
                break;
            }
            case 1111: {
                if (in instanceof PGobject) {
                    this.setPGobject(parameterIndex, (PGobject)in);
                    break;
                }
                if (in instanceof Struct) {
                    this.setStruct(parameterIndex, (Struct)in);
                    break;
                }
                if (in instanceof Map) {
                    this.setMap(parameterIndex, (Map)in);
                    break;
                }
                this.bindString(parameterIndex, in.toString(), 0);
                break;
            }
            case 2002: {
                this.setStruct(parameterIndex, (Struct)in);
                break;
            }
            default: {
                throw new PSQLException(GT.tr("Unsupported Types value: {0}", targetSqlType), PSQLState.INVALID_PARAMETER_TYPE);
            }
        }
    }

    public void setObject(String parameterName, Object in, int targetSqlType, int scale) throws SQLException {
        List<Integer> parameterIndexList = this.preparedQuery.query.getBindParameterIndex(parameterName);
        for (int index : parameterIndexList) {
            this.setObject(index, in, targetSqlType, scale);
        }
    }

    private <A> void setPrimitiveArray(int parameterIndex, A in) throws SQLException {
        PrimitiveArraySupport<A> arrayToString = PrimitiveArraySupport.getArraySupport(in);
        TypeInfo typeInfo = this.connection.getTypeInfo();
        int oid = arrayToString.getDefaultArrayTypeOid(typeInfo);
        if (arrayToString.supportBinaryRepresentation() && this.connection.getPreferQueryMode() != PreferQueryMode.SIMPLE) {
            this.bindBytes(parameterIndex, arrayToString.toBinaryRepresentation(this.connection, in), oid);
        } else {
            char delim = typeInfo.getArrayDelimiter(oid);
            this.setString(parameterIndex, arrayToString.toArrayString(delim, in), oid);
        }
    }

    private static String asString(Clob in) throws SQLException {
        return in.getSubString(1L, (int)in.length());
    }

    private static int castToInt(Object in) throws SQLException {
        try {
            if (in instanceof String) {
                return Integer.parseInt((String)in);
            }
            if (in instanceof Number) {
                return ((Number)in).intValue();
            }
            if (in instanceof java.util.Date) {
                return (int)((java.util.Date)in).getTime();
            }
            if (in instanceof Boolean) {
                return (Boolean)in != false ? 1 : 0;
            }
            if (in instanceof Clob) {
                return Integer.parseInt(PgPreparedStatement.asString((Clob)in));
            }
            if (in instanceof Character) {
                return Integer.parseInt(in.toString());
            }
        }
        catch (Exception e) {
            throw PgPreparedStatement.cannotCastException(in.getClass().getName(), "int", e);
        }
        throw PgPreparedStatement.cannotCastException(in.getClass().getName(), "int");
    }

    private static short castToShort(Object in) throws SQLException {
        try {
            if (in instanceof String) {
                return Short.parseShort((String)in);
            }
            if (in instanceof Number) {
                return ((Number)in).shortValue();
            }
            if (in instanceof java.util.Date) {
                return (short)((java.util.Date)in).getTime();
            }
            if (in instanceof Boolean) {
                return (Boolean)in != false ? (short)1 : 0;
            }
            if (in instanceof Clob) {
                return Short.parseShort(PgPreparedStatement.asString((Clob)in));
            }
            if (in instanceof Character) {
                return Short.parseShort(in.toString());
            }
        }
        catch (Exception e) {
            throw PgPreparedStatement.cannotCastException(in.getClass().getName(), "short", e);
        }
        throw PgPreparedStatement.cannotCastException(in.getClass().getName(), "short");
    }

    private static long castToLong(Object in) throws SQLException {
        try {
            if (in instanceof String) {
                return Long.parseLong((String)in);
            }
            if (in instanceof Number) {
                return ((Number)in).longValue();
            }
            if (in instanceof java.util.Date) {
                return ((java.util.Date)in).getTime();
            }
            if (in instanceof Boolean) {
                return (Boolean)in != false ? 1L : 0L;
            }
            if (in instanceof Clob) {
                return Long.parseLong(PgPreparedStatement.asString((Clob)in));
            }
            if (in instanceof Character) {
                return Long.parseLong(in.toString());
            }
        }
        catch (Exception e) {
            throw PgPreparedStatement.cannotCastException(in.getClass().getName(), "long", e);
        }
        throw PgPreparedStatement.cannotCastException(in.getClass().getName(), "long");
    }

    private static float castToFloat(Object in) throws SQLException {
        try {
            if (in instanceof String) {
                return Float.parseFloat((String)in);
            }
            if (in instanceof Number) {
                return ((Number)in).floatValue();
            }
            if (in instanceof java.util.Date) {
                return ((java.util.Date)in).getTime();
            }
            if (in instanceof Boolean) {
                return (Boolean)in != false ? 1.0f : 0.0f;
            }
            if (in instanceof Clob) {
                return Float.parseFloat(PgPreparedStatement.asString((Clob)in));
            }
            if (in instanceof Character) {
                return Float.parseFloat(in.toString());
            }
        }
        catch (Exception e) {
            throw PgPreparedStatement.cannotCastException(in.getClass().getName(), "float", e);
        }
        throw PgPreparedStatement.cannotCastException(in.getClass().getName(), "float");
    }

    private static double castToDouble(Object in) throws SQLException {
        try {
            if (in instanceof String) {
                return Double.parseDouble((String)in);
            }
            if (in instanceof Number) {
                return ((Number)in).doubleValue();
            }
            if (in instanceof java.util.Date) {
                return ((java.util.Date)in).getTime();
            }
            if (in instanceof Boolean) {
                return (Boolean)in != false ? 1.0 : 0.0;
            }
            if (in instanceof Clob) {
                return Double.parseDouble(PgPreparedStatement.asString((Clob)in));
            }
            if (in instanceof Character) {
                return Double.parseDouble(in.toString());
            }
        }
        catch (Exception e) {
            throw PgPreparedStatement.cannotCastException(in.getClass().getName(), "double", e);
        }
        throw PgPreparedStatement.cannotCastException(in.getClass().getName(), "double");
    }

    private static BigDecimal castToBigDecimal(Object in, int scale) throws SQLException {
        try {
            BigDecimal rc = null;
            if (in instanceof String) {
                rc = new BigDecimal((String)in);
            } else if (in instanceof BigDecimal) {
                rc = (BigDecimal)in;
            } else if (in instanceof BigInteger) {
                rc = new BigDecimal((BigInteger)in);
            } else if (in instanceof Long || in instanceof Integer || in instanceof Short || in instanceof Byte) {
                rc = BigDecimal.valueOf(((Number)in).longValue());
            } else if (in instanceof Double || in instanceof Float) {
                rc = BigDecimal.valueOf(((Number)in).doubleValue());
            } else if (in instanceof java.util.Date) {
                rc = BigDecimal.valueOf(((java.util.Date)in).getTime());
            } else if (in instanceof Boolean) {
                rc = (Boolean)in != false ? BigDecimal.ONE : BigDecimal.ZERO;
            } else if (in instanceof Clob) {
                rc = new BigDecimal(PgPreparedStatement.asString((Clob)in));
            } else if (in instanceof Character) {
                rc = new BigDecimal(new char[]{((Character)in).charValue()});
            }
            if (rc != null) {
                if (scale >= 0) {
                    rc = rc.setScale(scale, RoundingMode.HALF_UP);
                }
                return rc;
            }
        }
        catch (Exception e) {
            throw PgPreparedStatement.cannotCastException(in.getClass().getName(), "BigDecimal", e);
        }
        throw PgPreparedStatement.cannotCastException(in.getClass().getName(), "BigDecimal");
    }

    private static String castToString(Object in) throws SQLException {
        try {
            if (in instanceof String) {
                return (String)in;
            }
            if (in instanceof Clob) {
                return PgPreparedStatement.asString((Clob)in);
            }
            return in.toString();
        }
        catch (Exception e) {
            throw PgPreparedStatement.cannotCastException(in.getClass().getName(), "String", e);
        }
    }

    private static PSQLException cannotCastException(String fromType, String toType) {
        return PgPreparedStatement.cannotCastException(fromType, toType, null);
    }

    private static PSQLException cannotCastException(String fromType, String toType, Exception cause) {
        return new PSQLException(GT.tr("Cannot convert an instance of {0} to type {1}", fromType, toType), PSQLState.INVALID_PARAMETER_TYPE, (Throwable)cause);
    }

    @Override
    public void setObject(int parameterIndex, Object x, SQLType targetSqlType) throws SQLException {
        this.setObject(parameterIndex, x, (int)targetSqlType.getVendorTypeNumber());
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.setObject(parameterIndex, x, targetSqlType, -1);
    }

    public void setObject(String parameterName, Object x, int targetSqlType) throws SQLException {
        List<Integer> parameterIndexList = this.preparedQuery.query.getBindParameterIndex(parameterName);
        for (int index : parameterIndexList) {
            this.setObject(index, x, targetSqlType);
        }
    }

    private void setObjectOfString(int parameterIndex, Object x) throws SQLException {
        if (x instanceof String) {
            this.setString(parameterIndex, (String)x);
        } else if (x instanceof Character) {
            this.setString(parameterIndex, ((Character)x).toString());
        }
    }

    private void setObjectOfFigure(int parameterIndex, Object x) throws SQLException {
        if (x instanceof BigDecimal) {
            this.setBigDecimal(parameterIndex, (BigDecimal)x);
        } else if (x instanceof Short) {
            this.setShort(parameterIndex, (short)((Short)x));
        } else if (x instanceof Integer) {
            this.setInt(parameterIndex, (int)((Integer)x));
        } else if (x instanceof Long) {
            this.setLong(parameterIndex, (long)((Long)x));
        } else if (x instanceof Float) {
            this.setFloat(parameterIndex, ((Float)x).floatValue());
        } else if (x instanceof Double) {
            this.setDouble(parameterIndex, (double)((Double)x));
        }
    }

    private void setObjectOfDate(int parameterIndex, Object x) throws SQLException {
        if (x instanceof Date) {
            this.setDate(parameterIndex, (Date)x);
        } else if (x instanceof Time) {
            this.setTime(parameterIndex, (Time)x);
        } else if (x instanceof Timestamp) {
            this.setTimestamp(parameterIndex, (Timestamp)x);
        }
    }

    private void setObjectOfByte(int parameterIndex, Object x) throws SQLException {
        if (x instanceof byte[]) {
            this.setBytes(parameterIndex, (byte[])x);
        } else if (x instanceof Byte) {
            this.setByte(parameterIndex, (byte)((Byte)x));
        }
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.checkClosed();
        if (x == null) {
            this.setNull(parameterIndex, 1111);
        } else if (x instanceof UUID && this.connection.haveMinimumServerVersion(ServerVersion.v8_3)) {
            this.setUuid(parameterIndex, (UUID)x);
        } else if (x instanceof SQLXML) {
            this.setSQLXML(parameterIndex, (SQLXML)x);
        } else if (x instanceof String || x instanceof Character) {
            this.setObjectOfString(parameterIndex, x);
        } else if (x instanceof BigDecimal || x instanceof Short || x instanceof Integer || x instanceof Long || x instanceof Float || x instanceof Double) {
            this.setObjectOfFigure(parameterIndex, x);
        } else if (x instanceof byte[] || x instanceof Byte) {
            this.setObjectOfByte(parameterIndex, x);
        } else if (x instanceof Date || x instanceof Time || x instanceof Timestamp) {
            this.setObjectOfDate(parameterIndex, x);
        } else if (x instanceof LocalDate) {
            this.setDate(parameterIndex, (LocalDate)x);
        } else if (x instanceof LocalTime) {
            this.setTime(parameterIndex, (LocalTime)x);
        } else if (x instanceof LocalDateTime) {
            this.setTimestamp(parameterIndex, (LocalDateTime)x);
        } else if (x instanceof OffsetDateTime) {
            this.setTimestamp(parameterIndex, (OffsetDateTime)x);
        } else if (x instanceof Boolean) {
            this.setBoolean(parameterIndex, (boolean)((Boolean)x));
        } else if (x instanceof Blob) {
            this.setBlob(parameterIndex, (Blob)x);
        } else if (x instanceof Clob) {
            this.setClob(parameterIndex, (Clob)x);
        } else if (x instanceof NClob) {
            this.setNClob(parameterIndex, (NClob)x);
        } else if (x instanceof Array) {
            this.setArray(parameterIndex, (Array)x);
        } else if (x instanceof PGobject) {
            this.setPGobject(parameterIndex, (PGobject)x);
        } else if (x instanceof Map) {
            this.setMap(parameterIndex, (Map)x);
        } else if (x instanceof Number) {
            this.setNumber(parameterIndex, (Number)x);
        } else if (x instanceof RowId) {
            this.setRowId(parameterIndex, (RowId)x);
        } else if (x instanceof Struct) {
            this.setStruct(parameterIndex, (Struct)x);
        } else if (PrimitiveArraySupport.isSupportedPrimitiveArray(x)) {
            this.setPrimitiveArray(parameterIndex, x);
        } else if (x instanceof java.util.Date) {
            this.setDate(parameterIndex, new Date(((java.util.Date)x).getTime()));
        } else {
            throw new PSQLException(GT.tr("Can''t infer the SQL type to use for an instance of {0}. Use setObject() with an explicit Types value to specify the type to use.", x.getClass().getName()), PSQLState.INVALID_PARAMETER_TYPE);
        }
    }

    private void setStruct(int parameterIndex, Struct x) throws SQLException {
        String typename = x.getSQLTypeName();
        int oid = this.connection.getTypeInfo().getPGType(typename);
        if (oid == 0) {
            throw new PSQLException(GT.tr("Unknown type {0}.", typename), PSQLState.INVALID_PARAMETER_TYPE);
        }
        this.setString(parameterIndex, x.toString(), oid);
    }

    public void setObject(String parameterName, Object x) throws SQLException {
        List<Integer> parameterIndexList = this.preparedQuery.query.getBindParameterIndex(parameterName);
        for (int index : parameterIndexList) {
            this.setObject(index, x);
        }
    }

    public String toString() {
        if (this.preparedQuery == null) {
            return super.toString();
        }
        return this.preparedQuery.query.toString(this.preparedParameters);
    }

    protected void bindLiteral(int paramIndex, String s, int oid) throws SQLException {
        this.preparedParameters.setLiteralParameter(paramIndex, s, oid);
    }

    protected void bindBytes(int paramIndex, byte[] b, int oid) throws SQLException {
        this.preparedParameters.setBinaryParameter(paramIndex, b, oid);
    }

    private void bindString(int paramIndex, String s, int oid) throws SQLException {
        this.preparedParameters.setStringParameter(paramIndex, s, oid);
    }

    @Override
    public boolean isUseServerPrepare() {
        return this.preparedQuery != null && this.m_prepareThreshold != 0 && this.preparedQuery.getExecuteCount() + 1 >= this.m_prepareThreshold;
    }

    @Override
    public void addBatch(String p_sql) throws SQLException {
        this.checkClosed();
        throw new PSQLException(GT.tr("Can''t use query methods that take a query string on a PreparedStatement.", new Object[0]), PSQLState.WRONG_OBJECT_TYPE);
    }

    @Override
    public void addBatch() throws SQLException {
        this.checkClosed();
        if (this.batchStatements == null) {
            this.batchStatements = new ArrayList();
            this.batchParameters = new ArrayList();
        }
        this.batchParameters.add(this.preparedParameters.copy());
        Query query = this.preparedQuery.query;
        if (!(query instanceof BatchedQuery) || this.batchStatements.isEmpty()) {
            this.batchStatements.add(query);
        }
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkClosed();
        ResultSet rs = this.getResultSet();
        if (rs == null || ((PgResultSet)rs).isResultSetClosed()) {
            int flags = 49;
            PgStatement.StatementResultHandler handler = new PgStatement.StatementResultHandler(this);
            this.connection.getQueryExecutor().execute(this.preparedQuery.query, this.preparedParameters, handler, 0, 0, flags);
            ResultWrapper wrapper = handler.getResults();
            if (wrapper != null) {
                rs = wrapper.getResultSet();
            }
        }
        if (rs != null) {
            return rs.getMetaData();
        }
        return null;
    }

    @Override
    public void setArray(int i, Array x) throws SQLException {
        this.checkClosed();
        if (null == x) {
            this.setNull(i, 2003);
            return;
        }
        String typename = x.getBaseTypeName();
        int oid = this.connection.getTypeInfo().getPGArrayType(typename);
        if (oid == 0) {
            throw new PSQLException(GT.tr("Unknown type {0}.", typename), PSQLState.INVALID_PARAMETER_TYPE);
        }
        if (x instanceof PgArray) {
            PgArray arr = (PgArray)x;
            if (arr.connection.checkVastBaseVersion("2.2.15").booleanValue()) {
                oid = arr.getOid();
            }
            if (arr.isBinary()) {
                this.bindBytes(i, arr.toBytes(), oid);
                this.preparedParameters.saveLiteralValueForClientLogic(i, x.toString());
                return;
            }
        }
        this.setString(i, x.toString(), oid);
    }

    public void setArray(String parameterName, Array x) throws SQLException {
        List<Integer> parameterIndexList = this.preparedQuery.query.getBindParameterIndex(parameterName);
        for (int index : parameterIndexList) {
            this.setArray(index, x);
        }
    }

    protected long createBlob(int i, InputStream inputStream, long length) throws SQLException {
        LargeObjectManager lom = this.connection.getLargeObjectAPI();
        long oid = lom.createLO();
        LargeObject lob = lom.open(oid);
        OutputStream outputStream = lob.getOutputStream();
        byte[] buf = new byte[4096];
        try {
            long remaining = length > 0L ? length : Long.MAX_VALUE;
            int numRead = inputStream.read(buf, 0, length > 0L && remaining < (long)buf.length ? (int)remaining : buf.length);
            while (numRead != -1 && remaining > 0L) {
                outputStream.write(buf, 0, numRead);
                numRead = inputStream.read(buf, 0, length > 0L && remaining < (long)buf.length ? (int)(remaining -= (long)numRead) : buf.length);
            }
        }
        catch (IOException se) {
            throw new PSQLException(GT.tr("Unexpected error writing large object to database.", new Object[0]), PSQLState.UNEXPECTED_ERROR, (Throwable)se);
        }
        finally {
            try {
                outputStream.close();
            }
            catch (Exception e) {
                LOGGER.trace("Catch Exception on outputStream close:", e);
            }
        }
        return oid;
    }

    @Override
    public void setBlob(int i, Blob x) throws SQLException {
        this.checkClosed();
        if (x == null) {
            if (((PgConnection)this.connection).getOraBlobMode().booleanValue()) {
                this.setNull(i, 0);
            }
            this.setNull(i, 2004);
            return;
        }
        byte[] byt = x.getBytes(1L, (int)x.length());
        byte[] copy = new byte[byt.length];
        System.arraycopy(byt, 0, copy, 0, byt.length);
        if (((PgConnection)this.connection).getOraBlobMode().booleanValue()) {
            if (((PgConnection)this.connection).checkVastBaseVersion("2.2.15").booleanValue()) {
                this.preparedParameters.setBinaryParameter(i, copy, 3399);
            } else {
                this.preparedParameters.setBinaryParameter(i, copy, 86);
            }
        } else {
            this.preparedParameters.setBlob(i, copy, 0, byt.length);
        }
    }

    public void setBlob(String parameterName, Blob x) throws SQLException {
        List<Integer> parameterIndexList = this.preparedQuery.query.getBindParameterIndex(parameterName);
        for (int index : parameterIndexList) {
            this.setBlob(index, x);
        }
    }

    private String readerToString(Reader value, int maxLength) throws SQLException {
        try {
            int bufferSize = Math.min(maxLength, 1024);
            StringBuilder v = new StringBuilder(bufferSize);
            char[] buf = new char[bufferSize];
            int nRead = 0;
            while (nRead > -1 && v.length() < maxLength) {
                nRead = value.read(buf, 0, Math.min(bufferSize, maxLength - v.length()));
                if (nRead <= 0) continue;
                v.append(buf, 0, nRead);
            }
            return v.toString();
        }
        catch (IOException ioe) {
            throw new PSQLException(GT.tr("Provided Reader failed.", new Object[0]), PSQLState.UNEXPECTED_ERROR, (Throwable)ioe);
        }
    }

    @Override
    public void setCharacterStream(int i, Reader x, int length) throws SQLException {
        this.checkClosed();
        if (x == null) {
            this.setNull(i, 12);
            return;
        }
        if (length < 0) {
            throw new PSQLException(GT.tr("Invalid stream length {0}.", length), PSQLState.INVALID_PARAMETER_VALUE);
        }
        this.setString(i, this.readerToString(x, length));
    }

    public void setCharacterStream(String parameterName, Reader x, int length) throws SQLException {
        List<Integer> parameterIndexList = this.preparedQuery.query.getBindParameterIndex(parameterName);
        for (int index : parameterIndexList) {
            this.setCharacterStream(index, x, length);
        }
    }

    @Override
    public void setClob(int i, Clob x) throws SQLException {
        this.checkClosed();
        if (x == null) {
            this.setNull(i, 12);
            return;
        }
        if (x.length() == 0L) {
            this.setString(i, "");
            return;
        }
        String str = x.getSubString(1L, (int)x.length());
        this.setString(i, str, this.connection.getStringVarcharFlag() ? 1043 : 0);
    }

    public void setClob(String parameterName, Clob x) throws SQLException {
        List<Integer> parameterIndexList = this.preparedQuery.query.getBindParameterIndex(parameterName);
        for (int index : parameterIndexList) {
            this.setClob(index, x);
        }
    }

    @Override
    public void setNClob(int i, NClob x) throws SQLException {
        this.checkClosed();
        if (x == null) {
            this.setNull(i, 12);
            return;
        }
        if (x.length() == 0L) {
            this.setString(i, "");
            return;
        }
        String str = x.getSubString(1L, (int)x.length());
        this.setString(i, str, this.connection.getStringVarcharFlag() ? 1043 : 0);
    }

    public void setNClob(String parameterName, NClob x) throws SQLException {
        List<Integer> parameterIndexList = this.preparedQuery.query.getBindParameterIndex(parameterName);
        for (int index : parameterIndexList) {
            this.setNClob(index, x);
        }
    }

    @Override
    public void setNull(int parameterIndex, int t, String typeName) throws SQLException {
        if (typeName == null) {
            this.setNull(parameterIndex, t);
            return;
        }
        this.checkClosed();
        TypeInfo typeInfo = this.connection.getTypeInfo();
        int oid = typeInfo.getPGType(typeName);
        if (oid == 16 && ConnectionFactoryImpl.USE_BOOLEAN != null && "FALSE".equals(ConnectionFactoryImpl.USE_BOOLEAN.toUpperCase(Locale.ENGLISH))) {
            oid = 21;
        }
        this.preparedParameters.setNull(parameterIndex, oid);
    }

    public void setNull(String parameterName, int t, String typeName) throws SQLException {
        List<Integer> parameterIndexList = this.preparedQuery.query.getBindParameterIndex(parameterName);
        for (int index : parameterIndexList) {
            this.setNull(index, t, typeName);
        }
    }

    @Override
    public void setRef(int i, Ref x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setRef(int,Ref)");
    }

    public void setRef(String i, Ref x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setRef(String,Ref)");
    }

    @Override
    public void setDate(int i, Date d, Calendar cal) throws SQLException {
        this.checkClosed();
        if (d == null) {
            this.setNull(i, 91);
            return;
        }
        if (this.connection.binaryTransferSend(1082)) {
            byte[] val = new byte[4];
            TimeZone tz = cal != null ? cal.getTimeZone() : null;
            this.connection.getTimestampUtils().toBinDate(tz, val, d);
            this.preparedParameters.setBinaryParameter(i, val, 1082);
            return;
        }
        if (cal == null) {
            cal = this.getDefaultCalendar();
        }
        if (this.connection.unwrap(PgConnection.class).isTimeTextMode()) {
            this.bindString(i, this.connection.getTimestampUtils().toString(cal, d), 25);
            return;
        }
        String compatibilityMode = this.connection.getQueryExecutor().getCompatibilityMode();
        if ("A".equalsIgnoreCase(compatibilityMode) || "ORA".equalsIgnoreCase(compatibilityMode)) {
            this.setTimestamp(i, new Timestamp(d.getTime()), cal);
            return;
        }
        this.bindString(i, this.connection.getTimestampUtils().toString(cal, d), 1082);
    }

    public void setDate(String parameterName, Date d, Calendar cal) throws SQLException {
        List<Integer> parameterIndexList = this.preparedQuery.query.getBindParameterIndex(parameterName);
        for (int index : parameterIndexList) {
            this.setDate(index, d, cal);
        }
    }

    @Override
    public void setTime(int i, Time t, Calendar cal) throws SQLException {
        this.checkClosed();
        if (t == null) {
            this.setNull(i, 92);
            return;
        }
        int oid = 1083;
        if (cal != null) {
            oid = 1266;
        }
        if (this.connection.unwrap(PgConnection.class).isTimeTextMode()) {
            oid = 25;
        }
        if (this.connection.unwrap(PgConnection.class).getDbCompatibility() == DbCompatibility.MSSQL) {
            oid = 9008;
        }
        if (t instanceof PGTime) {
            PGTime pgTime = (PGTime)t;
            if (pgTime.getCalendar() == null) {
                oid = 1083;
            } else {
                cal = pgTime.getCalendar();
                oid = 1266;
            }
        }
        this.bindString(i, this.connection.getTimestampUtils().toString(cal, t), oid);
    }

    public void setTime(String parameterName, Time t, Calendar cal) throws SQLException {
        List<Integer> parameterIndexList = this.preparedQuery.query.getBindParameterIndex(parameterName);
        for (int index : parameterIndexList) {
            this.setTime(index, t, cal);
        }
    }

    @Override
    public void setTimestamp(int i, Timestamp t, Calendar cal) throws SQLException {
        this.checkClosed();
        if (t == null) {
            this.setNull(i, 93);
            return;
        }
        int oid = 1114;
        if (cal != null) {
            oid = 1184;
        }
        if (this.connection.unwrap(PgConnection.class).isTimeTextMode()) {
            oid = 25;
        }
        if (t instanceof PGTimestamp) {
            PGTimestamp pgTimestamp = (PGTimestamp)t;
            if (pgTimestamp.getCalendar() == null) {
                oid = 1114;
            } else {
                oid = 1184;
                cal = pgTimestamp.getCalendar();
            }
        }
        this.bindString(i, this.connection.getTimestampUtils().toString(cal, t), oid);
    }

    public void setTimestamp(String parameterName, Timestamp t, Calendar cal) throws SQLException {
        List<Integer> parameterIndexList = this.preparedQuery.query.getBindParameterIndex(parameterName);
        for (int index : parameterIndexList) {
            this.setTimestamp(index, t, cal);
        }
    }

    private void setDate(int i, LocalDate localDate) throws SQLException {
        int oid = 1082;
        this.bindString(i, this.connection.getTimestampUtils().toString(localDate), oid);
    }

    private void setTime(int i, LocalTime localTime) throws SQLException {
        int oid = 1083;
        this.bindString(i, this.connection.getTimestampUtils().toString(localTime), oid);
    }

    private void setTimestamp(int i, LocalDateTime localDateTime) throws SQLException {
        int oid = 1114;
        this.bindString(i, this.connection.getTimestampUtils().toString(localDateTime), oid);
    }

    private void setTimestamp(int i, OffsetDateTime offsetDateTime) throws SQLException {
        int oid = 1184;
        this.bindString(i, this.connection.getTimestampUtils().toString(offsetDateTime), oid);
    }

    public ParameterMetaData createParameterMetaData(BaseConnection conn, int[] oids) throws SQLException {
        return new PgParameterMetaData(conn, oids);
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        if (x == null) {
            this.preparedParameters.setNull(parameterIndex, 7301);
        } else {
            this.setString(parameterIndex, PgPreparedStatement.castToString(x), 7301);
        }
    }

    public void setRowId(String parameterName, RowId x) throws SQLException {
        List<Integer> parameterIndexList = this.preparedQuery.query.getBindParameterIndex(parameterName);
        for (int index : parameterIndexList) {
            this.setRowId(index, x);
        }
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        this.setString(parameterIndex, value);
    }

    public void setNString(String parameterName, String value) throws SQLException {
        List<Integer> parameterIndexList = this.preparedQuery.query.getBindParameterIndex(parameterName);
        for (int index : parameterIndexList) {
            this.setNString(index, value);
        }
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setNCharacterStream(int, Reader, long)");
    }

    public void setNCharacterStream(String parameterName, Reader value, long length) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setNCharacterStream(String, Reader, long)");
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setNCharacterStream(int, Reader)");
    }

    public void setNCharacterStream(String parameterName, Reader value) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setNCharacterStream(String, Reader)");
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        if (length > Integer.MAX_VALUE) {
            throw Driver.notImplemented(this.getClass(), "setCharacterStream(int, Reader, long)");
        }
        this.setCharacterStream(parameterIndex, value, (int)length);
    }

    public void setCharacterStream(String parameterName, Reader value, long length) throws SQLException {
        if (length > Integer.MAX_VALUE) {
            throw Driver.notImplemented(this.getClass(), "setCharacterStream(String, Reader, long)");
        }
        this.setCharacterStream(parameterName, value, (int)length);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader value) throws SQLException {
        if (this.connection.getPreferQueryMode() == PreferQueryMode.SIMPLE) {
            String s = value != null ? this.readerToString(value, Integer.MAX_VALUE) : null;
            this.setString(parameterIndex, s);
            return;
        }
        ReaderInputStream is = value != null ? new ReaderInputStream(value) : null;
        this.setObject(parameterIndex, (Object)is, -1);
    }

    public void setCharacterStream(String parameterName, Reader value) throws SQLException {
        List<Integer> parameterIndexList = this.preparedQuery.query.getBindParameterIndex(parameterName);
        for (int index : parameterIndexList) {
            this.setCharacterStream(index, value);
        }
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream value, long length) throws SQLException {
        if (length > Integer.MAX_VALUE) {
            throw new PSQLException(GT.tr("Object is too large to send over the protocol.", new Object[0]), PSQLState.NUMERIC_CONSTANT_OUT_OF_RANGE);
        }
        this.preparedParameters.setBytea(parameterIndex, value, (int)length);
    }

    public void setBinaryStream(String parameterName, InputStream value, long length) throws SQLException {
        List<Integer> parameterIndexList = this.preparedQuery.query.getBindParameterIndex(parameterName);
        for (int index : parameterIndexList) {
            this.setBinaryStream(index, value, length);
        }
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream value) throws SQLException {
        this.preparedParameters.setBytea(parameterIndex, value);
    }

    public void setBinaryStream(String parameterName, InputStream value) throws SQLException {
        List<Integer> parameterIndexList = this.preparedQuery.query.getBindParameterIndex(parameterName);
        for (int index : parameterIndexList) {
            this.setBinaryStream(index, value);
        }
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream value, long length) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setAsciiStream(int, InputStream, long)");
    }

    public void setAsciiStream(String parameterName, InputStream value, long length) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setAsciiStream(String, InputStream, long)");
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream value) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setAsciiStream(int, InputStream)");
    }

    public void setAsciiStream(String parameterName, InputStream value) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setAsciiStream(String, InputStream)");
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        if (length < 0L) {
            throw new SQLException("parameter length can not be less than 0");
        }
        StringBuffer strbuf = new StringBuffer();
        char[] buf = new char[1024];
        int num = 0;
        Long count = 0L;
        try {
            while ((num = reader.read(buf)) != -1) {
                if (count + (long)num < length) {
                    strbuf.append(new String(buf, 0, num));
                    count = count + (long)num;
                    continue;
                }
                strbuf.append(new String(buf, 0, (int)(length - count)));
                count = length;
                break;
            }
        }
        catch (IOException e) {
            throw new SQLException(e.getMessage());
        }
        if (length == 0L) {
            this.setString(parameterIndex, "", this.connection.getStringVarcharFlag() ? 1043 : 0);
        }
        if (count != length) {
            throw new SQLException("parameter length can not be bigger than reader's length");
        }
        this.setString(parameterIndex, strbuf.toString(), this.connection.getStringVarcharFlag() ? 1043 : 0);
    }

    public void setClob(String parameterName, Reader reader, long length) throws SQLException {
        List<Integer> parameterIndexList = this.preparedQuery.query.getBindParameterIndex(parameterName);
        for (int index : parameterIndexList) {
            this.setClob(index, reader, length);
        }
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        StringBuffer strbuf = new StringBuffer();
        char[] buf = new char[1024];
        int num = 0;
        try {
            while ((num = reader.read(buf)) != -1) {
                strbuf.append(new String(buf, 0, num));
            }
        }
        catch (IOException e) {
            throw new SQLException(e.getMessage());
        }
        this.setString(parameterIndex, strbuf.toString(), this.connection.getStringVarcharFlag() ? 1043 : 0);
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        if (length < 0L) {
            throw new SQLException("parameter length can not be less than 0");
        }
        StringBuffer strbuf = new StringBuffer();
        char[] buf = new char[1024];
        int num = 0;
        Long count = 0L;
        try {
            while ((num = reader.read(buf)) != -1) {
                if (count + (long)num < length) {
                    strbuf.append(new String(buf, 0, num));
                    count = count + (long)num;
                    continue;
                }
                strbuf.append(new String(buf, 0, (int)(length - count)));
                count = length;
                break;
            }
        }
        catch (IOException e) {
            throw new SQLException(e.getMessage());
        }
        if (length == 0L) {
            this.setString(parameterIndex, "", this.connection.getStringVarcharFlag() ? 1043 : 0);
        }
        if (count != length) {
            throw new SQLException("parameter length can not be bigger than reader's length");
        }
        this.setString(parameterIndex, strbuf.toString(), this.connection.getStringVarcharFlag() ? 1043 : 0);
    }

    public void setNClob(String parameterName, Reader reader, long length) throws SQLException {
        List<Integer> parameterIndexList = this.preparedQuery.query.getBindParameterIndex(parameterName);
        for (int index : parameterIndexList) {
            this.setNClob(index, reader, length);
        }
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        StringBuffer strbuf = new StringBuffer();
        char[] buf = new char[1024];
        int num = 0;
        try {
            while ((num = reader.read(buf)) != -1) {
                strbuf.append(new String(buf, 0, num));
            }
        }
        catch (IOException e) {
            throw new SQLException(e.getMessage());
        }
        this.setString(parameterIndex, strbuf.toString(), this.connection.getStringVarcharFlag() ? 1043 : 0);
    }

    public void setNClob(String parameterName, Reader reader) throws SQLException {
        List<Integer> parameterIndexList = this.preparedQuery.query.getBindParameterIndex(parameterName);
        for (int index : parameterIndexList) {
            this.setNClob(index, reader);
        }
    }

    public void setClob(String parameterName, Reader reader) throws SQLException {
        List<Integer> parameterIndexList = this.preparedQuery.query.getBindParameterIndex(parameterName);
        for (int index : parameterIndexList) {
            this.setClob(index, reader);
        }
    }

    @Override
    public void setBlob(int i, InputStream in) throws SQLException {
        this.checkClosed();
        try {
            this.setBlob(i, in, (long)in.available());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setBlob(String parameterName, InputStream inputStream) throws SQLException {
        List<Integer> parameterIndexList = this.preparedQuery.query.getBindParameterIndex(parameterName);
        for (int index : parameterIndexList) {
            this.setBlob(index, inputStream);
        }
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        this.checkClosed();
        try {
            int i = (int)Math.min((long)inputStream.available(), length);
            byte[] tmp = new byte[i];
            int len = inputStream.read(tmp);
            if (len == -1) {
                LOGGER.trace("Failed to read the inputstream:", new SQLException("Failed to read the inputstream"));
            }
            PGBlob b = new PGBlob();
            b.setBytes(1L, tmp);
            this.setBlob(parameterIndex, (Blob)b);
        }
        catch (IOException e) {
            throw new SQLException(e.getMessage());
        }
    }

    public void setBlob(String parameterName, InputStream inputStream, long length) throws SQLException {
        List<Integer> parameterIndexList = this.preparedQuery.query.getBindParameterIndex(parameterName);
        for (int index : parameterIndexList) {
            this.setBlob(index, inputStream, length);
        }
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        String stringValue;
        this.checkClosed();
        String string = stringValue = xmlObject == null ? null : xmlObject.getString();
        if (stringValue == null) {
            this.setNull(parameterIndex, 2009);
        } else {
            this.setString(parameterIndex, stringValue, 142);
        }
    }

    public void setSQLXML(String parameterName, SQLXML xmlObject) throws SQLException {
        List<Integer> parameterIndexList = this.preparedQuery.query.getBindParameterIndex(parameterName);
        for (int index : parameterIndexList) {
            this.setSQLXML(index, xmlObject);
        }
    }

    private void setUuid(int parameterIndex, UUID uuid) throws SQLException {
        if (this.connection.binaryTransferSend(2950)) {
            byte[] val = new byte[16];
            ByteConverter.int8(val, 0, uuid.getMostSignificantBits());
            ByteConverter.int8(val, 8, uuid.getLeastSignificantBits());
            this.bindBytes(parameterIndex, val, 2950);
        } else {
            this.bindLiteral(parameterIndex, uuid.toString(), 2950);
        }
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setURL(int,URL)");
    }

    public void setURL(String parameterName, URL x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setURL(String,URL)");
    }

    @Override
    public int[] executeBatch() throws SQLException {
        try {
            if (this.batchParameters != null && this.batchParameters.size() >= 1 && this.m_prepareThreshold > 0) {
                this.preparedQuery.increaseExecuteCount(this.m_prepareThreshold);
            }
            int[] nArray = super.executeBatch();
            return nArray;
        }
        finally {
            this.defaultTimeZone = null;
        }
    }

    private Calendar getDefaultCalendar() {
        TimestampUtils timestampUtils = this.connection.getTimestampUtils();
        if (timestampUtils.hasFastDefaultTimeZone()) {
            return timestampUtils.getSharedCalendar(null);
        }
        Calendar sharedCalendar = timestampUtils.getSharedCalendar(this.defaultTimeZone);
        if (this.defaultTimeZone == null) {
            this.defaultTimeZone = sharedCalendar.getTimeZone();
        }
        return sharedCalendar;
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        this.checkClosed();
        int flags = 49;
        PgStatement.StatementResultHandler handler = new PgStatement.StatementResultHandler(this);
        this.connection.getQueryExecutor().execute(this.preparedQuery.query, this.preparedParameters, handler, 0, 0, flags);
        int[] oids = this.preparedParameters.getTypeOIDs();
        if (oids != null) {
            return this.createParameterMetaData(this.connection, oids);
        }
        return null;
    }

    @Override
    protected void transformQueriesAndParameters() throws SQLException {
        if (this.batchParameters.size() <= 1 || !(this.preparedQuery.query instanceof BatchedQuery)) {
            return;
        }
        BatchedQuery originalQuery = (BatchedQuery)this.preparedQuery.query;
        int bindCount = originalQuery.getBindCount();
        int highestBlockCount = 128;
        int maxValueBlocks = bindCount == 0 ? 1024 : Integer.highestOneBit(Math.min(Math.max(1, this.maximumNumberOfParameters() / bindCount), 128));
        int unprocessedBatchCount = this.batchParameters.size();
        int fullValueBlocksCount = unprocessedBatchCount / maxValueBlocks;
        int partialValueBlocksCount = Integer.bitCount(unprocessedBatchCount % maxValueBlocks);
        int count = fullValueBlocksCount + partialValueBlocksCount;
        ArrayList<BatchedQuery> newBatchStatements = new ArrayList<BatchedQuery>(count);
        ArrayList<ParameterList> newBatchParameters = new ArrayList<ParameterList>(count);
        int offset = 0;
        for (int i = 0; i < count; ++i) {
            int valueBlock = unprocessedBatchCount >= maxValueBlocks ? maxValueBlocks : Integer.highestOneBit(unprocessedBatchCount);
            BatchedQuery bq = originalQuery.deriveForMultiBatch(valueBlock);
            ParameterList newPl = bq.createParameterList();
            for (int j = 0; j < valueBlock; ++j) {
                ParameterList pl = (ParameterList)this.batchParameters.get(offset++);
                newPl.appendAll(pl);
            }
            newBatchStatements.add(bq);
            newBatchParameters.add(newPl);
            unprocessedBatchCount -= valueBlock;
        }
        this.batchStatements = newBatchStatements;
        this.batchParameters = newBatchParameters;
    }

    static {
        sqlTypeToOid.put(2009, 142);
        sqlTypeToOid.put(4, 23);
        sqlTypeToOid.put(-6, 5545);
        sqlTypeToOid.put(5, 21);
        sqlTypeToOid.put(-5, 20);
        sqlTypeToOid.put(7, 700);
        sqlTypeToOid.put(8, 701);
        sqlTypeToOid.put(6, 701);
        sqlTypeToOid.put(3, 1700);
        sqlTypeToOid.put(2, 1700);
        sqlTypeToOid.put(1, 1042);
        sqlTypeToOid.put(91, 1082);
        sqlTypeToOid.put(92, 0);
        sqlTypeToOid.put(93, 0);
        sqlTypeToOid.put(2013, 0);
        sqlTypeToOid.put(2014, 0);
        sqlTypeToOid.put(16, 16);
        sqlTypeToOid.put(-7, 16);
        sqlTypeToOid.put(-2, 17);
        sqlTypeToOid.put(-3, 17);
        sqlTypeToOid.put(-4, 17);
        sqlTypeToOid.put(2004, 88);
        sqlTypeToOid.put(2005, 90);
        sqlTypeToOid.put(2003, 0);
        sqlTypeToOid.put(2001, 0);
        sqlTypeToOid.put(2002, 0);
        sqlTypeToOid.put(0, 0);
        sqlTypeToOid.put(1111, 0);
        sqlTypeToOid.put(-8, 7301);
        sqlTypeToOid.put(-9, 3969);
    }
}

