/*
 * Decompiled with CFR 0.152.
 */
package cn.com.vastbase.jdbc;

import cn.com.vastbase.util.StringCaseUtil;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.ResultSet;

public class ResultSetUpperCaseProxy {
    public static ResultSet create(ResultSet originalResultSet) {
        return (ResultSet)Proxy.newProxyInstance(originalResultSet.getClass().getClassLoader(), new Class[]{ResultSet.class}, (InvocationHandler)new UpperCaseHandler(originalResultSet));
    }

    private static class UpperCaseHandler
    implements InvocationHandler {
        private final ResultSet originalResultSet;

        public UpperCaseHandler(ResultSet originalResultSet) {
            this.originalResultSet = originalResultSet;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if ("getString".equals(method.getName()) && args != null && args.length == 1) {
                String result = (String)method.invoke((Object)this.originalResultSet, args);
                return result != null && !StringCaseUtil.isMixedCase(result) ? result.toUpperCase() : null;
            }
            return method.invoke((Object)this.originalResultSet, args);
        }
    }
}

