/*
 * Decompiled with CFR 0.152.
 */
package cn.com.vastbase.pgvector;

import cn.com.vastbase.PGConnection;
import cn.com.vastbase.util.ByteConverter;
import cn.com.vastbase.util.PGBinaryObject;
import cn.com.vastbase.util.PGobject;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;

public class PGbit
extends PGobject
implements PGBinaryObject,
Serializable,
Cloneable {
    private int length;
    private byte[] data;

    public PGbit() {
        this.type = "bit";
    }

    public PGbit(boolean[] v) {
        this();
        this.length = v.length;
        this.data = new byte[(this.length + 7) / 8];
        for (int i = 0; i < this.length; ++i) {
            int n = i / 8;
            this.data[n] = (byte)(this.data[n] | (v[i] ? 1 : 0) << 7 - i % 8);
        }
    }

    public PGbit(byte[] v) {
        this();
        this.length = PGbit.safeMultiply(v.length, 8);
        this.data = v;
    }

    public static int safeMultiply(int a, int b) {
        long result = (long)a * (long)b;
        if (result > Integer.MAX_VALUE || result < Integer.MIN_VALUE) {
            throw new ArithmeticException("Integer overflow");
        }
        return (int)result;
    }

    public PGbit(String s) throws SQLException {
        this();
        this.setValue(s);
    }

    @Override
    public void setValue(String s) throws SQLException {
        if (s == null) {
            this.data = null;
        } else {
            this.length = s.length();
            this.data = new byte[(this.length + 7) / 8];
            for (int i = 0; i < this.length; ++i) {
                int n = i / 8;
                this.data[n] = (byte)(this.data[n] | (s.charAt(i) != '0' ? 1 : 0) << 7 - i % 8);
            }
        }
    }

    @Override
    public String getValue() {
        if (this.data == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(this.length);
        for (int i = 0; i < this.length; ++i) {
            sb.append((this.data[i / 8] >> 7 - i % 8 & 1) == 1 ? (char)'1' : '0');
        }
        return sb.toString();
    }

    @Override
    public int lengthInBytes() {
        return this.data == null ? 0 : 4 + this.data.length;
    }

    @Override
    public void setByteValue(byte[] value, int offset) throws SQLException {
        this.length = ByteConverter.int4(value, offset);
        this.data = new byte[(this.length + 7) / 8];
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = value[offset + 4 + i];
        }
    }

    @Override
    public void toBytes(byte[] bytes, int offset) {
        if (this.data == null) {
            return;
        }
        ByteConverter.int4(bytes, offset, this.length);
        for (int i = 0; i < this.data.length; ++i) {
            bytes[offset + 4 + i] = this.data[i];
        }
    }

    public int length() {
        return this.length;
    }

    public byte[] toByteArray() {
        return this.data;
    }

    public boolean[] toArray() {
        boolean[] bits = new boolean[this.length];
        for (int i = 0; i < this.length; ++i) {
            bits[i] = (this.data[i / 8] >> 7 - i % 8 & 1) == 1;
        }
        return bits;
    }

    public static void registerType(Connection conn) throws SQLException {
        conn.unwrap(PGConnection.class).addDataType("bit", PGbit.class);
    }
}

