/*
 * Decompiled with CFR 0.152.
 */
package cn.com.vastbase.readwritesplitting;

import cn.com.vastbase.hostchooser.HostChooser;
import cn.com.vastbase.hostchooser.HostChooserFactory;
import cn.com.vastbase.hostchooser.HostRequirement;
import cn.com.vastbase.util.HostSpec;
import java.util.Properties;

public class ReadWriteSplittingHostSpec {
    private final HostSpec writeHostSpec;
    private final HostSpec[] readHostSpecs;
    private final HostRequirement targetServerType;
    private final HostChooser readChooser;

    public ReadWriteSplittingHostSpec(HostSpec writeHostSpec, HostSpec[] hostSpecs, HostRequirement targetServerType, Properties props) {
        this.writeHostSpec = writeHostSpec;
        this.readHostSpecs = this.createReadHostSpecs(hostSpecs, writeHostSpec);
        this.targetServerType = targetServerType;
        this.readChooser = HostChooserFactory.createHostChooser(this.readHostSpecs, targetServerType, props);
    }

    private HostSpec[] createReadHostSpecs(HostSpec[] hostSpecs, HostSpec writeHostSpec) {
        int index = 0;
        HostSpec[] result = new HostSpec[hostSpecs.length - 1];
        for (HostSpec each : hostSpecs) {
            if (each.equals(writeHostSpec)) continue;
            result[index++] = each;
        }
        return result;
    }

    public HostSpec getWriteHostSpec() {
        return this.writeHostSpec;
    }

    public HostSpec[] getReadHostSpecs() {
        return this.readHostSpecs;
    }

    public HostRequirement getTargetServerType() {
        return this.targetServerType;
    }

    public HostSpec readLoadBalance() {
        return this.readChooser.iterator().next().hostSpec;
    }
}

