/*
 * Decompiled with CFR 0.152.
 */
package cn.com.vastbase.struct;

import cn.com.vastbase.struct.FieldMeta;
import cn.com.vastbase.struct.PgCompositeMetaData;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class StructDescriptor {
    private final PgCompositeMetaData metaData;

    private StructDescriptor(PgCompositeMetaData metaData) {
        this.metaData = metaData;
    }

    public static StructDescriptor createDescriptor(String fullTypeName, Connection conn) throws SQLException {
        List<FieldMeta> fields = StructDescriptor.loadFieldsFromPg(fullTypeName, conn);
        return new StructDescriptor(new PgCompositeMetaData(fields));
    }

    public ResultSetMetaData getMetaData() {
        return this.metaData;
    }

    private static List<FieldMeta> loadFieldsFromPg(String fullTypeName, Connection conn) throws SQLException {
        String schema = null;
        String type = fullTypeName;
        if (fullTypeName.contains(".")) {
            String[] parts = fullTypeName.split("\\.");
            schema = parts[0];
            type = parts[1];
        }
        String sql = "SELECT a.attnum, a.attname,        t.typname AS typename,        t.typlen, a.atttypmod, a.attnotnull,        format_type(a.atttypid, a.atttypmod) AS formatted_type FROM pg_type ct JOIN pg_namespace n ON ct.typnamespace = n.oid JOIN pg_class c ON c.oid = ct.typrelid JOIN pg_attribute a ON a.attrelid = c.oid JOIN pg_type t ON t.oid = a.atttypid WHERE ct.typname = ? " + (schema != null ? "AND n.nspname = ? " : "") + "AND a.attnum > 0 AND NOT a.attisdropped ORDER BY a.attnum";
        ArrayList<FieldMeta> list = new ArrayList<FieldMeta>();
        try (PreparedStatement ps = conn.prepareStatement(sql);){
            ps.setString(1, type);
            if (schema != null) {
                ps.setString(2, schema);
            }
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    FieldMeta meta = new FieldMeta();
                    meta.index = rs.getInt("attnum");
                    meta.name = rs.getString("attname");
                    meta.typeName = rs.getString("typename");
                    meta.charLength = 0;
                    meta.precision = 0;
                    meta.scale = 0;
                    int atttypmod = rs.getInt("atttypmod");
                    switch (meta.typeName) {
                        case "int1": {
                            meta.jdbcTypeCode = -6;
                            break;
                        }
                        case "int2": {
                            meta.jdbcTypeCode = 5;
                            break;
                        }
                        case "int4": {
                            meta.jdbcTypeCode = 4;
                            break;
                        }
                        case "int8": {
                            meta.jdbcTypeCode = -5;
                            break;
                        }
                        case "float4": {
                            meta.jdbcTypeCode = 7;
                            break;
                        }
                        case "float8": {
                            meta.jdbcTypeCode = 8;
                            break;
                        }
                        case "numeric": 
                        case "number": {
                            if (atttypmod > 0) {
                                int mod = atttypmod - 4;
                                meta.precision = mod >> 16 & 0xFFFF;
                                meta.scale = mod & 0xFFFF;
                            }
                            meta.jdbcTypeCode = 2;
                            break;
                        }
                        case "money": {
                            meta.jdbcTypeCode = 3;
                            break;
                        }
                        case "char": 
                        case "bpchar": {
                            meta.charLength = atttypmod > 0 ? atttypmod - 4 : 0;
                            meta.jdbcTypeCode = 1;
                            break;
                        }
                        case "varchar": {
                            meta.charLength = atttypmod > 0 ? atttypmod - 4 : 0;
                            meta.jdbcTypeCode = 12;
                            break;
                        }
                        case "nchar": {
                            meta.charLength = atttypmod > 0 ? atttypmod - 4 : 0;
                            meta.jdbcTypeCode = -15;
                            break;
                        }
                        case "nvarchar": 
                        case "nvarchar2": {
                            meta.charLength = atttypmod > 0 ? atttypmod - 4 : 0;
                            meta.jdbcTypeCode = -9;
                            break;
                        }
                        case "text": {
                            meta.jdbcTypeCode = -1;
                            break;
                        }
                        case "bool": {
                            meta.jdbcTypeCode = 16;
                            break;
                        }
                        case "date": {
                            meta.jdbcTypeCode = 91;
                            break;
                        }
                        case "timestamp": {
                            meta.jdbcTypeCode = 93;
                            break;
                        }
                        case "timestamptz": {
                            meta.jdbcTypeCode = 2014;
                            break;
                        }
                        case "time": {
                            meta.jdbcTypeCode = 92;
                            break;
                        }
                        case "timetz": {
                            meta.jdbcTypeCode = 2013;
                            break;
                        }
                        case "json": 
                        case "jsonb": {
                            meta.jdbcTypeCode = -1;
                            break;
                        }
                        case "bytea": {
                            meta.jdbcTypeCode = -2;
                            break;
                        }
                        case "uuid": {
                            meta.jdbcTypeCode = 1111;
                            break;
                        }
                        case "blob": {
                            meta.jdbcTypeCode = 2004;
                            break;
                        }
                        case "clob": {
                            meta.jdbcTypeCode = 2005;
                            break;
                        }
                        case "nclob": {
                            meta.jdbcTypeCode = 2011;
                            break;
                        }
                        case "raw": {
                            meta.jdbcTypeCode = -3;
                            break;
                        }
                        default: {
                            meta.jdbcTypeCode = 1111;
                        }
                    }
                    meta.notNull = rs.getBoolean("attnotnull");
                    list.add(meta);
                }
            }
        }
        return list;
    }
}

