/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.job.core.thread;

import com.xxl.job.core.log.XxlJobFileAppender;
import com.xxl.job.core.util.FileUtil;
import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobLogFileCleanThread {
    private static Logger logger = LoggerFactory.getLogger(JobLogFileCleanThread.class);
    private static JobLogFileCleanThread instance = new JobLogFileCleanThread();
    private Thread localThread;
    private volatile boolean toStop = false;

    public static JobLogFileCleanThread getInstance() {
        return instance;
    }

    public void start(final long logRetentionDays) {
        if (logRetentionDays < 3L) {
            return;
        }
        this.localThread = new Thread(new Runnable(){

            @Override
            public void run() {
                while (!JobLogFileCleanThread.this.toStop) {
                    block8: {
                        try {
                            File[] childDirs = new File(XxlJobFileAppender.getLogPath()).listFiles();
                            if (childDirs == null || childDirs.length <= 0) break block8;
                            Calendar todayCal = Calendar.getInstance();
                            todayCal.set(11, 0);
                            todayCal.set(12, 0);
                            todayCal.set(13, 0);
                            todayCal.set(14, 0);
                            Date todayDate = todayCal.getTime();
                            for (File childFile : childDirs) {
                                if (!childFile.isDirectory() || childFile.getName().indexOf("-") == -1) continue;
                                Date logFileCreateDate = null;
                                try {
                                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
                                    logFileCreateDate = simpleDateFormat.parse(childFile.getName());
                                }
                                catch (ParseException e) {
                                    logger.error(e.getMessage(), (Throwable)e);
                                }
                                if (logFileCreateDate == null || todayDate.getTime() - logFileCreateDate.getTime() < logRetentionDays * 86400000L) continue;
                                FileUtil.deleteRecursively(childFile);
                            }
                        }
                        catch (Throwable e) {
                            if (JobLogFileCleanThread.this.toStop) break block8;
                            logger.error(e.getMessage(), e);
                        }
                    }
                    try {
                        TimeUnit.DAYS.sleep(1L);
                    }
                    catch (Throwable e) {
                        if (JobLogFileCleanThread.this.toStop) continue;
                        logger.error(e.getMessage(), e);
                    }
                }
                logger.info(">>>>>>>>>>> xxl-job, executor JobLogFileCleanThread thread destroy.");
            }
        });
        this.localThread.setDaemon(true);
        this.localThread.setName("xxl-job, executor JobLogFileCleanThread");
        this.localThread.start();
    }

    public void toStop() {
        this.toStop = true;
        if (this.localThread == null) {
            return;
        }
        this.localThread.interrupt();
        try {
            this.localThread.join();
        }
        catch (InterruptedException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }
}

