/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.process.distribution;

import de.flapdoodle.embed.process.distribution.BitSize;
import de.flapdoodle.embed.process.distribution.Distribution;
import de.flapdoodle.embed.process.distribution.Platform;
import de.flapdoodle.embed.process.distribution.Version;
import java.util.ArrayList;
import java.util.Objects;
import org.immutables.value.Generated;

@Generated(from="Distribution", generator="Immutables")
public final class ImmutableDistribution
extends Distribution {
    private final Version version;
    private final Platform platform;
    private final BitSize bitsize;

    private ImmutableDistribution(Version version, Platform platform, BitSize bitsize) {
        this.version = Objects.requireNonNull(version, "version");
        this.platform = Objects.requireNonNull(platform, "platform");
        this.bitsize = Objects.requireNonNull(bitsize, "bitsize");
    }

    private ImmutableDistribution(ImmutableDistribution original, Version version, Platform platform, BitSize bitsize) {
        this.version = version;
        this.platform = platform;
        this.bitsize = bitsize;
    }

    @Override
    public Version version() {
        return this.version;
    }

    @Override
    public Platform platform() {
        return this.platform;
    }

    @Override
    public BitSize bitsize() {
        return this.bitsize;
    }

    public final ImmutableDistribution withVersion(Version value) {
        if (this.version == value) {
            return this;
        }
        Version newValue = Objects.requireNonNull(value, "version");
        return new ImmutableDistribution(this, newValue, this.platform, this.bitsize);
    }

    public final ImmutableDistribution withPlatform(Platform value) {
        if (this.platform == value) {
            return this;
        }
        Platform newValue = Objects.requireNonNull(value, "platform");
        if (this.platform.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableDistribution(this, this.version, newValue, this.bitsize);
    }

    public final ImmutableDistribution withBitsize(BitSize value) {
        if (this.bitsize == value) {
            return this;
        }
        BitSize newValue = Objects.requireNonNull(value, "bitsize");
        if (this.bitsize.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableDistribution(this, this.version, this.platform, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDistribution && this.equalTo((ImmutableDistribution)another);
    }

    private boolean equalTo(ImmutableDistribution another) {
        return this.version.equals(another.version) && this.platform.equals((Object)another.platform) && this.bitsize.equals((Object)another.bitsize);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.version.hashCode();
        h += (h << 5) + this.platform.hashCode();
        h += (h << 5) + this.bitsize.hashCode();
        return h;
    }

    public static ImmutableDistribution of(Version version, Platform platform, BitSize bitsize) {
        return new ImmutableDistribution(version, platform, bitsize);
    }

    public static ImmutableDistribution copyOf(Distribution instance) {
        if (instance instanceof ImmutableDistribution) {
            return (ImmutableDistribution)instance;
        }
        return ImmutableDistribution.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Distribution", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_VERSION = 1L;
        private static final long INIT_BIT_PLATFORM = 2L;
        private static final long INIT_BIT_BITSIZE = 4L;
        private long initBits = 7L;
        private Version version;
        private Platform platform;
        private BitSize bitsize;

        private Builder() {
        }

        public final Builder from(Distribution instance) {
            Objects.requireNonNull(instance, "instance");
            this.version(instance.version());
            this.platform(instance.platform());
            this.bitsize(instance.bitsize());
            return this;
        }

        public final Builder version(Version version) {
            this.version = Objects.requireNonNull(version, "version");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder platform(Platform platform) {
            this.platform = Objects.requireNonNull(platform, "platform");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder bitsize(BitSize bitsize) {
            this.bitsize = Objects.requireNonNull(bitsize, "bitsize");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableDistribution build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableDistribution(null, this.version, this.platform, this.bitsize);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("version");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("platform");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("bitsize");
            }
            return "Cannot build Distribution, some of required attributes are not set " + attributes;
        }
    }
}

