/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.decorators;

import io.github.resilience4j.bulkhead.Bulkhead;
import io.github.resilience4j.bulkhead.BulkheadFullException;
import io.github.resilience4j.bulkhead.ThreadPoolBulkhead;
import io.github.resilience4j.cache.Cache;
import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.core.CallableUtils;
import io.github.resilience4j.core.CheckedFunctionUtils;
import io.github.resilience4j.core.CompletionStageUtils;
import io.github.resilience4j.core.SupplierUtils;
import io.github.resilience4j.core.functions.CheckedBiFunction;
import io.github.resilience4j.core.functions.CheckedFunction;
import io.github.resilience4j.core.functions.CheckedRunnable;
import io.github.resilience4j.core.functions.CheckedSupplier;
import io.github.resilience4j.micrometer.Timer;
import io.github.resilience4j.ratelimiter.RateLimiter;
import io.github.resilience4j.retry.Retry;
import io.github.resilience4j.timelimiter.TimeLimiter;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;

public interface Decorators {
    public static <T> DecorateSupplier<T> ofSupplier(Supplier<T> supplier) {
        return new DecorateSupplier<T>(supplier);
    }

    public static <T, R> DecorateFunction<T, R> ofFunction(Function<T, R> function) {
        return new DecorateFunction<T, R>(function);
    }

    public static DecorateRunnable ofRunnable(Runnable runnable) {
        return new DecorateRunnable(runnable);
    }

    public static <T> DecorateCallable<T> ofCallable(Callable<T> callable) {
        return new DecorateCallable<T>(callable);
    }

    public static <T> DecorateCheckedSupplier<T> ofCheckedSupplier(CheckedSupplier<T> supplier) {
        return new DecorateCheckedSupplier<T>(supplier);
    }

    public static <T, R> DecorateCheckedFunction<T, R> ofCheckedFunction(CheckedFunction<T, R> function) {
        return new DecorateCheckedFunction<T, R>(function);
    }

    public static DecorateCheckedRunnable ofCheckedRunnable(CheckedRunnable supplier) {
        return new DecorateCheckedRunnable(supplier);
    }

    public static <T> DecorateCompletionStage<T> ofCompletionStage(Supplier<CompletionStage<T>> stageSupplier) {
        return new DecorateCompletionStage<T>(stageSupplier);
    }

    public static <T> DecorateConsumer<T> ofConsumer(Consumer<T> consumer) {
        return new DecorateConsumer<T>(consumer);
    }

    public static class DecorateSupplier<T> {
        private Supplier<T> supplier;

        private DecorateSupplier(Supplier<T> supplier) {
            this.supplier = supplier;
        }

        public DecorateSupplier<T> withTimer(Timer timer) {
            this.supplier = Timer.decorateSupplier((Timer)timer, this.supplier);
            return this;
        }

        public DecorateSupplier<T> withCircuitBreaker(CircuitBreaker circuitBreaker) {
            this.supplier = CircuitBreaker.decorateSupplier((CircuitBreaker)circuitBreaker, this.supplier);
            return this;
        }

        public DecorateSupplier<T> withRetry(Retry retryContext) {
            this.supplier = Retry.decorateSupplier((Retry)retryContext, this.supplier);
            return this;
        }

        public <K> DecorateFunction<K, T> withCache(Cache<K, T> cache) {
            return Decorators.ofFunction(Cache.decorateSupplier(cache, this.supplier));
        }

        public DecorateSupplier<T> withRateLimiter(RateLimiter rateLimiter) {
            return this.withRateLimiter(rateLimiter, 1);
        }

        public DecorateSupplier<T> withRateLimiter(RateLimiter rateLimiter, int permits) {
            this.supplier = RateLimiter.decorateSupplier((RateLimiter)rateLimiter, (int)permits, this.supplier);
            return this;
        }

        public DecorateSupplier<T> withBulkhead(Bulkhead bulkhead) {
            this.supplier = Bulkhead.decorateSupplier((Bulkhead)bulkhead, this.supplier);
            return this;
        }

        public DecorateSupplier<T> withFallback(Function<Throwable, T> exceptionHandler) {
            this.supplier = SupplierUtils.recover(this.supplier, exceptionHandler);
            return this;
        }

        public DecorateSupplier<T> withFallback(Predicate<T> resultPredicate, UnaryOperator<T> resultHandler) {
            this.supplier = SupplierUtils.recover(this.supplier, resultPredicate, resultHandler);
            return this;
        }

        public DecorateSupplier<T> withFallback(BiFunction<T, Throwable, T> handler) {
            this.supplier = SupplierUtils.andThen(this.supplier, handler);
            return this;
        }

        public DecorateSupplier<T> withFallback(List<Class<? extends Throwable>> exceptionTypes, Function<Throwable, T> exceptionHandler) {
            this.supplier = SupplierUtils.recover(this.supplier, exceptionTypes, exceptionHandler);
            return this;
        }

        public DecorateCompletionStage<T> withThreadPoolBulkhead(ThreadPoolBulkhead threadPoolBulkhead) {
            return Decorators.ofCompletionStage(this.getCompletionStageSupplier(threadPoolBulkhead));
        }

        private Supplier<CompletionStage<T>> getCompletionStageSupplier(ThreadPoolBulkhead threadPoolBulkhead) {
            return () -> {
                try {
                    return threadPoolBulkhead.executeSupplier(this.supplier);
                }
                catch (BulkheadFullException ex) {
                    CompletableFuture future = new CompletableFuture();
                    future.completeExceptionally(ex);
                    return future;
                }
            };
        }

        public Supplier<T> decorate() {
            return this.supplier;
        }

        public T get() {
            return this.supplier.get();
        }
    }

    public static class DecorateFunction<T, R> {
        private Function<T, R> function;

        private DecorateFunction(Function<T, R> function) {
            this.function = function;
        }

        public DecorateFunction<T, R> withTimer(Timer timer) {
            this.function = Timer.decorateFunction((Timer)timer, this.function);
            return this;
        }

        public DecorateFunction<T, R> withCircuitBreaker(CircuitBreaker circuitBreaker) {
            this.function = CircuitBreaker.decorateFunction((CircuitBreaker)circuitBreaker, this.function);
            return this;
        }

        public DecorateFunction<T, R> withRetry(Retry retryContext) {
            this.function = Retry.decorateFunction((Retry)retryContext, this.function);
            return this;
        }

        public DecorateFunction<T, R> withRateLimiter(RateLimiter rateLimiter) {
            return this.withRateLimiter(rateLimiter, 1);
        }

        public DecorateFunction<T, R> withRateLimiter(RateLimiter rateLimiter, int permits) {
            this.function = RateLimiter.decorateFunction((RateLimiter)rateLimiter, (int)permits, this.function);
            return this;
        }

        public DecorateFunction<T, R> withRateLimiter(RateLimiter rateLimiter, Function<T, Integer> permitsCalculator) {
            this.function = RateLimiter.decorateFunction((RateLimiter)rateLimiter, permitsCalculator, this.function);
            return this;
        }

        public DecorateFunction<T, R> withBulkhead(Bulkhead bulkhead) {
            this.function = Bulkhead.decorateFunction((Bulkhead)bulkhead, this.function);
            return this;
        }

        public Function<T, R> decorate() {
            return this.function;
        }

        public R apply(T t) {
            return this.function.apply(t);
        }
    }

    public static class DecorateRunnable {
        private Runnable runnable;

        private DecorateRunnable(Runnable runnable) {
            this.runnable = runnable;
        }

        public DecorateRunnable withTimer(Timer timer) {
            this.runnable = Timer.decorateRunnable((Timer)timer, (Runnable)this.runnable);
            return this;
        }

        public DecorateRunnable withCircuitBreaker(CircuitBreaker circuitBreaker) {
            this.runnable = CircuitBreaker.decorateRunnable((CircuitBreaker)circuitBreaker, (Runnable)this.runnable);
            return this;
        }

        public DecorateRunnable withRetry(Retry retryContext) {
            this.runnable = Retry.decorateRunnable((Retry)retryContext, (Runnable)this.runnable);
            return this;
        }

        public DecorateRunnable withRateLimiter(RateLimiter rateLimiter) {
            return this.withRateLimiter(rateLimiter, 1);
        }

        public DecorateRunnable withRateLimiter(RateLimiter rateLimiter, int permits) {
            this.runnable = RateLimiter.decorateRunnable((RateLimiter)rateLimiter, (int)permits, (Runnable)this.runnable);
            return this;
        }

        public DecorateRunnable withBulkhead(Bulkhead bulkhead) {
            this.runnable = Bulkhead.decorateRunnable((Bulkhead)bulkhead, (Runnable)this.runnable);
            return this;
        }

        public DecorateCompletionStage<Void> withThreadPoolBulkhead(ThreadPoolBulkhead threadPoolBulkhead) {
            return Decorators.ofCompletionStage(this.getCompletionStageSupplier(threadPoolBulkhead));
        }

        private Supplier<CompletionStage<Void>> getCompletionStageSupplier(ThreadPoolBulkhead threadPoolBulkhead) {
            return () -> {
                try {
                    return threadPoolBulkhead.executeRunnable(this.runnable);
                }
                catch (BulkheadFullException ex) {
                    CompletableFuture future = new CompletableFuture();
                    future.completeExceptionally(ex);
                    return future;
                }
            };
        }

        public Runnable decorate() {
            return this.runnable;
        }

        public void run() {
            this.runnable.run();
        }
    }

    public static class DecorateCallable<T> {
        private Callable<T> callable;

        private DecorateCallable(Callable<T> callable) {
            this.callable = callable;
        }

        public DecorateCallable<T> withTimer(Timer timer) {
            this.callable = Timer.decorateCallable((Timer)timer, this.callable);
            return this;
        }

        public DecorateCallable<T> withCircuitBreaker(CircuitBreaker circuitBreaker) {
            this.callable = CircuitBreaker.decorateCallable((CircuitBreaker)circuitBreaker, this.callable);
            return this;
        }

        public DecorateCallable<T> withRetry(Retry retryContext) {
            this.callable = Retry.decorateCallable((Retry)retryContext, this.callable);
            return this;
        }

        public DecorateCallable<T> withRateLimiter(RateLimiter rateLimiter) {
            return this.withRateLimiter(rateLimiter, 1);
        }

        public DecorateCallable<T> withRateLimiter(RateLimiter rateLimiter, int permits) {
            this.callable = RateLimiter.decorateCallable((RateLimiter)rateLimiter, (int)permits, this.callable);
            return this;
        }

        public DecorateCallable<T> withBulkhead(Bulkhead bulkhead) {
            this.callable = Bulkhead.decorateCallable((Bulkhead)bulkhead, this.callable);
            return this;
        }

        public DecorateCallable<T> withFallback(BiFunction<T, Throwable, T> handler) {
            this.callable = CallableUtils.andThen(this.callable, handler);
            return this;
        }

        public DecorateCallable<T> withFallback(Predicate<T> resultPredicate, UnaryOperator<T> resultHandler) {
            this.callable = CallableUtils.recover(this.callable, resultPredicate, resultHandler);
            return this;
        }

        public DecorateCallable<T> withFallback(List<Class<? extends Throwable>> exceptionTypes, Function<Throwable, T> exceptionHandler) {
            this.callable = CallableUtils.recover(this.callable, exceptionTypes, exceptionHandler);
            return this;
        }

        public DecorateCallable<T> withFallback(Function<Throwable, T> exceptionHandler) {
            this.callable = CallableUtils.recover(this.callable, exceptionHandler);
            return this;
        }

        public <X extends Throwable> DecorateCallable<T> withFallback(Class<X> exceptionType, Function<Throwable, T> exceptionHandler) {
            this.callable = CallableUtils.recover(this.callable, exceptionType, exceptionHandler);
            return this;
        }

        public DecorateCompletionStage<T> withThreadPoolBulkhead(ThreadPoolBulkhead threadPoolBulkhead) {
            return Decorators.ofCompletionStage(this.getCompletionStageSupplier(threadPoolBulkhead));
        }

        private Supplier<CompletionStage<T>> getCompletionStageSupplier(ThreadPoolBulkhead threadPoolBulkhead) {
            return () -> {
                try {
                    return threadPoolBulkhead.executeCallable(this.callable);
                }
                catch (BulkheadFullException ex) {
                    CompletableFuture future = new CompletableFuture();
                    future.completeExceptionally(ex);
                    return future;
                }
            };
        }

        public Callable<T> decorate() {
            return this.callable;
        }

        public T call() throws Exception {
            return this.callable.call();
        }
    }

    public static class DecorateCheckedSupplier<T> {
        private CheckedSupplier<T> supplier;

        private DecorateCheckedSupplier(CheckedSupplier<T> supplier) {
            this.supplier = supplier;
        }

        public DecorateCheckedSupplier<T> withTimer(Timer timer) {
            this.supplier = Timer.decorateCheckedSupplier((Timer)timer, this.supplier);
            return this;
        }

        public DecorateCheckedSupplier<T> withCircuitBreaker(CircuitBreaker circuitBreaker) {
            this.supplier = CircuitBreaker.decorateCheckedSupplier((CircuitBreaker)circuitBreaker, this.supplier);
            return this;
        }

        public DecorateCheckedSupplier<T> withRetry(Retry retryContext) {
            this.supplier = Retry.decorateCheckedSupplier((Retry)retryContext, this.supplier);
            return this;
        }

        public DecorateCheckedSupplier<T> withRateLimiter(RateLimiter rateLimiter) {
            return this.withRateLimiter(rateLimiter, 1);
        }

        public DecorateCheckedSupplier<T> withRateLimiter(RateLimiter rateLimiter, int permits) {
            this.supplier = RateLimiter.decorateCheckedSupplier((RateLimiter)rateLimiter, (int)permits, this.supplier);
            return this;
        }

        public <K> DecorateCheckedFunction<K, T> withCache(Cache<K, T> cache) {
            return Decorators.ofCheckedFunction(Cache.decorateCheckedSupplier(cache, this.supplier));
        }

        public DecorateCheckedSupplier<T> withBulkhead(Bulkhead bulkhead) {
            this.supplier = Bulkhead.decorateCheckedSupplier((Bulkhead)bulkhead, this.supplier);
            return this;
        }

        public DecorateCheckedSupplier<T> withFallback(CheckedBiFunction<T, Throwable, T> handler) {
            this.supplier = CheckedFunctionUtils.andThen(this.supplier, handler);
            return this;
        }

        public DecorateCheckedSupplier<T> withFallback(Predicate<T> resultPredicate, CheckedFunction<T, T> resultHandler) {
            this.supplier = CheckedFunctionUtils.recover(this.supplier, resultPredicate, resultHandler);
            return this;
        }

        public DecorateCheckedSupplier<T> withFallback(List<Class<? extends Throwable>> exceptionTypes, CheckedFunction<Throwable, T> exceptionHandler) {
            this.supplier = CheckedFunctionUtils.recover(this.supplier, exceptionTypes, exceptionHandler);
            return this;
        }

        public DecorateCheckedSupplier<T> withFallback(CheckedFunction<Throwable, T> exceptionHandler) {
            this.supplier = CheckedFunctionUtils.recover(this.supplier, exceptionHandler);
            return this;
        }

        public <X extends Throwable> DecorateCheckedSupplier<T> withFallback(Class<X> exceptionType, CheckedFunction<Throwable, T> exceptionHandler) {
            this.supplier = CheckedFunctionUtils.recover(this.supplier, exceptionType, exceptionHandler);
            return this;
        }

        public CheckedSupplier<T> decorate() {
            return this.supplier;
        }

        public T get() throws Throwable {
            return (T)this.supplier.get();
        }
    }

    public static class DecorateCheckedFunction<T, R> {
        private CheckedFunction<T, R> function;

        private DecorateCheckedFunction(CheckedFunction<T, R> function) {
            this.function = function;
        }

        public DecorateCheckedFunction<T, R> withTimer(Timer timer) {
            this.function = Timer.decorateCheckedFunction((Timer)timer, this.function);
            return this;
        }

        public DecorateCheckedFunction<T, R> withCircuitBreaker(CircuitBreaker circuitBreaker) {
            this.function = CircuitBreaker.decorateCheckedFunction((CircuitBreaker)circuitBreaker, this.function);
            return this;
        }

        public DecorateCheckedFunction<T, R> withRetry(Retry retryContext) {
            this.function = Retry.decorateCheckedFunction((Retry)retryContext, this.function);
            return this;
        }

        public DecorateCheckedFunction<T, R> withRateLimiter(RateLimiter rateLimiter) {
            return this.withRateLimiter(rateLimiter, 1);
        }

        public DecorateCheckedFunction<T, R> withRateLimiter(RateLimiter rateLimiter, int permits) {
            this.function = RateLimiter.decorateCheckedFunction((RateLimiter)rateLimiter, (int)permits, this.function);
            return this;
        }

        public DecorateCheckedFunction<T, R> withRateLimiter(RateLimiter rateLimiter, Function<T, Integer> permitsCalculator) {
            this.function = RateLimiter.decorateCheckedFunction((RateLimiter)rateLimiter, permitsCalculator, this.function);
            return this;
        }

        public DecorateCheckedFunction<T, R> withBulkhead(Bulkhead bulkhead) {
            this.function = Bulkhead.decorateCheckedFunction((Bulkhead)bulkhead, this.function);
            return this;
        }

        public CheckedFunction<T, R> decorate() {
            return this.function;
        }

        public R apply(T t) throws Throwable {
            return (R)this.function.apply(t);
        }
    }

    public static class DecorateCheckedRunnable {
        private CheckedRunnable runnable;

        private DecorateCheckedRunnable(CheckedRunnable runnable) {
            this.runnable = runnable;
        }

        public DecorateCheckedRunnable withTimer(Timer timer) {
            this.runnable = Timer.decorateCheckedRunnable((Timer)timer, (CheckedRunnable)this.runnable);
            return this;
        }

        public DecorateCheckedRunnable withCircuitBreaker(CircuitBreaker circuitBreaker) {
            this.runnable = CircuitBreaker.decorateCheckedRunnable((CircuitBreaker)circuitBreaker, (CheckedRunnable)this.runnable);
            return this;
        }

        public DecorateCheckedRunnable withRetry(Retry retryContext) {
            this.runnable = Retry.decorateCheckedRunnable((Retry)retryContext, (CheckedRunnable)this.runnable);
            return this;
        }

        public DecorateCheckedRunnable withRateLimiter(RateLimiter rateLimiter) {
            this.runnable = RateLimiter.decorateCheckedRunnable((RateLimiter)rateLimiter, (CheckedRunnable)this.runnable);
            return this;
        }

        public DecorateCheckedRunnable withRateLimiter(RateLimiter rateLimiter, int permits) {
            this.runnable = RateLimiter.decorateCheckedRunnable((RateLimiter)rateLimiter, (int)permits, (CheckedRunnable)this.runnable);
            return this;
        }

        public DecorateCheckedRunnable withBulkhead(Bulkhead bulkhead) {
            this.runnable = Bulkhead.decorateCheckedRunnable((Bulkhead)bulkhead, (CheckedRunnable)this.runnable);
            return this;
        }

        public CheckedRunnable decorate() {
            return this.runnable;
        }

        public void run() throws Throwable {
            this.runnable.run();
        }
    }

    public static class DecorateCompletionStage<T> {
        private Supplier<CompletionStage<T>> stageSupplier;

        public DecorateCompletionStage(Supplier<CompletionStage<T>> stageSupplier) {
            this.stageSupplier = stageSupplier;
        }

        public DecorateCompletionStage<T> withTimer(Timer timer) {
            this.stageSupplier = Timer.decorateCompletionStage((Timer)timer, this.stageSupplier);
            return this;
        }

        public DecorateCompletionStage<T> withCircuitBreaker(CircuitBreaker circuitBreaker) {
            this.stageSupplier = CircuitBreaker.decorateCompletionStage((CircuitBreaker)circuitBreaker, this.stageSupplier);
            return this;
        }

        public DecorateCompletionStage<T> withRetry(Retry retryContext, ScheduledExecutorService scheduler) {
            this.stageSupplier = Retry.decorateCompletionStage((Retry)retryContext, (ScheduledExecutorService)scheduler, this.stageSupplier);
            return this;
        }

        public DecorateCompletionStage<T> withBulkhead(Bulkhead bulkhead) {
            this.stageSupplier = Bulkhead.decorateCompletionStage((Bulkhead)bulkhead, this.stageSupplier);
            return this;
        }

        public DecorateCompletionStage<T> withTimeLimiter(TimeLimiter timeLimiter, ScheduledExecutorService scheduler) {
            this.stageSupplier = timeLimiter.decorateCompletionStage(scheduler, this.stageSupplier);
            return this;
        }

        public DecorateCompletionStage<T> withRateLimiter(RateLimiter rateLimiter) {
            return this.withRateLimiter(rateLimiter, 1);
        }

        public DecorateCompletionStage<T> withRateLimiter(RateLimiter rateLimiter, int permits) {
            this.stageSupplier = RateLimiter.decorateCompletionStage((RateLimiter)rateLimiter, (int)permits, this.stageSupplier);
            return this;
        }

        public DecorateCompletionStage<T> withFallback(Predicate<T> resultPredicate, UnaryOperator<T> resultHandler) {
            this.stageSupplier = CompletionStageUtils.recover(this.stageSupplier, resultPredicate, resultHandler);
            return this;
        }

        public DecorateCompletionStage<T> withFallback(BiFunction<T, Throwable, T> handler) {
            this.stageSupplier = CompletionStageUtils.andThen(this.stageSupplier, handler);
            return this;
        }

        public DecorateCompletionStage<T> withFallback(List<Class<? extends Throwable>> exceptionTypes, Function<Throwable, T> exceptionHandler) {
            this.stageSupplier = CompletionStageUtils.recover(this.stageSupplier, exceptionTypes, exceptionHandler);
            return this;
        }

        public DecorateCompletionStage<T> withFallback(Function<Throwable, T> exceptionHandler) {
            this.stageSupplier = CompletionStageUtils.recover(this.stageSupplier, exceptionHandler);
            return this;
        }

        public <X extends Throwable> DecorateCompletionStage<T> withFallback(Class<X> exceptionType, Function<Throwable, T> exceptionHandler) {
            this.stageSupplier = CompletionStageUtils.recover(this.stageSupplier, exceptionType, exceptionHandler);
            return this;
        }

        public Supplier<CompletionStage<T>> decorate() {
            return this.stageSupplier;
        }

        public CompletionStage<T> get() {
            return this.stageSupplier.get();
        }
    }

    public static class DecorateConsumer<T> {
        private Consumer<T> consumer;

        private DecorateConsumer(Consumer<T> consumer) {
            this.consumer = consumer;
        }

        public DecorateConsumer<T> withTimer(Timer timer) {
            this.consumer = Timer.decorateConsumer((Timer)timer, this.consumer);
            return this;
        }

        public DecorateConsumer<T> withCircuitBreaker(CircuitBreaker circuitBreaker) {
            this.consumer = CircuitBreaker.decorateConsumer((CircuitBreaker)circuitBreaker, this.consumer);
            return this;
        }

        public DecorateConsumer<T> withRateLimiter(RateLimiter rateLimiter) {
            return this.withRateLimiter(rateLimiter, 1);
        }

        public DecorateConsumer<T> withRateLimiter(RateLimiter rateLimiter, int permits) {
            this.consumer = RateLimiter.decorateConsumer((RateLimiter)rateLimiter, (int)permits, this.consumer);
            return this;
        }

        public DecorateConsumer<T> withRateLimiter(RateLimiter rateLimiter, Function<T, Integer> permitsCalculator) {
            this.consumer = RateLimiter.decorateConsumer((RateLimiter)rateLimiter, permitsCalculator, this.consumer);
            return this;
        }

        public DecorateConsumer<T> withBulkhead(Bulkhead bulkhead) {
            this.consumer = Bulkhead.decorateConsumer((Bulkhead)bulkhead, this.consumer);
            return this;
        }

        public Consumer<T> decorate() {
            return this.consumer;
        }

        public void accept(T t) {
            this.consumer.accept(t);
        }
    }
}

