/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.prometheus;

import io.github.resilience4j.prometheus.CallCollectors;
import io.github.resilience4j.prometheus.CallMeterBase;
import io.github.resilience4j.prometheus.CallMeterImpl;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.Counter;
import io.prometheus.client.Histogram;
import io.vavr.CheckedFunction0;
import io.vavr.CheckedFunction1;
import io.vavr.CheckedRunnable;
import java.io.Serializable;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.function.Supplier;

public interface CallMeter
extends CallMeterBase {
    public static CallMeter of(String name, String help) {
        return CallMeter.builder().name(name).help(help).build();
    }

    public static CallMeter ofCollectorRegistry(String name, String help, CollectorRegistry registry) {
        return CallMeter.of(name, help).register(registry);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static <T> CheckedFunction0<T> decorateCheckedSupplier(CallMeterBase meter, CheckedFunction0<T> supplier) {
        return (CheckedFunction0 & Serializable)() -> {
            CallMeterBase.Timer timer = meter.startTimer();
            try {
                Object returnValue = supplier.apply();
                timer.onSuccess();
                return returnValue;
            }
            catch (Throwable e) {
                timer.onError();
                throw e;
            }
        };
    }

    public static CheckedRunnable decorateCheckedRunnable(CallMeterBase meter, CheckedRunnable runnable) {
        return () -> {
            CallMeterBase.Timer timer = meter.startTimer();
            try {
                runnable.run();
                timer.onSuccess();
            }
            catch (Throwable e) {
                timer.onError();
                throw e;
            }
        };
    }

    public static <T> Supplier<T> decorateSupplier(CallMeterBase meter, Supplier<T> supplier) {
        return () -> {
            CallMeterBase.Timer timer = meter.startTimer();
            try {
                Object returnValue = supplier.get();
                timer.onSuccess();
                return returnValue;
            }
            catch (Throwable e) {
                timer.onError();
                throw e;
            }
        };
    }

    public static <T> Callable<T> decorateCallable(CallMeterBase meter, Callable<T> callable) {
        return () -> {
            CallMeterBase.Timer timer = meter.startTimer();
            try {
                Object returnValue = callable.call();
                timer.onSuccess();
                return returnValue;
            }
            catch (Throwable e) {
                timer.onError();
                throw e;
            }
        };
    }

    public static Runnable decorateRunnable(CallMeterBase meter, Runnable runnable) {
        return () -> {
            CallMeterBase.Timer timer = meter.startTimer();
            try {
                runnable.run();
                timer.onSuccess();
            }
            catch (Throwable e) {
                timer.onError();
                throw e;
            }
        };
    }

    public static <T, R> Function<T, R> decorateFunction(CallMeterBase meter, Function<T, R> function) {
        return t -> {
            CallMeterBase.Timer timer = meter.startTimer();
            try {
                Object returnValue = function.apply(t);
                timer.onSuccess();
                return returnValue;
            }
            catch (Throwable e) {
                timer.onError();
                throw e;
            }
        };
    }

    public static <T, R> CheckedFunction1<T, R> decorateCheckedFunction(CallMeterBase meter, CheckedFunction1<T, R> function) {
        return (CheckedFunction1 & Serializable)t -> {
            CallMeterBase.Timer timer = meter.startTimer();
            try {
                Object returnValue = function.apply(t);
                timer.onSuccess();
                return returnValue;
            }
            catch (Throwable e) {
                timer.onError();
                throw e;
            }
        };
    }

    public static <T> Supplier<CompletionStage<T>> decorateCompletionStageSupplier(CallMeterBase meter, Supplier<CompletionStage<T>> stageSupplier) {
        return () -> {
            CallMeterBase.Timer timer = meter.startTimer();
            try {
                CompletionStage stage = (CompletionStage)stageSupplier.get();
                stage.whenComplete((result, throwable) -> {
                    if (throwable != null) {
                        timer.onError();
                    } else {
                        timer.onSuccess();
                    }
                });
                return stage;
            }
            catch (Throwable throwable2) {
                timer.onError();
                throw throwable2;
            }
        };
    }

    public Child labels(String ... var1);

    default public CallMeter register() {
        return this.register(CollectorRegistry.defaultRegistry);
    }

    public CallMeter register(CollectorRegistry var1);

    public static class Builder {
        private String namespace = "";
        private String subsystem = "";
        private String name = "";
        private String help = "";
        private String[] labelNames = new String[0];

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder subsystem(String subsystem) {
            this.subsystem = subsystem;
            return this;
        }

        public Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public Builder help(String help) {
            this.help = help;
            return this;
        }

        public Builder labelNames(String ... labelNames) {
            this.labelNames = labelNames;
            return this;
        }

        public CallMeter build() {
            return new CallMeterImpl(this.createMetrics());
        }

        private CallCollectors createMetrics() {
            Counter totalCounter = ((Counter.Builder)((Counter.Builder)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().namespace(this.namespace)).subsystem(this.subsystem)).name(this.name + "_total")).help(this.help + " total")).labelNames(this.labelNames)).create();
            Counter errorCounter = ((Counter.Builder)((Counter.Builder)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().namespace(this.namespace)).subsystem(this.subsystem)).name(this.name + "_failures_total")).help(this.help + " failures total")).labelNames(this.labelNames)).create();
            Histogram histogram = ((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)Histogram.build().namespace(this.namespace)).subsystem(this.subsystem)).name(this.name + "_latency")).help(this.help + " latency")).labelNames(this.labelNames)).create();
            return new CallCollectors(histogram, totalCounter, errorCounter);
        }
    }

    public static interface Child
    extends CallMeterBase {
    }
}

