/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.prometheus.collectors;

import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.circuitbreaker.CircuitBreakerRegistry;
import io.github.resilience4j.prometheus.AbstractCircuitBreakerMetrics;
import io.prometheus.client.Collector;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class CircuitBreakerMetricsCollector
extends AbstractCircuitBreakerMetrics {
    private final CircuitBreakerRegistry circuitBreakerRegistry;

    private CircuitBreakerMetricsCollector(AbstractCircuitBreakerMetrics.MetricNames names, AbstractCircuitBreakerMetrics.MetricOptions options, CircuitBreakerRegistry circuitBreakerRegistry) {
        super(names, options);
        this.circuitBreakerRegistry = Objects.requireNonNull(circuitBreakerRegistry);
        for (CircuitBreaker circuitBreaker : this.circuitBreakerRegistry.getAllCircuitBreakers()) {
            this.addMetrics(circuitBreaker);
        }
        circuitBreakerRegistry.getEventPublisher().onEntryAdded(event -> this.addMetrics((CircuitBreaker)event.getAddedEntry()));
    }

    public static CircuitBreakerMetricsCollector ofCircuitBreakerRegistry(AbstractCircuitBreakerMetrics.MetricNames names, AbstractCircuitBreakerMetrics.MetricOptions options, CircuitBreakerRegistry circuitBreakerRegistry) {
        return new CircuitBreakerMetricsCollector(names, options, circuitBreakerRegistry);
    }

    public static CircuitBreakerMetricsCollector ofCircuitBreakerRegistry(AbstractCircuitBreakerMetrics.MetricNames names, CircuitBreakerRegistry circuitBreakerRegistry) {
        return new CircuitBreakerMetricsCollector(names, AbstractCircuitBreakerMetrics.MetricOptions.ofDefaults(), circuitBreakerRegistry);
    }

    public static CircuitBreakerMetricsCollector ofCircuitBreakerRegistry(CircuitBreakerRegistry circuitBreakerRegistry) {
        return new CircuitBreakerMetricsCollector(AbstractCircuitBreakerMetrics.MetricNames.ofDefaults(), AbstractCircuitBreakerMetrics.MetricOptions.ofDefaults(), circuitBreakerRegistry);
    }

    public List<Collector.MetricFamilySamples> collect() {
        ArrayList<Collector.MetricFamilySamples> samples = Collections.list(this.collectorRegistry.metricFamilySamples());
        samples.addAll(this.collectGaugeSamples(this.circuitBreakerRegistry.getAllCircuitBreakers().asJava()));
        return samples;
    }
}

