/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.prometheus.collectors;

import io.github.resilience4j.bulkhead.ThreadPoolBulkhead;
import io.github.resilience4j.bulkhead.ThreadPoolBulkheadRegistry;
import io.github.resilience4j.prometheus.LabelNames;
import io.prometheus.client.Collector;
import io.prometheus.client.GaugeMetricFamily;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class ThreadPoolBulkheadMetricsCollector
extends Collector {
    private final MetricNames names;
    private final ThreadPoolBulkheadRegistry bulkheadRegistry;

    private ThreadPoolBulkheadMetricsCollector(MetricNames names, ThreadPoolBulkheadRegistry bulkheadRegistry) {
        this.names = Objects.requireNonNull(names);
        this.bulkheadRegistry = Objects.requireNonNull(bulkheadRegistry);
    }

    public static ThreadPoolBulkheadMetricsCollector ofBulkheadRegistry(MetricNames names, ThreadPoolBulkheadRegistry bulkheadRegistry) {
        return new ThreadPoolBulkheadMetricsCollector(names, bulkheadRegistry);
    }

    public static ThreadPoolBulkheadMetricsCollector ofBulkheadRegistry(ThreadPoolBulkheadRegistry bulkheadRegistry) {
        return new ThreadPoolBulkheadMetricsCollector(MetricNames.ofDefaults(), bulkheadRegistry);
    }

    public List<Collector.MetricFamilySamples> collect() {
        GaugeMetricFamily availableCallsFamily = new GaugeMetricFamily(this.names.getCurrentThreadPoolSizeName(), "The number of currently used bulkhead threads", LabelNames.NAME);
        GaugeMetricFamily maxAllowedCallsFamily = new GaugeMetricFamily(this.names.getAvailableQueueCapacityName(), "The number of available bulkhead queue slots", LabelNames.NAME);
        for (ThreadPoolBulkhead bulkhead : this.bulkheadRegistry.getAllBulkheads()) {
            List<String> labelValues = Collections.singletonList(bulkhead.getName());
            availableCallsFamily.addMetric(labelValues, (double)bulkhead.getMetrics().getThreadPoolSize());
            maxAllowedCallsFamily.addMetric(labelValues, (double)bulkhead.getMetrics().getRemainingQueueCapacity());
        }
        return Arrays.asList(availableCallsFamily, maxAllowedCallsFamily);
    }

    public static class MetricNames {
        public static final String DEFAULT_BULKHEAD_CURRENT_THREAD_POOL_SIZE_NAME = "resilience4j_thread_pool_bulkhead_current_thread_pool_size";
        public static final String DEFAULT_BULKHEAD_AVAILABLE_QUEUE_CAPACITY_NAME = "resilience4j_thread_pool_bulkhead_available_queue_capacity";
        private String currentThreadPoolSizeName = "resilience4j_thread_pool_bulkhead_current_thread_pool_size";
        private String availableQueueCapacityName = "resilience4j_thread_pool_bulkhead_available_queue_capacity";

        private MetricNames() {
        }

        public static Builder custom() {
            return new Builder();
        }

        public static MetricNames ofDefaults() {
            return new MetricNames();
        }

        public String getCurrentThreadPoolSizeName() {
            return this.currentThreadPoolSizeName;
        }

        public String getAvailableQueueCapacityName() {
            return this.availableQueueCapacityName;
        }

        public static class Builder {
            private final MetricNames metricNames = new MetricNames();

            public Builder availableConcurrentCallsMetricName(String currentThreadPoolSizeName) {
                this.metricNames.currentThreadPoolSizeName = Objects.requireNonNull(currentThreadPoolSizeName);
                return this;
            }

            public Builder maxAllowedConcurrentCallsMetricName(String availableQueueCapacityName) {
                this.metricNames.availableQueueCapacityName = Objects.requireNonNull(availableQueueCapacityName);
                return this;
            }

            public MetricNames build() {
                return this.metricNames;
            }
        }
    }
}

