/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.ratelimiter;

import io.github.resilience4j.core.Registry;
import io.github.resilience4j.core.RegistryStore;
import io.github.resilience4j.core.registry.RegistryEventConsumer;
import io.github.resilience4j.ratelimiter.RateLimiter;
import io.github.resilience4j.ratelimiter.RateLimiterConfig;
import io.github.resilience4j.ratelimiter.internal.InMemoryRateLimiterRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;

public interface RateLimiterRegistry
extends Registry<RateLimiter, RateLimiterConfig> {
    public static RateLimiterRegistry of(RateLimiterConfig defaultRateLimiterConfig) {
        return new InMemoryRateLimiterRegistry(defaultRateLimiterConfig);
    }

    public static RateLimiterRegistry of(RateLimiterConfig defaultRateLimiterConfig, RegistryEventConsumer<RateLimiter> registryEventConsumer) {
        return new InMemoryRateLimiterRegistry(defaultRateLimiterConfig, registryEventConsumer);
    }

    public static RateLimiterRegistry of(RateLimiterConfig defaultRateLimiterConfig, List<RegistryEventConsumer<RateLimiter>> registryEventConsumers) {
        return new InMemoryRateLimiterRegistry(defaultRateLimiterConfig, registryEventConsumers);
    }

    public static RateLimiterRegistry ofDefaults() {
        return new InMemoryRateLimiterRegistry(RateLimiterConfig.ofDefaults());
    }

    public static RateLimiterRegistry of(Map<String, RateLimiterConfig> configs) {
        return new InMemoryRateLimiterRegistry(configs);
    }

    public static RateLimiterRegistry of(Map<String, RateLimiterConfig> configs, Map<String, String> tags) {
        return new InMemoryRateLimiterRegistry(configs, tags);
    }

    public static RateLimiterRegistry of(Map<String, RateLimiterConfig> configs, RegistryEventConsumer<RateLimiter> registryEventConsumer) {
        return new InMemoryRateLimiterRegistry(configs, registryEventConsumer);
    }

    public static RateLimiterRegistry of(Map<String, RateLimiterConfig> configs, RegistryEventConsumer<RateLimiter> registryEventConsumer, Map<String, String> tags) {
        return new InMemoryRateLimiterRegistry(configs, registryEventConsumer, tags);
    }

    public static RateLimiterRegistry of(Map<String, RateLimiterConfig> configs, List<RegistryEventConsumer<RateLimiter>> registryEventConsumers) {
        return new InMemoryRateLimiterRegistry(configs, registryEventConsumers);
    }

    public Set<RateLimiter> getAllRateLimiters();

    public RateLimiter rateLimiter(String var1);

    public RateLimiter rateLimiter(String var1, Map<String, String> var2);

    public RateLimiter rateLimiter(String var1, RateLimiterConfig var2);

    public RateLimiter rateLimiter(String var1, RateLimiterConfig var2, Map<String, String> var3);

    public RateLimiter rateLimiter(String var1, Supplier<RateLimiterConfig> var2);

    public RateLimiter rateLimiter(String var1, Supplier<RateLimiterConfig> var2, Map<String, String> var3);

    public RateLimiter rateLimiter(String var1, String var2);

    public RateLimiter rateLimiter(String var1, String var2, Map<String, String> var3);

    public static Builder custom() {
        return new Builder();
    }

    public static class Builder {
        private static final String DEFAULT_CONFIG = "default";
        private RegistryStore<RateLimiter> registryStore;
        private Map<String, RateLimiterConfig> rateLimiterConfigsMap = new HashMap<String, RateLimiterConfig>();
        private List<RegistryEventConsumer<RateLimiter>> registryEventConsumers = new ArrayList<RegistryEventConsumer<RateLimiter>>();
        private Map<String, String> tags;

        public Builder withRegistryStore(RegistryStore<RateLimiter> registryStore) {
            this.registryStore = registryStore;
            return this;
        }

        public Builder withRateLimiterConfig(RateLimiterConfig rateLimiterConfig) {
            this.rateLimiterConfigsMap.put(DEFAULT_CONFIG, rateLimiterConfig);
            return this;
        }

        public Builder addRateLimiterConfig(String configName, RateLimiterConfig configuration) {
            if (configName.equals(DEFAULT_CONFIG)) {
                throw new IllegalArgumentException("You cannot add another configuration with name 'default' as it is preserved for default configuration");
            }
            this.rateLimiterConfigsMap.put(configName, configuration);
            return this;
        }

        public Builder addRegistryEventConsumer(RegistryEventConsumer<RateLimiter> registryEventConsumer) {
            this.registryEventConsumers.add(registryEventConsumer);
            return this;
        }

        public Builder withTags(Map<String, String> tags) {
            this.tags = tags;
            return this;
        }

        public RateLimiterRegistry build() {
            return new InMemoryRateLimiterRegistry(this.rateLimiterConfigsMap, this.registryEventConsumers, this.tags, this.registryStore);
        }
    }
}

