/*
 * Decompiled with CFR 0.152.
 */
package io.openjob.worker.spring.boot;

import io.openjob.common.OpenjobSpringContext;
import io.openjob.worker.processor.ProcessResult;
import io.openjob.worker.processor.ProcessorHandler;
import io.openjob.worker.processor.ProcessorHandlerMapping;
import io.openjob.worker.spring.boot.annotation.Openjob;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.core.MethodIntrospector;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.util.CollectionUtils;

public class OpenjobSpringWorker
implements SmartInitializingSingleton {
    private static final Logger log = LoggerFactory.getLogger(OpenjobSpringWorker.class);

    public void afterSingletonsInstantiated() {
        String[] beanNames;
        if (Objects.isNull(OpenjobSpringContext.getApplicationContext())) {
            return;
        }
        for (String beanName : beanNames = OpenjobSpringContext.getBeanNamesForType(Object.class, (boolean)false, (boolean)true)) {
            Object bean = OpenjobSpringContext.getBean((String)beanName);
            Map annotatedMethods = null;
            try {
                annotatedMethods = MethodIntrospector.selectMethods(bean.getClass(), method -> (Openjob)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, Openjob.class));
            }
            catch (Throwable ex) {
                log.error(String.format("Processor handler resolve failed! beanName=%s beanClass=%s", beanName, beanName.getClass()), ex);
            }
            if (CollectionUtils.isEmpty((Map)annotatedMethods)) continue;
            for (Map.Entry entry : annotatedMethods.entrySet()) {
                Method method2 = (Method)entry.getKey();
                Openjob openjob = (Openjob)entry.getValue();
                if (Objects.isNull(openjob)) continue;
                this.registerProcessorHandler(bean, method2, openjob);
            }
        }
    }

    private void registerProcessorHandler(Object bean, Method method, Openjob openjob) {
        String stopMethodName;
        String postMethodName;
        ProcessorHandler processorHandler = new ProcessorHandler();
        processorHandler.setTarget(bean);
        String name = openjob.value();
        if (StringUtils.isEmpty((CharSequence)name)) {
            throw new RuntimeException(String.format("Openjob name can not be empty! class=%s method=%s", bean.getClass(), method.getName()));
        }
        if (OpenjobSpringContext.containsBean((String)name).booleanValue()) {
            throw new RuntimeException(String.format("Bean of the openjob name has existed! class=%s method=%s name=%s", bean.getClass(), method.getName(), name));
        }
        if (ProcessorHandlerMapping.hasProcessorHandler((String)name).booleanValue()) {
            throw new RuntimeException(String.format("Openjob name has existed! class=%s method=%s name=%s", bean.getClass(), method.getName(), name));
        }
        if (!method.getReturnType().isAssignableFrom(ProcessResult.class)) {
            throw new RuntimeException(String.format("Processor method must return ProcessResult! class=%s method=%s name=%s", bean.getClass(), method.getName(), name));
        }
        method.setAccessible(true);
        processorHandler.setProcessMethod(method);
        String preMethodName = openjob.pre();
        if (!StringUtils.isEmpty((CharSequence)preMethodName)) {
            try {
                Method preMethod = bean.getClass().getMethod(preMethodName, new Class[0]);
                preMethod.setAccessible(true);
                processorHandler.setPreMethod(preMethod);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(String.format("Pre method is undefined! method=%s", preMethodName), e);
            }
        }
        if (!StringUtils.isEmpty((CharSequence)(postMethodName = openjob.post()))) {
            try {
                Method postMethod = bean.getClass().getMethod(postMethodName, new Class[0]);
                postMethod.setAccessible(true);
                processorHandler.setPostMethod(postMethod);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(String.format("Post method is undefined! method=%s", preMethodName), e);
            }
        }
        if (!StringUtils.isEmpty((CharSequence)(stopMethodName = openjob.stop()))) {
            try {
                Method stopMethod = bean.getClass().getMethod(stopMethodName, new Class[0]);
                stopMethod.setAccessible(true);
                processorHandler.setStopMethod(stopMethod);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(String.format("Stop method is undefined! method=%s", preMethodName), e);
            }
        }
        ProcessorHandlerMapping.registerProcessorHandler((String)name, (ProcessorHandler)processorHandler);
    }
}

