/*
 * Decompiled with CFR 0.152.
 */
package io.openjob.worker.spring.boot.autoconfigure;

import io.openjob.common.OpenjobSpringContext;
import io.openjob.worker.OpenjobWorker;
import io.openjob.worker.delay.OpenjobDelayTemplate;
import io.openjob.worker.spring.boot.OpenjobSpringWorker;
import io.openjob.worker.spring.boot.autoconfigure.OpenjobWorkerProperties;
import java.util.Objects;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={OpenjobWorkerProperties.class})
public class OpenjobWorkerAutoConfiguration {
    private final OpenjobWorkerProperties properties;

    @Autowired
    public OpenjobWorkerAutoConfiguration(OpenjobWorkerProperties properties) {
        this.properties = properties;
    }

    @PostConstruct
    public void init() {
        if (StringUtils.isEmpty((CharSequence)System.getProperty("openjob.server.address")) && Objects.nonNull(this.properties.getServer().getAddress())) {
            System.setProperty("openjob.server.address", String.valueOf(this.properties.getServer().getAddress()));
        }
        if (StringUtils.isEmpty((CharSequence)System.getProperty("openjob.worker.heartbeat.interval")) && Objects.nonNull(this.properties.getWorker().getHeartbeatInterval())) {
            System.setProperty("openjob.worker.heartbeat.interval", String.valueOf(this.properties.getWorker().getHeartbeatInterval()));
        }
        if (StringUtils.isEmpty((CharSequence)System.getProperty("openjob.worker.host")) && Objects.nonNull(this.properties.getWorker().getHost())) {
            System.setProperty("openjob.worker.host", this.properties.getWorker().getHost());
        }
        if (StringUtils.isEmpty((CharSequence)System.getProperty("openjob.worker.port")) && Objects.nonNull(this.properties.getWorker().getPort())) {
            System.setProperty("openjob.worker.port", String.valueOf(this.properties.getWorker().getPort()));
        }
        if (StringUtils.isEmpty((CharSequence)System.getProperty("openjob.worker.app.name")) && Objects.nonNull(this.properties.getWorker().getAppName())) {
            System.setProperty("openjob.worker.app.name", this.properties.getWorker().getAppName());
        }
        if (StringUtils.isEmpty((CharSequence)System.getProperty("openjob.worker.heartbeat.actor.num")) && Objects.nonNull(this.properties.getActor().getHeartbeatNum())) {
            System.setProperty("openjob.worker.heartbeat.actor.num", String.valueOf(this.properties.getActor().getHeartbeatNum()));
        }
        if (StringUtils.isEmpty((CharSequence)System.getProperty("openjob.worker.task.master.actor.num")) && Objects.nonNull(this.properties.getActor().getTaskMasterNum())) {
            System.setProperty("openjob.worker.task.master.actor.num", String.valueOf(this.properties.getActor().getTaskMasterNum()));
        }
        if (StringUtils.isEmpty((CharSequence)System.getProperty("openjob.worker.task.container.actor.num")) && Objects.nonNull(this.properties.getActor().getTaskContainerNum())) {
            System.setProperty("openjob.worker.task.container.actor.num", String.valueOf(this.properties.getActor().getTaskContainerNum()));
        }
        if (StringUtils.isEmpty((CharSequence)System.getProperty("openjob.worker.persistent.actor.num")) && Objects.nonNull(this.properties.getActor().getPersistentNum())) {
            System.setProperty("openjob.worker.persistent.actor.num", String.valueOf(this.properties.getActor().getPersistentNum()));
        }
        if (StringUtils.isEmpty((CharSequence)System.getProperty("openjob.worker.delay.master.actor.num")) && Objects.nonNull(this.properties.getActor().getDelayMasterNum())) {
            System.setProperty("openjob.worker.delay.master.actor.num", String.valueOf(this.properties.getActor().getDelayMasterNum()));
        }
        if (StringUtils.isEmpty((CharSequence)System.getProperty("openjob.worker.delay.enable")) && Objects.nonNull(this.properties.getDelay().getEnable())) {
            System.setProperty("openjob.worker.delay.enable", String.valueOf(this.properties.getDelay().getEnable()));
        }
        if (StringUtils.isEmpty((CharSequence)System.getProperty("openjob.worker.delay.pull.size")) && Objects.nonNull(this.properties.getDelay().getPullSize())) {
            System.setProperty("openjob.worker.delay.pull.size", String.valueOf(this.properties.getDelay().getPullSize()));
        }
        if (StringUtils.isEmpty((CharSequence)System.getProperty("openjob.worker.delay.pull.sleep")) && Objects.nonNull(this.properties.getDelay().getPullSleep())) {
            System.setProperty("openjob.worker.delay.pull.sleep", String.valueOf(this.properties.getDelay().getPullSleep()));
        }
        if (StringUtils.isEmpty((CharSequence)System.getProperty("openjob.worker.delay.pull.step")) && Objects.nonNull(this.properties.getDelay().getPullStep())) {
            System.setProperty("openjob.worker.delay.pull.step", String.valueOf(this.properties.getDelay().getPullStep()));
        }
        if (StringUtils.isEmpty((CharSequence)System.getProperty("openjob.worker.delay.timeout")) && Objects.nonNull(this.properties.getDelay().getTimeout())) {
            System.setProperty("openjob.worker.delay.timeout", String.valueOf(this.properties.getDelay().getTimeout()));
        }
    }

    @Bean
    @ConditionalOnMissingBean
    public OpenjobSpringContext openjobSpringContext() {
        return new OpenjobSpringContext();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="spring.openjob", name={"enable"}, havingValue="true", matchIfMissing=true)
    public OpenjobWorker openjobWorker() {
        return new OpenjobWorker();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="spring.openjob", name={"enable"}, havingValue="true", matchIfMissing=true)
    public OpenjobSpringWorker openjobSpringWorker() {
        return new OpenjobSpringWorker();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="spring.openjob.delay", name={"enable"}, havingValue="true")
    public OpenjobDelayTemplate openjobDelayTemplate() {
        return new OpenjobDelayTemplate();
    }
}

