/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.resources;

import io.opentelemetry.sdk.autoconfigure.spi.AutoConfigurationCustomizer;
import io.opentelemetry.sdk.autoconfigure.spi.AutoConfigurationCustomizerProvider;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public class ResourceProviderPropertiesCustomizer
implements AutoConfigurationCustomizerProvider {
    private static final Map<String, String> DISABLED_BY_DEFAULT_RESOURCE_PROVIDERS = new HashMap<String, String>();
    static final String DISABLED_KEY = "otel.java.disabled.resource.providers";
    static final String ENABLED_KEY = "otel.java.enabled.resource.providers";

    public void customize(AutoConfigurationCustomizer autoConfigurationCustomizer) {
        autoConfigurationCustomizer.addPropertiesCustomizer(this::customize);
    }

    public Map<String, String> customize(ConfigProperties config) {
        HashSet<String> enabledProviders = new HashSet<String>(config.getList(ENABLED_KEY));
        ArrayList<String> enabled = new ArrayList<String>();
        ArrayList<String> disabled = new ArrayList<String>();
        for (Map.Entry<String, String> providerEntry : DISABLED_BY_DEFAULT_RESOURCE_PROVIDERS.entrySet()) {
            String providerName = providerEntry.getKey();
            String providerGroup = providerEntry.getValue();
            Boolean explictEnabled = config.getBoolean(String.format("otel.resource.providers.%s.enabled", providerGroup));
            if (ResourceProviderPropertiesCustomizer.isEnabled(providerName, enabledProviders, explictEnabled)) {
                enabled.add(providerName);
                continue;
            }
            disabled.add(providerName);
        }
        if (!enabledProviders.isEmpty()) {
            enabled.addAll(enabledProviders);
            return Collections.singletonMap(ENABLED_KEY, String.join((CharSequence)",", enabled));
        }
        if (disabled.isEmpty()) {
            return Collections.emptyMap();
        }
        disabled.addAll(config.getList(DISABLED_KEY));
        return Collections.singletonMap(DISABLED_KEY, String.join((CharSequence)",", disabled));
    }

    private static boolean isEnabled(String className, Set<String> enabledProviders, @Nullable Boolean explicitEnabled) {
        if (explicitEnabled != null) {
            return explicitEnabled;
        }
        return !enabledProviders.isEmpty() && enabledProviders.contains(className);
    }

    public int order() {
        return Integer.MAX_VALUE;
    }

    static {
        DISABLED_BY_DEFAULT_RESOURCE_PROVIDERS.put("io.opentelemetry.contrib.aws.resource.BeanstalkResourceProvider", "aws");
        DISABLED_BY_DEFAULT_RESOURCE_PROVIDERS.put("io.opentelemetry.contrib.aws.resource.Ec2ResourceProvider", "aws");
        DISABLED_BY_DEFAULT_RESOURCE_PROVIDERS.put("io.opentelemetry.contrib.aws.resource.EcsResourceProvider", "aws");
        DISABLED_BY_DEFAULT_RESOURCE_PROVIDERS.put("io.opentelemetry.contrib.aws.resource.EksResourceProvider", "aws");
        DISABLED_BY_DEFAULT_RESOURCE_PROVIDERS.put("io.opentelemetry.contrib.aws.resource.LambdaResourceProvider", "aws");
        DISABLED_BY_DEFAULT_RESOURCE_PROVIDERS.put("io.opentelemetry.contrib.gcp.resource.GCPResourceProvider", "gcp");
        DISABLED_BY_DEFAULT_RESOURCE_PROVIDERS.put("io.opentelemetry.instrumentation.resources.ResourceProviderPropertiesCustomizerTest$Provider", "test");
    }
}

