/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.mssql.message.token;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.util.AbstractReferenceCounted;
import io.netty.util.ReferenceCountUtil;
import io.r2dbc.mssql.message.token.Column;
import io.r2dbc.mssql.message.token.DataToken;
import io.r2dbc.mssql.message.type.Length;
import io.r2dbc.mssql.message.type.LengthStrategy;
import io.r2dbc.mssql.message.type.PlpLength;
import io.r2dbc.mssql.util.Assert;
import reactor.util.annotation.Nullable;

public class RowToken
extends AbstractReferenceCounted
implements DataToken {
    public static final byte TYPE = -47;
    private final ByteBuf[] data;

    RowToken(ByteBuf[] data) {
        this.data = data;
    }

    public static RowToken decode(ByteBuf buffer, Column[] columns) {
        Assert.requireNonNull(buffer, "Data buffer must not be null");
        Assert.requireNonNull(columns, "List of Columns must not be null");
        return RowToken.doDecode(buffer, columns);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean canDecode(ByteBuf buffer, Column[] columns) {
        Assert.requireNonNull(buffer, "Data buffer must not be null");
        Assert.requireNonNull(columns, "List of Columns must not be null");
        int readerIndex = buffer.readerIndex();
        try {
            for (Column column : columns) {
                if (RowToken.canDecodeColumn(buffer, column)) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            buffer.readerIndex(readerIndex);
        }
    }

    static boolean canDecodeColumn(ByteBuf buffer, Column column) {
        if (column.getType().getLengthStrategy() == LengthStrategy.PARTLENTYPE) {
            return RowToken.canDecodePlp(buffer, column);
        }
        return RowToken.doCanDecode(buffer, column);
    }

    private static boolean doCanDecode(ByteBuf buffer, Column column) {
        if (!Length.canDecode(buffer, column.getType())) {
            return false;
        }
        int startRead = buffer.readerIndex();
        Length length = Length.decode(buffer, column.getType());
        int endRead = buffer.readerIndex();
        int descriptorLength = endRead - startRead;
        int dataLength = descriptorLength + length.getLength();
        int adjusted = dataLength - descriptorLength;
        if (buffer.readableBytes() >= adjusted) {
            buffer.skipBytes(adjusted);
            return true;
        }
        return false;
    }

    private static boolean canDecodePlp(ByteBuf buffer, Column column) {
        if (!PlpLength.canDecode(buffer, column.getType())) {
            return false;
        }
        PlpLength totalLength = PlpLength.decode(buffer, column.getType());
        if (totalLength.isNull()) {
            return true;
        }
        while (true) {
            if (!Length.canDecode(buffer, column.getType())) {
                return false;
            }
            Length chunkLength = Length.decode(buffer, column.getType());
            if (chunkLength.getLength() == 0) {
                return true;
            }
            if (buffer.readableBytes() < chunkLength.getLength()) break;
            buffer.skipBytes(chunkLength.getLength());
        }
        return false;
    }

    private static RowToken doDecode(ByteBuf buffer, Column[] columns) {
        ByteBuf[] data = new ByteBuf[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            data[i] = RowToken.decodeColumnData(buffer, columns[i]);
        }
        return new RowToken(data);
    }

    @Nullable
    static ByteBuf decodeColumnData(ByteBuf buffer, Column column) {
        if (column.getType().getLengthStrategy() == LengthStrategy.PARTLENTYPE) {
            buffer.markReaderIndex();
            return RowToken.doDecodePlp(buffer, column);
        }
        return RowToken.doDecode(buffer, column);
    }

    @Nullable
    private static ByteBuf doDecode(ByteBuf buffer, Column column) {
        int startRead = buffer.readerIndex();
        Length length = Length.decode(buffer, column.getType());
        if (length.isNull()) {
            return null;
        }
        int endRead = buffer.readerIndex();
        int descriptorLength = endRead - startRead;
        buffer.readerIndex(startRead);
        return buffer.readRetainedSlice(descriptorLength + length.getLength());
    }

    @Nullable
    private static ByteBuf doDecodePlp(ByteBuf buffer, Column column) {
        Length chunkLength;
        PlpLength totalLength = PlpLength.decode(buffer, column.getType());
        if (totalLength.isNull()) {
            return null;
        }
        CompositeByteBuf plpData = buffer.alloc().compositeBuffer();
        ByteBuf length = buffer.alloc().buffer(8);
        totalLength.encode(length);
        plpData.addComponent(true, length);
        while ((chunkLength = Length.decode(buffer, column.getType())).getLength() != 0) {
            length = buffer.alloc().buffer(4);
            chunkLength.encode(length, column.getType());
            plpData.addComponent(true, length);
            plpData.addComponent(true, buffer.readRetainedSlice(chunkLength.getLength()));
        }
        return plpData;
    }

    @Nullable
    public ByteBuf getColumnData(int index) {
        return this.data[index];
    }

    @Override
    public byte getType() {
        return -47;
    }

    @Override
    public String getName() {
        return "ROW";
    }

    public RowToken touch(Object hint) {
        return this;
    }

    protected void deallocate() {
        for (ByteBuf datum : this.data) {
            ReferenceCountUtil.release((Object)datum);
        }
    }
}

